/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.pointcut.MatcherHelper;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.ast.ASTAll;
import org.jboss.aop.pointcut.ast.ASTAttribute;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ASTParameter;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ClassExpression;

public class MethodMatcher
extends MatcherHelper {
    protected Advisor advisor;
    protected CtMethod ctMethod;
    protected Method refMethod;
    protected int methodModifiers;
    protected String classname;
    protected String methodName;

    public MethodMatcher(Advisor advisor, CtMethod method, ASTStart start) {
        super(start, advisor.getManager());
        this.advisor = advisor;
        this.start = start;
        this.methodModifiers = method.getModifiers();
        this.classname = method.getDeclaringClass().getName();
        this.ctMethod = method;
        this.methodName = this.ctMethod.getName();
    }

    public MethodMatcher(Advisor advisor, Method method, ASTStart start) {
        super(start, advisor.getManager());
        this.advisor = advisor;
        this.start = start;
        this.methodModifiers = method.getModifiers();
        this.classname = method.getDeclaringClass().getName();
        this.refMethod = method;
        this.methodName = this.refMethod.getName();
    }

    protected Boolean resolvePointcut(Pointcut p) {
        throw new RuntimeException("SHOULD NOT BE CALLED");
    }

    public Object visit(ASTMethod node, Object data) {
        return this.matches(node);
    }

    public Boolean matches(ASTMethod node) {
        Class<?>[] params;
        block36: {
            if (node.getAttributes().size() > 0) {
                for (int i = 0; i < node.getAttributes().size(); ++i) {
                    ASTAttribute attr = (ASTAttribute)node.getAttributes().get(i);
                    if (Util.matchModifiers(attr, this.methodModifiers)) continue;
                    return Boolean.FALSE;
                }
            }
            try {
                if (this.ctMethod != null) {
                    if (!Util.matchesClassExpr(node.getReturnType(), this.ctMethod.getReturnType(), this.advisor)) {
                        return Boolean.FALSE;
                    }
                    if (!Util.matchesClassExpr(node.getClazz(), this.ctMethod.getDeclaringClass(), this.advisor)) {
                        return Boolean.FALSE;
                    }
                } else {
                    if (!Util.matchesClassExpr(node.getReturnType(), this.refMethod.getReturnType(), this.advisor)) {
                        return Boolean.FALSE;
                    }
                    if (!Util.matchesClassExpr(node.getClazz(), this.refMethod.getDeclaringClass(), this.advisor)) {
                        return Boolean.FALSE;
                    }
                }
            }
            catch (NotFoundException nfe) {
                throw new RuntimeException(nfe);
            }
            if (node.getMethodIdentifier().isAnnotation()) {
                if (this.advisor == null) {
                    return Boolean.FALSE;
                }
                String sub = node.getMethodIdentifier().getOriginal().substring(1);
                if (this.ctMethod != null) {
                    if (!(this.advisor.getMethodMetaData().hasGroup(this.ctMethod, sub) || this.advisor.getDefaultMetaData().hasTag(sub) || this.advisor.hasAnnotation(this.ctMethod, sub))) {
                        return Boolean.FALSE;
                    }
                } else if (!this.advisor.getMethodMetaData().hasTag(this.refMethod, sub) && !this.advisor.getDefaultMetaData().hasTag(sub)) {
                    try {
                        if (!this.advisor.hasAnnotation(this.refMethod, sub)) {
                            return Boolean.FALSE;
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            } else if (!node.getMethodIdentifier().matches(this.methodName)) {
                return Boolean.FALSE;
            }
            ArrayList nodeExceptions = node.getExceptions();
            if (this.ctMethod != null) {
                try {
                    if (!Util.matchExceptions(nodeExceptions, this.ctMethod.getExceptionTypes())) {
                        return Boolean.FALSE;
                    }
                    break block36;
                }
                catch (NotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!Util.matchExceptions(nodeExceptions, this.refMethod.getExceptionTypes())) {
                return Boolean.FALSE;
            }
        }
        if (node.isAnyParameters()) {
            return Boolean.TRUE;
        }
        if (this.ctMethod != null) {
            try {
                if (node.getParameters().size() != this.ctMethod.getParameterTypes().length) {
                    return Boolean.FALSE;
                }
                params = this.ctMethod.getParameterTypes();
                for (int i = 0; i < params.length; ++i) {
                    ASTParameter ast = (ASTParameter)node.getParameters().get(i);
                    ClassExpression exp = ast.getType();
                    if (Util.matchesClassExpr(exp, params[i], this.advisor)) continue;
                    return Boolean.FALSE;
                }
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            if (node.getParameters().size() != this.refMethod.getParameterTypes().length) {
                return Boolean.FALSE;
            }
            params = this.refMethod.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                String asString;
                ASTParameter ast = (ASTParameter)node.getParameters().get(i);
                ClassExpression exp = ast.getType();
                if (!(exp.isSimple() ? !exp.matches(asString = ClassExpression.simpleType(params[i])) : !Util.matchesClassExpr(exp, params[i], this.advisor))) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public Object visit(ASTAll node, Object data) {
        block20: {
            if (node.getClazz().isAnnotation()) {
                String sub = node.getClazz().getOriginal().substring(1);
                if (this.ctMethod != null) {
                    if (!(this.advisor.getMethodMetaData().hasGroup(this.ctMethod, sub) || this.advisor.getDefaultMetaData().hasTag(sub) || this.advisor.hasAnnotation(this.ctMethod, sub))) {
                        return Boolean.FALSE;
                    }
                } else if (!this.advisor.getMethodMetaData().hasTag(this.refMethod, sub) && !this.advisor.getDefaultMetaData().hasTag(sub)) {
                    try {
                        if (!this.advisor.hasAnnotation(this.refMethod, sub)) {
                            return Boolean.FALSE;
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            } else if (node.getClazz().isInstanceOf()) {
                if (this.ctMethod != null ? !Util.subtypeOf(this.ctMethod.getDeclaringClass(), node.getClazz()) : !Util.subtypeOf(this.refMethod.getDeclaringClass(), node.getClazz())) {
                    return Boolean.FALSE;
                }
            } else if (node.getClazz().isTypedef()) {
                if (this.ctMethod != null) {
                    try {
                        if (!Util.matchesTypedef(this.ctMethod.getDeclaringClass(), node.getClazz(), this.advisor)) {
                            return Boolean.FALSE;
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!Util.matchesTypedef(this.refMethod.getDeclaringClass(), node.getClazz(), this.advisor)) {
                    return Boolean.FALSE;
                }
            } else if (!node.getClazz().matches(this.classname)) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }
}

