/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.metadata;

import java.lang.reflect.Method;
import java.util.Iterator;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.aop.util.XmlHelper;
import org.w3c.dom.Element;

public class MethodConfig {
    String methodName = null;
    String signature = null;

    public boolean patternMatches(Method method) {
        if (this.methodName.equals("*")) {
            return true;
        }
        if (!this.methodName.equals(method.getName())) {
            return false;
        }
        if (this.signature == null) {
            return true;
        }
        String sig = MethodConfig.getSignature(method.getParameterTypes());
        return sig.equals(this.signature);
    }

    public boolean patternMatches(CtMethod method) throws NotFoundException {
        if (this.methodName.equals("*")) {
            return true;
        }
        if (!this.methodName.equals(method.getName())) {
            return false;
        }
        if (this.signature == null) {
            return true;
        }
        String sig = MethodConfig.getSignature(method.getParameterTypes());
        return sig.equals(this.signature);
    }

    public void importXml(Element element) throws Exception {
        this.methodName = XmlHelper.getElementContent(XmlHelper.getUniqueChild(element, "method-name"));
        this.signature = "(";
        Element paramsElement = XmlHelper.getOptionalChild(element, "method-params");
        if (paramsElement != null) {
            Iterator paramsIterator = XmlHelper.getChildrenByTagName(paramsElement, "method-param");
            while (paramsIterator.hasNext()) {
                this.signature = this.signature + XmlHelper.getElementContent((Element)paramsIterator.next());
                this.signature = this.signature + " ";
            }
        }
        this.signature = this.signature + ")";
    }

    public static String toGenericString(Method method) {
        StringBuffer buf = new StringBuffer();
        buf.append(method.getName());
        buf.append("(");
        MethodConfig.getSignature(method.getParameterTypes());
        buf.append(")");
        return buf.toString();
    }

    public static String getSignature(Class[] source) {
        StringBuffer sig = new StringBuffer("(");
        for (int i = 0; i < source.length; ++i) {
            String brackets = "";
            Class<?> cls = source[i];
            while (cls.isArray()) {
                brackets = brackets + "[]";
                cls = cls.getComponentType();
            }
            sig.append(cls.getName());
            sig.append(brackets);
            sig.append(" ");
        }
        sig.append(")");
        return sig.toString();
    }

    public static String getSignature(CtClass[] source) {
        StringBuffer sig = new StringBuffer("(");
        for (int i = 0; i < source.length; ++i) {
            CtClass cls = source[i];
            sig.append(cls.getName());
            sig.append(" ");
        }
        sig.append(")");
        return sig.toString();
    }

    private static String[] getClassNames(Class[] source) {
        String[] out = new String[source.length];
        return out;
    }
}

