/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.Notification;
import org.jboss.jmx.adaptor.snmp.agent.Clock;
import org.jboss.jmx.adaptor.snmp.agent.Counter;
import org.jboss.jmx.adaptor.snmp.agent.ManagerRecord;
import org.jboss.jmx.adaptor.snmp.agent.MappingFailedException;
import org.jboss.jmx.adaptor.snmp.agent.TrapFactory;
import org.jboss.jmx.adaptor.snmp.config.manager.Manager;
import org.jboss.logging.Logger;
import org.jboss.xml.binding.MappingObjectModelFactory;
import org.jboss.xml.binding.ObjectModelFactory;
import org.jboss.xml.binding.Unmarshaller;
import org.opennms.protocols.snmp.SnmpIPAddress;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduTrap;

public class TrapEmitter {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$jmx$adaptor$snmp$agent$TrapEmitter == null ? (class$org$jboss$jmx$adaptor$snmp$agent$TrapEmitter = TrapEmitter.class$("org.jboss.jmx.adaptor.snmp.agent.TrapEmitter")) : class$org$jboss$jmx$adaptor$snmp$agent$TrapEmitter));
    private TrapFactory trapFactory = null;
    private String trapFactoryClassName = null;
    private String managersResName = null;
    private String notificationMapResName = null;
    private Counter trapCount = null;
    private Clock uptime = null;
    private Set managers = Collections.synchronizedSet(new HashSet());
    static /* synthetic */ Class class$org$jboss$jmx$adaptor$snmp$agent$TrapEmitter;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$org$jboss$jmx$adaptor$snmp$config$manager$Manager;

    public TrapEmitter(String trapFactoryClassName, Counter trapCount, Clock uptime, String managersResName, String notificationMapResName) {
        this.trapFactoryClassName = trapFactoryClassName;
        this.trapCount = trapCount;
        this.uptime = uptime;
        this.managersResName = managersResName;
        this.notificationMapResName = notificationMapResName;
    }

    public void start() throws Exception {
        this.load();
        this.trapFactory = (TrapFactory)Class.forName(this.trapFactoryClassName, true, this.getClass().getClassLoader()).newInstance();
        this.trapFactory.set(this.notificationMapResName, this.uptime, this.trapCount);
        this.trapFactory.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Set set = this.managers;
        synchronized (set) {
            Iterator i = this.managers.iterator();
            while (i.hasNext()) {
                ManagerRecord s = (ManagerRecord)i.next();
                s.closeSession();
            }
            this.managers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Notification n) throws Exception {
        TrapFactory trapFactory = this.trapFactory;
        synchronized (trapFactory) {
            if (this.trapFactory == null) {
                log.error((Object)"Received notifications before trap factory set. Discarding.");
                return;
            }
        }
        SnmpPduTrap v1TrapPdu = null;
        SnmpPduPacket v2TrapPdu = null;
        Set set = this.managers;
        synchronized (set) {
            Iterator i = this.managers.iterator();
            while (i.hasNext()) {
                ManagerRecord s = (ManagerRecord)i.next();
                try {
                    switch (s.getVersion()) {
                        case 1: {
                            if (v1TrapPdu == null) {
                                v1TrapPdu = this.trapFactory.generateV1Trap(n);
                            }
                            v1TrapPdu.setAgentAddress(new SnmpIPAddress(s.getLocalAddress()));
                            this.trapCount.advance();
                            s.getSession().send(v1TrapPdu);
                            break;
                        }
                        case 2: {
                            if (v2TrapPdu == null) {
                                v2TrapPdu = this.trapFactory.generateV2Trap(n);
                            }
                            this.trapCount.advance();
                            s.getSession().send(v2TrapPdu);
                            break;
                        }
                        default: {
                            log.error((Object)"Skipping session: Unknown SNMP version found");
                            break;
                        }
                    }
                }
                catch (MappingFailedException e) {
                    log.error((Object)("Translating notification - " + e.getMessage()));
                }
                catch (Exception e) {
                    log.error((Object)("SNMP send error for " + s.getAddress().toString() + ":" + s.getPort() + ": <" + e + ">"));
                }
            }
        }
    }

    private void load() throws Exception {
        log.debug((Object)("Reading resource: '" + this.managersResName + "'"));
        MappingObjectModelFactory momf = new MappingObjectModelFactory();
        momf.mapElementToClass("manager-list", class$java$util$ArrayList == null ? (class$java$util$ArrayList = TrapEmitter.class$("java.util.ArrayList")) : class$java$util$ArrayList);
        momf.mapElementToClass("manager", class$org$jboss$jmx$adaptor$snmp$config$manager$Manager == null ? (class$org$jboss$jmx$adaptor$snmp$config$manager$Manager = TrapEmitter.class$("org.jboss.jmx.adaptor.snmp.config.manager.Manager")) : class$org$jboss$jmx$adaptor$snmp$config$manager$Manager);
        ArrayList managerList = null;
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(this.managersResName);
            Unmarshaller unmarshaller = new Unmarshaller();
            managerList = (ArrayList)unmarshaller.unmarshal(is, (ObjectModelFactory)momf, null);
        }
        catch (Exception e) {
            log.error((Object)("Accessing resource '" + this.managersResName + "'"));
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        log.debug((Object)("Found " + managerList.size() + " monitoring managers"));
        Iterator i = managerList.iterator();
        while (i.hasNext()) {
            Manager m = (Manager)i.next();
            try {
                ManagerRecord mr = new ManagerRecord(InetAddress.getByName(m.getAddress()), m.getPort(), this.toInetAddressWithDefaultBinding(m.getLocalAddress()), m.getLocalPort(), m.getVersion());
                if (!this.managers.add(mr)) {
                    log.warn((Object)("Ignoring duplicate manager: " + m));
                    continue;
                }
                mr.openSession();
            }
            catch (Exception e) {
                log.warn((Object)("Error enabling monitoring manager: " + m), (Throwable)e);
            }
        }
    }

    private InetAddress toInetAddressWithDefaultBinding(String host) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            String defaultBindAddress = System.getProperty("jboss.bind.address");
            if (defaultBindAddress != null && !defaultBindAddress.equals("0.0.0.0")) {
                return InetAddress.getByName(defaultBindAddress);
            }
            return InetAddress.getLocalHost();
        }
        return InetAddress.getByName(host);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

