/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.net.InetAddress;
import java.net.SocketException;
import org.jboss.jmx.adaptor.snmp.agent.BadSnmpVersionException;
import org.jboss.logging.Logger;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;

class ManagerRecord
implements SnmpHandler {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$jmx$adaptor$snmp$agent$ManagerRecord == null ? (class$org$jboss$jmx$adaptor$snmp$agent$ManagerRecord = ManagerRecord.class$("org.jboss.jmx.adaptor.snmp.agent.ManagerRecord")) : class$org$jboss$jmx$adaptor$snmp$agent$ManagerRecord));
    private int retries = 10;
    private int timeout = 5000;
    private InetAddress address;
    private int port;
    private InetAddress localAddress;
    private int localPort;
    private int version;
    private final String readCommunity = "public";
    private transient SnmpSession session;
    static /* synthetic */ Class class$org$jboss$jmx$adaptor$snmp$agent$ManagerRecord;

    public ManagerRecord(InetAddress address, int port, InetAddress localAddress, int localPort, int version) throws BadSnmpVersionException {
        this.address = address;
        this.port = port;
        this.localAddress = localAddress;
        this.localPort = localPort;
        switch (version) {
            case 1: 
            case 2: {
                this.version = version;
                break;
            }
            default: {
                throw new BadSnmpVersionException("Bad SNMP Version: " + version);
            }
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public int getVersion() {
        return this.version;
    }

    public void openSession() throws SocketException {
        SnmpPeer peer = new SnmpPeer(this.address, this.port, this.localAddress, this.localPort);
        peer.setRetries(this.retries);
        peer.setTimeout(this.timeout);
        SnmpParameters parameters = peer.getParameters();
        switch (this.version) {
            case 1: {
                parameters.setVersion(0);
                break;
            }
            case 2: {
                parameters.setVersion(1);
                break;
            }
            default: {
                parameters.setVersion(0);
            }
        }
        parameters.setReadCommunity(this.readCommunity);
        peer.setParameters(parameters);
        this.session = new SnmpSession(peer);
        this.session.setDefaultHandler((SnmpHandler)this);
    }

    public void closeSession() {
        this.session.close();
    }

    public SnmpSession getSession() {
        return this.session;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManagerRecord)) {
            return false;
        }
        ManagerRecord other = (ManagerRecord)o;
        return this.port == other.port && this.address.equals(other.address) && this.version == other.version;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return new String(this.address + ":" + this.port + " (" + this.version + ")");
    }

    public void snmpInternalError(SnmpSession session, int err, SnmpSyntax pdu) {
        log.error((Object)("ManagerRecord::snmpInternalError, code: " + err));
    }

    public void snmpTimeoutError(SnmpSession session, SnmpSyntax pdu) {
        log.error((Object)"ManagerRecord::snmpTimeoutError");
    }

    public void snmpReceivedPdu(SnmpSession session, int cmd, SnmpPduPacket pdu) {
        log.error((Object)"ManagerRecord::snmpReceivedPdu");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

