/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.joinpoint;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.aop.CallerConstructorInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.CallerInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocationWrapper;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.util.MethodHashing;

public class ConstructorCalledByMethodInvocation
extends CallerInvocation {
    protected Object[] arguments = null;
    protected long callingMethodHash;
    protected CallerConstructorInfo info;
    protected Class callingClass;
    protected Method callingMethod;
    protected Object callingObject;

    public ConstructorCalledByMethodInvocation(Interceptor[] interceptors, CallerConstructorInfo info, long callingHash, Class callingClass, Object[] args, Object callingObject) {
        super(interceptors);
        this.info = info;
        this.callingMethodHash = callingHash;
        this.callingClass = callingClass;
        this.arguments = args;
        this.callingObject = callingObject;
    }

    protected ConstructorCalledByMethodInvocation(Interceptor[] interceptors) {
        super(interceptors);
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public Class getCallingClass() {
        return this.callingClass;
    }

    public Method getCallingMethod() {
        if (this.callingMethod != null) {
            return this.callingMethod;
        }
        try {
            this.callingMethod = MethodHashing.findMethodByHash(this.callingClass, this.callingMethodHash);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.callingMethod;
    }

    public Constructor getCalledConstructor() {
        return this.info.constructor;
    }

    public boolean isWrapped() {
        return this.info.wrappingMethod != null;
    }

    public Method getWrappingMethod() {
        return this.info.wrappingMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeNext() throws Throwable {
        if (this.interceptors != null && this.currentInterceptor < this.interceptors.length) {
            try {
                Object object = this.interceptors[this.currentInterceptor++].invoke(this);
                return object;
            }
            finally {
                --this.currentInterceptor;
            }
        }
        if (this.info.wrappingMethod != null) {
            try {
                return this.info.wrappingMethod.invoke(null, this.arguments);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        try {
            return this.info.constructor.newInstance(this.arguments);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public Object getMetaData(Object group, Object attr) {
        Object val = super.getMetaData(group, attr);
        if (val != null) {
            return val;
        }
        return null;
    }

    public Invocation getWrapper(Interceptor[] newchain) {
        ConstructorCalledByMethodInvocationWrapper wrapper = new ConstructorCalledByMethodInvocationWrapper(this, newchain);
        return wrapper;
    }

    public Invocation copy() {
        ConstructorCalledByMethodInvocation wrapper = new ConstructorCalledByMethodInvocation(this.interceptors, this.info, this.callingMethodHash, this.callingClass, this.arguments, this.callingObject);
        wrapper.setAdvisor(this.getAdvisor());
        wrapper.setTargetObject(this.getTargetObject());
        wrapper.metadata = this.metadata;
        wrapper.instanceResolver = this.instanceResolver;
        wrapper.currentInterceptor = this.currentInterceptor;
        return wrapper;
    }

    public Object getCallingObject() {
        return this.callingObject;
    }
}

