/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.metadata.SimpleMetaData;

public class ClassInstanceAdvisor
implements InstanceAdvisor,
Serializable {
    protected ArrayList insertedInterceptors = null;
    protected ArrayList appendedInterceptors = null;
    protected SimpleMetaData metadata;
    protected Object instance;
    protected transient Advised advised;
    protected transient Advisor advisor;
    public boolean hasInstanceAspects = false;
    protected transient WeakHashMap aspects;
    protected transient WeakHashMap joinpointAspects;

    public ClassInstanceAdvisor() {
    }

    public ClassInstanceAdvisor(Object obj) {
        this.instance = obj;
        if (this.instance instanceof Advised) {
            this.advised = (Advised)this.instance;
            this.advisor = this.advised._getAdvisor();
            if (this.advisor instanceof ClassAdvisor) {
                this.initializeAspects();
                this.initializeJoinpointAspects();
            }
        } else {
            this.advised = null;
        }
    }

    protected synchronized void initializeAspects() {
        if (this.advisor == null) {
            return;
        }
        if (this.aspects != null) {
            return;
        }
        ClassAdvisor cadvisor = (ClassAdvisor)this.advisor;
        Set defs = cadvisor.getPerInstanceAspectDefinitions();
        if (defs.size() > 0) {
            this.aspects = new WeakHashMap();
            Iterator it = defs.iterator();
            while (it.hasNext()) {
                AspectDefinition def = (AspectDefinition)it.next();
                Object aspect = def.getFactory().createPerInstance(this.advisor, this);
                this.aspects.put(def, aspect);
            }
        }
    }

    private synchronized void initializeJoinpointAspects() {
        if (this.advisor == null) {
            return;
        }
        if (this.joinpointAspects != null) {
            return;
        }
        ClassAdvisor cadvisor = (ClassAdvisor)this.advisor;
        Map jpAspects = cadvisor.getPerInstanceJoinpointAspectDefinitions();
        if (jpAspects.size() > 0) {
            this.joinpointAspects = new WeakHashMap();
            Iterator it = jpAspects.keySet().iterator();
            while (it.hasNext()) {
                AspectDefinition def = (AspectDefinition)it.next();
                ConcurrentReaderHashMap joins = new ConcurrentReaderHashMap();
                this.joinpointAspects.put(def, joins);
                Set joinpoints = (Set)jpAspects.get(def);
                Iterator jps = joinpoints.iterator();
                while (jps.hasNext()) {
                    Object joinpoint = jps.next();
                    joins.put(joinpoint, def.getFactory().createPerJoinpoint(this.advisor, this, (Joinpoint)joinpoint));
                }
            }
        }
    }

    public Object getPerInstanceAspect(String def) {
        Iterator it = this.aspects.keySet().iterator();
        while (it.hasNext()) {
            AspectDefinition d = (AspectDefinition)it.next();
            if (!d.getName().equals(def)) continue;
            return this.aspects.get(d);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPerInstanceAspect(AspectDefinition def) {
        if (this.aspects == null) {
            this.initializeAspects();
            return this.aspects.get(def);
        }
        Object aspect = this.aspects.get(def);
        if (aspect == null) {
            ClassInstanceAdvisor classInstanceAdvisor = this;
            synchronized (classInstanceAdvisor) {
                aspect = this.aspects.get(def);
                if (aspect != null) {
                    return aspect;
                }
                if (this.advisor != null && this.advisor instanceof ClassAdvisor) {
                    ClassAdvisor cadvisor = (ClassAdvisor)this.advisor;
                    cadvisor.getPerInstanceAspectDefinitions().add(def);
                    aspect = def.getFactory().createPerInstance(null, null);
                    WeakHashMap copy = new WeakHashMap(this.aspects);
                    copy.put(def, aspect);
                    this.aspects = copy;
                }
            }
        }
        return aspect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition def) {
        if (this.joinpointAspects == null) {
            this.initializeJoinpointAspects();
            return this.getJoinpointAspect(def, joinpoint);
        }
        Object aspect = this.getJoinpointAspect(def, joinpoint);
        if (aspect == null) {
            ClassInstanceAdvisor classInstanceAdvisor = this;
            synchronized (classInstanceAdvisor) {
                aspect = this.getJoinpointAspect(def, joinpoint);
                if (aspect != null) {
                    return aspect;
                }
                if (this.advisor != null && this.advisor instanceof ClassAdvisor) {
                    ClassAdvisor cadvisor = (ClassAdvisor)this.advisor;
                    cadvisor.addPerInstanceJoinpointAspect(joinpoint, def);
                    aspect = def.getFactory().createPerJoinpoint(this.advisor, this, joinpoint);
                    WeakHashMap copy = new WeakHashMap(this.joinpointAspects);
                    Map map = (Map)copy.get(def);
                    if (map == null) {
                        map = new ConcurrentReaderHashMap();
                    }
                    map.put(joinpoint, aspect);
                    this.joinpointAspects = copy;
                }
            }
        }
        return aspect;
    }

    private Object getJoinpointAspect(AspectDefinition def, Joinpoint joinpoint) {
        if (this.joinpointAspects == null) {
            return null;
        }
        Map map = (Map)this.joinpointAspects.get(def);
        Object aspect = map.get(joinpoint);
        return aspect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleMetaData getMetaData() {
        if (this.metadata == null) {
            ClassInstanceAdvisor classInstanceAdvisor = this;
            synchronized (classInstanceAdvisor) {
                if (this.metadata == null) {
                    this.metadata = new SimpleMetaData();
                }
            }
        }
        return this.metadata;
    }

    public Interceptor[] getInterceptors() {
        ArrayList newlist = new ArrayList();
        if (this.insertedInterceptors != null) {
            newlist.addAll(this.insertedInterceptors);
        }
        if (this.appendedInterceptors != null) {
            newlist.addAll(this.appendedInterceptors);
        }
        return newlist.toArray(new Interceptor[newlist.size()]);
    }

    public Interceptor[] getInterceptors(Interceptor[] advisorChain) {
        if (this.insertedInterceptors == null && this.appendedInterceptors == null) {
            return advisorChain;
        }
        ArrayList<Interceptor> newlist = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null) {
            newlist.addAll(this.insertedInterceptors);
        }
        if (advisorChain != null) {
            newlist.addAll(Arrays.asList(advisorChain));
        }
        if (this.appendedInterceptors != null) {
            newlist.addAll(this.appendedInterceptors);
        }
        return newlist.toArray(new Interceptor[newlist.size()]);
    }

    public void insertInterceptor(int index, Interceptor interceptor) {
        ArrayList<Interceptor> newList = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null) {
            newList.addAll(this.insertedInterceptors);
        }
        newList.add(index, interceptor);
        this.insertedInterceptors = newList;
        this.hasInstanceAspects = true;
    }

    public void insertInterceptor(Interceptor interceptor) {
        ArrayList<Interceptor> newList = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null) {
            newList.addAll(this.insertedInterceptors);
        }
        newList.add(interceptor);
        this.insertedInterceptors = newList;
        this.hasInstanceAspects = true;
    }

    public void appendInterceptor(Interceptor interceptor) {
        ArrayList<Interceptor> newList = new ArrayList<Interceptor>();
        if (this.appendedInterceptors != null) {
            newList.addAll(this.appendedInterceptors);
        }
        newList.add(interceptor);
        this.appendedInterceptors = newList;
        this.hasInstanceAspects = true;
    }

    public void appendInterceptor(int index, Interceptor interceptor) {
        ArrayList<Interceptor> newList = new ArrayList<Interceptor>();
        if (this.appendedInterceptors != null) {
            newList.addAll(this.appendedInterceptors);
        }
        newList.add(index, interceptor);
        this.appendedInterceptors = newList;
        this.hasInstanceAspects = true;
    }

    public void removeInterceptor(String name) {
        ArrayList newList;
        Interceptor interceptor;
        int i;
        if (this.insertedInterceptors != null) {
            for (i = 0; i < this.insertedInterceptors.size(); ++i) {
                interceptor = (Interceptor)this.insertedInterceptors.get(i);
                if (!interceptor.getName().equals(name)) continue;
                newList = new ArrayList();
                newList.addAll(this.insertedInterceptors);
                newList.remove(i);
                this.insertedInterceptors = newList;
            }
        }
        if (this.appendedInterceptors != null) {
            for (i = 0; i < this.appendedInterceptors.size(); ++i) {
                interceptor = (Interceptor)this.appendedInterceptors.get(i);
                if (!interceptor.getName().equals(name)) continue;
                newList = new ArrayList();
                newList.addAll(this.appendedInterceptors);
                newList.remove(i);
                this.appendedInterceptors = newList;
            }
        }
        this.hasInstanceAspects = this.insertedInterceptors != null && this.insertedInterceptors.size() > 0 || this.appendedInterceptors != null && this.appendedInterceptors.size() > 0;
    }

    public final boolean hasAspects() {
        return this.hasInstanceAspects;
    }

    public void insertInterceptorStack(String stackName) {
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        if (stack == null) {
            throw new RuntimeException("Stack " + stackName + " not found.");
        }
        ClassAdvisor classAdvisor = null;
        if (this.instance instanceof Advised) {
            Advised advised = (Advised)this.instance;
            classAdvisor = (ClassAdvisor)advised._getAdvisor();
        }
        Iterator it = stack.getInterceptorFactories().iterator();
        while (it.hasNext()) {
            InterceptorFactory factory = (InterceptorFactory)it.next();
            if (!factory.isDeployed()) continue;
            Interceptor interceptor = factory.create(classAdvisor, null);
            this.insertInterceptor(interceptor);
        }
    }

    public void appendInterceptorStack(String stackName) {
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        if (stack == null) {
            throw new RuntimeException("Stack " + stackName + " not found.");
        }
        ClassAdvisor classAdvisor = null;
        if (this.instance instanceof Advised) {
            Advised advised = (Advised)this.instance;
            classAdvisor = (ClassAdvisor)advised._getAdvisor();
        }
        Iterator it = stack.getInterceptorFactories().iterator();
        while (it.hasNext()) {
            InterceptorFactory factory = (InterceptorFactory)it.next();
            if (!factory.isDeployed()) continue;
            Interceptor interceptor = factory.create(classAdvisor, null);
            this.appendInterceptor(interceptor);
        }
    }

    public void removeInterceptorStack(String stackName) {
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        if (stack == null) {
            throw new RuntimeException("Stack " + stackName + " not found.");
        }
        ClassAdvisor classAdvisor = null;
        if (this.instance instanceof Advised) {
            Advised advised = (Advised)this.instance;
            classAdvisor = (ClassAdvisor)advised._getAdvisor();
        }
        Iterator it = stack.getInterceptorFactories().iterator();
        while (it.hasNext()) {
            InterceptorFactory factory = (InterceptorFactory)it.next();
            if (!factory.isDeployed()) continue;
            Interceptor interceptor = factory.create(classAdvisor, null);
            this.removeInterceptor(interceptor.getName());
        }
    }
}

