/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
import gnu.trove.TLongObjectHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import org.jboss.aop.Advised;
import org.jboss.aop.AspectManager;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.CFlowInterceptor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.PrecedenceSorter;
import org.jboss.aop.annotation.AnnotationElement;
import org.jboss.aop.annotation.AnnotationRepository;
import org.jboss.aop.introduction.AnnotationIntroduction;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.joinpoint.ConstructorJoinpoint;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ConstructorMetaData;
import org.jboss.aop.metadata.FieldMetaData;
import org.jboss.aop.metadata.MethodMetaData;
import org.jboss.aop.metadata.SimpleMetaData;

public abstract class Advisor {
    protected HashSet adviceBindings = new HashSet();
    protected ArrayList interfaceIntroductions = new ArrayList();
    protected ArrayList classMetaDataBindings = new ArrayList();
    protected SimpleMetaData defaultMetaData = new SimpleMetaData();
    protected MethodMetaData methodMetaData = new MethodMetaData();
    protected FieldMetaData fieldMetaData = new FieldMetaData();
    protected SimpleMetaData classMetaData = new SimpleMetaData();
    protected ConstructorMetaData constructorMetaData = new ConstructorMetaData();
    protected HashMap classAnnotations = new HashMap();
    protected AnnotationRepository annotations = new AnnotationRepository();
    public boolean doesHaveAspects = false;
    protected String name;
    protected ConcurrentReaderHashMap aspects = new ConcurrentReaderHashMap();
    protected HashMap adviceInterceptors = new HashMap();
    protected CopyOnWriteArraySet perInstanceAspectDefinitions = new CopyOnWriteArraySet();
    protected ConcurrentReaderHashMap perInstanceJoinpointAspectDefinitions = new ConcurrentReaderHashMap();
    static Class cl = String.class;
    protected TLongObjectHashMap advisedMethods = new TLongObjectHashMap();
    protected TLongObjectHashMap methodInterceptors = new TLongObjectHashMap();
    protected AspectManager manager;
    protected Class clazz = null;
    protected Constructor[] constructors;
    protected Interceptor[][] constructorInterceptors;

    public Advisor(String name, AspectManager manager) {
        this.name = name;
        this.manager = manager;
    }

    public AspectManager getManager() {
        return this.manager;
    }

    public List getClassMetadataBindings() {
        return this.classMetaDataBindings;
    }

    public SimpleMetaData getClassMetaData() {
        return this.classMetaData;
    }

    public SimpleMetaData getDefaultMetaData() {
        return this.defaultMetaData;
    }

    public MethodMetaData getMethodMetaData() {
        return this.methodMetaData;
    }

    public FieldMetaData getFieldMetaData() {
        return this.fieldMetaData;
    }

    public ConstructorMetaData getConstructorMetaData() {
        return this.constructorMetaData;
    }

    public void deployAnnotationOverrides() {
        Iterator it = this.getManager().getAnnotationOverrides();
        while (it.hasNext()) {
            AnnotationIntroduction introduction = (AnnotationIntroduction)it.next();
            if (introduction.matches(this, this.clazz)) {
                this.annotations.addClassAnnotation(introduction.getAnnotation().getIdentifier(), introduction.getOriginalAnnotationExpr());
            }
            Class theClass = this.clazz;
            this.deployMethodAnnotationOverrides(theClass, introduction);
            Field[] fields = theClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!introduction.matches(this, fields[i])) continue;
                this.annotations.addAnnotation((Member)fields[i], introduction.getAnnotation().getIdentifier(), (Object)introduction.getOriginalAnnotationExpr());
            }
            Constructor<?>[] cons = theClass.getDeclaredConstructors();
            for (int i = 0; i < cons.length; ++i) {
                if (!introduction.matches(this, cons[i])) continue;
                this.annotations.addAnnotation(cons[i], introduction.getAnnotation().getIdentifier(), (Object)introduction.getOriginalAnnotationExpr());
            }
        }
    }

    protected void deployMethodAnnotationOverrides(Class theClass, AnnotationIntroduction introduction) {
        if (theClass.getSuperclass() != null) {
            this.deployMethodAnnotationOverrides(theClass.getSuperclass(), introduction);
        }
        Method[] methods = theClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!introduction.matches(this, methods[i])) continue;
            this.annotations.addAnnotation((Member)methods[i], introduction.getAnnotation().getIdentifier(), (Object)introduction.getOriginalAnnotationExpr());
        }
    }

    public AnnotationRepository getAnnotations() {
        return this.annotations;
    }

    public Object resolveAnnotation(Class annotation) {
        Object value = this.annotations.resolveClassAnnotation(annotation);
        if (this.clazz == null) {
            return null;
        }
        if (value == null) {
            value = AnnotationElement.getVisibleAnnotation(this.clazz, annotation);
        }
        return value;
    }

    public boolean hasAnnotation(String annotation) {
        return this.hasAnnotation(this.clazz, annotation);
    }

    public boolean hasAnnotation(Class tgt, String annotation) {
        if (this.annotations.hasClassAnnotation(annotation)) {
            return true;
        }
        if (tgt == null) {
            return false;
        }
        try {
            return AnnotationElement.isAnyAnnotationPresent(tgt, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object resolveAnnotation(Method m, Class annotation) {
        Object value = this.annotations.resolveAnnotation((Member)m, annotation);
        if (value == null) {
            value = AnnotationElement.getVisibleAnnotation(m, annotation);
        }
        return value;
    }

    public Object resolveAnnotation(Field f, Class annotation) {
        Object value = this.annotations.resolveAnnotation((Member)f, annotation);
        if (value == null) {
            value = AnnotationElement.getVisibleAnnotation(f, annotation);
        }
        return value;
    }

    public Object resolveAnnotation(Constructor c, Class annotation) {
        Object value = this.annotations.resolveAnnotation((Member)c, annotation);
        if (value == null) {
            value = AnnotationElement.getVisibleAnnotation(c, annotation);
        }
        return value;
    }

    public boolean hasAnnotation(Method m, String annotation) {
        if (this.annotations.hasAnnotation((Member)m, annotation)) {
            return true;
        }
        try {
            return AnnotationElement.isAnyAnnotationPresent(m, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasAnnotation(Field m, String annotation) {
        if (this.annotations.hasAnnotation((Member)m, annotation)) {
            return true;
        }
        try {
            return AnnotationElement.isAnyAnnotationPresent(m, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasAnnotation(Constructor m, String annotation) {
        if (this.annotations.hasAnnotation((Member)m, annotation)) {
            return true;
        }
        try {
            return AnnotationElement.isAnyAnnotationPresent(m, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasAnnotation(CtClass clazz, String annotation) {
        if (this.annotations.hasClassAnnotation(annotation)) {
            return true;
        }
        try {
            return AnnotationElement.isAnyAnnotationPresent(clazz, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasAnnotation(CtMethod member, String annotation) {
        if (this.annotations.hasAnnotation((CtMember)member, annotation)) {
            return true;
        }
        return AnnotationElement.isAnyAnnotationPresent(member, annotation);
    }

    public boolean hasAnnotation(CtField member, String annotation) {
        if (this.annotations.hasAnnotation((CtMember)member, annotation)) {
            return true;
        }
        return AnnotationElement.isAnyAnnotationPresent(member, annotation);
    }

    public boolean hasAnnotation(CtConstructor member, String annotation) {
        if (this.annotations.hasAnnotation((CtMember)member, annotation)) {
            return true;
        }
        return AnnotationElement.isAnyAnnotationPresent(member, annotation);
    }

    public String getName() {
        return this.name;
    }

    public final boolean hasAspects() {
        return this.doesHaveAspects;
    }

    public synchronized void removeAdviceBinding(AdviceBinding binding) {
        this.adviceBindings.remove(binding);
        this.rebuildInterceptors();
        this.doesHaveAspects = this.adviceBindings.size() > 0;
    }

    public synchronized void removeAdviceBindings(ArrayList bindings) {
        this.adviceBindings.removeAll(bindings);
        this.rebuildInterceptors();
        this.doesHaveAspects = this.adviceBindings.size() > 0;
    }

    public synchronized void newBindingAdded() {
        this.rebuildInterceptors();
        this.doesHaveAspects = this.adviceBindings.size() > 0;
    }

    public ArrayList getInterfaceIntroductions() {
        return this.interfaceIntroductions;
    }

    public synchronized void addInterfaceIntroduction(InterfaceIntroduction pointcut) {
        this.interfaceIntroductions.add(pointcut);
    }

    public synchronized void removeInterfaceIntroduction(InterfaceIntroduction pointcut) {
        this.interfaceIntroductions.remove(pointcut);
    }

    protected abstract void rebuildInterceptors();

    public abstract void addClassMetaData(ClassMetaDataBinding var1);

    public abstract void removeClassMetaData(ClassMetaDataBinding var1);

    public void addPerInstanceAspect(AspectDefinition def) {
        this.perInstanceAspectDefinitions.add((Object)def);
    }

    public void removePerInstanceAspect(AspectDefinition def) {
        this.perInstanceAspectDefinitions.remove((Object)def);
    }

    public Set getPerInstanceAspectDefinitions() {
        return this.perInstanceAspectDefinitions;
    }

    public void addPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition def) {
        Set joinpoints = (Set)this.perInstanceJoinpointAspectDefinitions.get((Object)def);
        if (joinpoints == null) {
            joinpoints = new CopyOnWriteArraySet();
            this.perInstanceJoinpointAspectDefinitions.put((Object)def, (Object)joinpoints);
        }
        joinpoints.add(joinpoint);
    }

    public void removePerInstanceJoinpointAspect(AspectDefinition def) {
        this.perInstanceJoinpointAspectDefinitions.remove((Object)def);
    }

    public Map getPerInstanceJoinpointAspectDefinitions() {
        return this.perInstanceJoinpointAspectDefinitions;
    }

    public Object getPerClassAspect(AspectDefinition def) {
        return this.aspects.get((Object)def.getName());
    }

    public Object getPerClassAspect(String def) {
        return this.aspects.get((Object)def);
    }

    public void addPerClassAspect(AspectDefinition def) {
        if (this.aspects.containsKey((Object)def.getName())) {
            return;
        }
        Object aspect = def.getFactory().createPerClass(this);
        this.aspects.put((Object)def.getName(), aspect);
    }

    public void removePerClassAspect(AspectDefinition def) {
        this.aspects.remove((Object)def.getName());
        this.adviceInterceptors.remove(def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Interceptor getAdviceInterceptor(AspectDefinition def, String adviceName, Joinpoint joinpoint) {
        AdviceInterceptorKey key = new AdviceInterceptorKey(adviceName, joinpoint);
        HashMap hashMap = this.adviceInterceptors;
        synchronized (hashMap) {
            Map map = null;
            map = (Map)this.adviceInterceptors.get(def);
            if (map != null) {
                return (Interceptor)map.get(key);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdviceInterceptor(AspectDefinition def, String adviceName, Interceptor interceptor, Joinpoint joinpoint) {
        HashMap hashMap = this.adviceInterceptors;
        synchronized (hashMap) {
            HashMap<String, Interceptor> map = (HashMap<String, Interceptor>)this.adviceInterceptors.get(def);
            if (map == null) {
                map = new HashMap<String, Interceptor>();
                this.adviceInterceptors.put(def, map);
            }
            map.put(adviceName, interceptor);
        }
    }

    protected void createInterceptorChain(InterceptorFactory[] factories, ArrayList newinterceptors, Joinpoint joinpoint) {
        for (int i = 0; i < factories.length; ++i) {
            if (!factories[i].isDeployed()) continue;
            newinterceptors.add(factories[i].create(this, joinpoint));
        }
    }

    protected void resolveMethodPointcut(TLongObjectHashMap newMethodInterceptors, AdviceBinding binding) {
        long[] keys = this.advisedMethods.keys();
        for (int i = 0; i < keys.length; ++i) {
            Method method = (Method)this.advisedMethods.get(keys[i]);
            if (!binding.getPointcut().matchesExecution(this, method)) continue;
            this.adviceBindings.add(binding);
            if (AspectManager.verbose) {
                System.err.println("method matched binding " + binding.getPointcut().getExpr() + " " + method.toString());
            }
            binding.addAdvisor(this);
            MethodInfo info = (MethodInfo)newMethodInterceptors.get(keys[i]);
            ArrayList curr = info.interceptorChain;
            if (binding.getCFlow() != null) {
                ArrayList cflowChain = new ArrayList();
                this.createInterceptorChain(binding.getInterceptorFactories(), cflowChain, new MethodJoinpoint(method));
                Interceptor[] cflowInterceptors = cflowChain.toArray(new Interceptor[cflowChain.size()]);
                curr.add(new CFlowInterceptor(binding.getCFlowString(), binding.getCFlow(), cflowInterceptors));
                continue;
            }
            this.createInterceptorChain(binding.getInterceptorFactories(), curr, new MethodJoinpoint(method));
        }
    }

    protected void finalizeMethodChain(TLongObjectHashMap newMethodInterceptors) {
        long[] keys = newMethodInterceptors.keys();
        for (int i = 0; i < keys.length; ++i) {
            MethodInfo info = (MethodInfo)newMethodInterceptors.get(keys[i]);
            ArrayList list = info.interceptorChain;
            info.interceptors = this.applyPrecedence(list.toArray(new Interceptor[list.size()]));
            if (info.interceptors.length != 0) continue;
            info.interceptors = null;
        }
    }

    public InvocationResponse dynamicInvoke(Object target, Invocation invocation) throws Throwable {
        if (invocation instanceof MethodInvocation) {
            Interceptor[] aspects = null;
            MethodInvocation methodInvocation = (MethodInvocation)invocation;
            long hash = methodInvocation.getMethodHash();
            MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
            aspects = info.interceptors;
            if (aspects == null) {
                aspects = new Interceptor[]{};
            }
            if (target != null && target instanceof Advised) {
                InstanceAdvised advised = (InstanceAdvised)target;
                aspects = advised._getInstanceAdvisor().getInterceptors(aspects);
            }
            MethodInvocation nextInvocation = new MethodInvocation(info, aspects);
            nextInvocation.setMetaData(invocation.getMetaData());
            nextInvocation.setTargetObject(target);
            nextInvocation.setArguments(methodInvocation.getArguments());
            nextInvocation.setAdvisor(this);
            InvocationResponse response = new InvocationResponse(nextInvocation.invokeNext());
            response.setContextInfo(nextInvocation.getResponseContextInfo());
            return response;
        }
        throw new RuntimeException("dynamic field invocations not supported yet!");
    }

    public Class getClazz() {
        return this.clazz;
    }

    void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    protected ArrayList initializeConstructorChain() {
        ArrayList chain = new ArrayList(this.constructors.length);
        for (int i = 0; i < this.constructors.length; ++i) {
            ArrayList list = new ArrayList();
            chain.add(list);
        }
        return chain;
    }

    protected void finalizeConstructorChain(ArrayList newFieldInterceptors) {
        for (int i = 0; i < newFieldInterceptors.size(); ++i) {
            ArrayList list = (ArrayList)newFieldInterceptors.get(i);
            Interceptor[] chain = list.toArray(new Interceptor[list.size()]);
            if ((chain = this.applyPrecedence(chain)).length == 0) {
                chain = null;
            }
            newFieldInterceptors.set(i, chain);
        }
    }

    protected void resolveConstructorPointcut(ArrayList newConstructorInterceptors, AdviceBinding binding) {
        for (int i = 0; i < this.constructors.length; ++i) {
            Constructor constructor = this.constructors[i];
            if (!binding.getPointcut().matchesExecution(this, constructor)) continue;
            if (AspectManager.verbose) {
                System.err.println(constructor + " matched binding " + binding.getName() + " " + binding.getPointcut().getExpr());
            }
            this.adviceBindings.add(binding);
            binding.addAdvisor(this);
            ArrayList curr = (ArrayList)newConstructorInterceptors.get(i);
            if (binding.getCFlow() != null) {
                ArrayList cflowChain = new ArrayList();
                this.createInterceptorChain(binding.getInterceptorFactories(), cflowChain, new ConstructorJoinpoint(constructor));
                Interceptor[] cflowInterceptors = cflowChain.toArray(new Interceptor[cflowChain.size()]);
                curr.add(new CFlowInterceptor(binding.getCFlowString(), binding.getCFlow(), cflowInterceptors));
                continue;
            }
            this.createInterceptorChain(binding.getInterceptorFactories(), curr, new ConstructorJoinpoint(constructor));
        }
    }

    public Interceptor[] applyPrecedence(Interceptor[] interceptors) {
        return PrecedenceSorter.applyPrecedence(interceptors, this.manager);
    }

    private class AdviceInterceptorKey {
        private String adviceName;
        private Joinpoint joinpoint;
        private int hash;

        public AdviceInterceptorKey(String adviceName, Joinpoint joinpoint) {
            this.adviceName = adviceName;
            this.joinpoint = joinpoint;
            this.hash = adviceName.hashCode();
            this.hash = 29 * this.hash + (joinpoint != null ? joinpoint.hashCode() : 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AdviceInterceptorKey)) {
                return false;
            }
            AdviceInterceptorKey adviceInterceptorKey = (AdviceInterceptorKey)o;
            if (!this.adviceName.equals(adviceInterceptorKey.adviceName)) {
                return false;
            }
            return !(this.joinpoint != null ? !this.joinpoint.equals(adviceInterceptorKey.joinpoint) : adviceInterceptorKey.joinpoint != null);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

