/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.metadata;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.jboss.webservice.WSDLDefinitionFactory;
import org.jboss.webservice.metadata.HandlerMetaData;
import org.jboss.webservice.metadata.PortComponentRefMetaData;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMappingFactory;
import org.jboss.xml.QNameBuilder;
import org.w3c.dom.Element;

public class ServiceRefMetaData
implements Serializable {
    static final long serialVersionUID = -4066138133416677843L;
    private String serviceRefName;
    private String serviceInterface;
    private String wsdlFile;
    private String jaxrpcMappingFile;
    private QName serviceQName;
    private LinkedHashMap portComponentRefs = new LinkedHashMap();
    private ArrayList handlers = new ArrayList();
    private URL wsdlOverride;
    private Properties callProperties;
    private transient URLClassLoader resourceCL;
    private transient Definition wsdlDefinition;
    private transient JavaWsdlMapping javaWsdlMapping;

    public ServiceRefMetaData() {
    }

    public ServiceRefMetaData(URLClassLoader resourceCl) {
        this.setResourceCl(resourceCl);
    }

    public void setResourceCl(URLClassLoader resourceCl) {
        if (resourceCl == null) {
            throw new IllegalArgumentException("ResourceClassLoader cannot be null");
        }
        this.resourceCL = resourceCl;
    }

    public URLClassLoader getResourceCL() {
        return this.resourceCL;
    }

    public String getJaxrpcMappingFile() {
        return this.jaxrpcMappingFile;
    }

    public URL getJavaWsdlMappingLocation() {
        URL location = this.resourceCL.findResource(this.jaxrpcMappingFile);
        return location;
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        if (this.javaWsdlMapping == null && this.jaxrpcMappingFile != null) {
            try {
                URL location = this.getJavaWsdlMappingLocation();
                JavaWsdlMappingFactory mappingFactory = JavaWsdlMappingFactory.newInstance();
                this.javaWsdlMapping = mappingFactory.parse(location);
            }
            catch (Exception e) {
                throw new JAXRPCException("Cannot unmarshal jaxrpc-mapping-file: " + this.jaxrpcMappingFile, (Throwable)e);
            }
        }
        return this.javaWsdlMapping;
    }

    public PortComponentRefMetaData[] getPortComponentRefs() {
        PortComponentRefMetaData[] array = new PortComponentRefMetaData[this.portComponentRefs.size()];
        this.portComponentRefs.values().toArray(array);
        return array;
    }

    public HandlerMetaData[] getHandlers() {
        HandlerMetaData[] array = new HandlerMetaData[this.handlers.size()];
        this.handlers.toArray(array);
        return array;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public Class getServiceInterfaceClass() throws ClassNotFoundException {
        if (this.resourceCL == null) {
            throw new IllegalStateException("Resource class loader not set");
        }
        return this.resourceCL.loadClass(this.serviceInterface);
    }

    public QName getServiceQName() {
        return this.serviceQName;
    }

    public String getServiceRefName() {
        return this.serviceRefName;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public URL getWsdlOverride() {
        return this.wsdlOverride;
    }

    public Properties getCallProperties() {
        return this.callProperties;
    }

    public Definition getWsdlDefinition() {
        if (this.wsdlDefinition == null && (this.wsdlOverride != null || this.wsdlFile != null)) {
            try {
                URL wsdlURL = this.wsdlOverride != null ? this.wsdlOverride : this.resourceCL.findResource(this.wsdlFile);
                WSDLDefinitionFactory factory = WSDLDefinitionFactory.newInstance();
                this.wsdlDefinition = factory.parse(wsdlURL);
            }
            catch (WSDLException e) {
                throw new IllegalStateException("Cannot unmarshall wsdl, cause: " + e.toString());
            }
        }
        return this.wsdlDefinition;
    }

    public void importStandardXml(Element element) throws DeploymentException {
        this.serviceRefName = MetaData.getUniqueChildContent((Element)element, (String)"service-ref-name");
        this.serviceInterface = MetaData.getUniqueChildContent((Element)element, (String)"service-interface");
        this.wsdlFile = MetaData.getOptionalChildContent((Element)element, (String)"wsdl-file");
        this.jaxrpcMappingFile = MetaData.getOptionalChildContent((Element)element, (String)"jaxrpc-mapping-file");
        Element qnameElement = MetaData.getOptionalChild((Element)element, (String)"service-qname");
        if (qnameElement != null) {
            this.serviceQName = QNameBuilder.buildQName((Element)qnameElement, (String)MetaData.getElementContent((Element)qnameElement));
        }
        Iterator iterator = MetaData.getChildrenByTagName((Element)element, (String)"port-component-ref");
        while (iterator.hasNext()) {
            Element pcrefElement = (Element)iterator.next();
            PortComponentRefMetaData pcrefMetaData = new PortComponentRefMetaData(this);
            pcrefMetaData.importStandardXml(pcrefElement);
            this.portComponentRefs.put(pcrefMetaData.getServiceEndpointInterface(), pcrefMetaData);
        }
        iterator = MetaData.getChildrenByTagName((Element)element, (String)"handler");
        while (iterator.hasNext()) {
            Element handlerElement = (Element)iterator.next();
            HandlerMetaData handlerMetaData = new HandlerMetaData();
            handlerMetaData.importStandardXml(handlerElement);
            this.handlers.add(handlerMetaData);
        }
    }

    public void importJBossXml(Element element) throws DeploymentException {
        String name;
        String wsdlOverrideOption = MetaData.getOptionalChildContent((Element)element, (String)"wsdl-override");
        try {
            if (wsdlOverrideOption != null) {
                this.wsdlOverride = new URL(wsdlOverrideOption);
            }
        }
        catch (MalformedURLException e) {
            throw new DeploymentException("Invalid WSDL override: " + wsdlOverrideOption);
        }
        Iterator iterator = MetaData.getChildrenByTagName((Element)element, (String)"port-component-ref");
        while (iterator.hasNext()) {
            Element pcrefElement = (Element)iterator.next();
            name = MetaData.getOptionalChildContent((Element)pcrefElement, (String)"service-endpoint-interface");
            if (name == null) continue;
            PortComponentRefMetaData pcrefMetaData = (PortComponentRefMetaData)this.portComponentRefs.get(name);
            if (pcrefMetaData == null) {
                pcrefMetaData = new PortComponentRefMetaData(this);
                pcrefMetaData.importStandardXml(pcrefElement);
                this.portComponentRefs.put(pcrefMetaData.getServiceEndpointInterface(), pcrefMetaData);
            }
            pcrefMetaData.importJBossXml(pcrefElement);
        }
        iterator = MetaData.getChildrenByTagName((Element)element, (String)"call-property");
        while (iterator.hasNext()) {
            Element propElement = (Element)iterator.next();
            name = MetaData.getUniqueChildContent((Element)propElement, (String)"prop-name");
            String value = MetaData.getUniqueChildContent((Element)propElement, (String)"prop-value");
            if (this.callProperties == null) {
                this.callProperties = new Properties();
            }
            this.callProperties.setProperty(name, value);
        }
    }
}

