/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.csiv2;

import org.jboss.iiop.CorbaORBService;
import org.jboss.iiop.csiv2.CSIv2Policy;
import org.jboss.iiop.csiv2.CSIv2Util;
import org.jboss.logging.Logger;
import org.jboss.metadata.IorSecurityConfigMetaData;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class CSIv2IORInterceptor
extends LocalObject
implements IORInterceptor {
    static final long serialVersionUID = 7726088578382542812L;
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$iiop$csiv2$CSIv2IORInterceptor == null ? (class$org$jboss$iiop$csiv2$CSIv2IORInterceptor = CSIv2IORInterceptor.class$("org.jboss.iiop.csiv2.CSIv2IORInterceptor")) : class$org$jboss$iiop$csiv2$CSIv2IORInterceptor));
    private static final int MIN_SSL_OPTIONS = 26;
    private TaggedComponent defaultSSLComponent;
    private TaggedComponent defaultCSIComponent;
    static /* synthetic */ Class class$org$jboss$iiop$csiv2$CSIv2IORInterceptor;

    public CSIv2IORInterceptor(Codec codec) {
        int sslPort = CorbaORBService.getTheActualSSLPort();
        try {
            SSL ssl = new SSL(26, 0, (short)sslPort);
            ORB orb = ORB.init();
            Any any = orb.create_any();
            SSLHelper.insert((Any)any, (SSL)ssl);
            byte[] componentData = codec.encode_value(any);
            this.defaultSSLComponent = new TaggedComponent(20, componentData);
            IorSecurityConfigMetaData metadata = new IorSecurityConfigMetaData();
            this.defaultCSIComponent = CSIv2Util.createSecurityTaggedComponent(metadata, codec, sslPort, orb);
        }
        catch (InvalidTypeForEncoding e) {
            log.warn((Object)"Caught unexcepted exception while encoding SSL component", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String name() {
        return (class$org$jboss$iiop$csiv2$CSIv2IORInterceptor == null ? (class$org$jboss$iiop$csiv2$CSIv2IORInterceptor = CSIv2IORInterceptor.class$("org.jboss.iiop.csiv2.CSIv2IORInterceptor")) : class$org$jboss$iiop$csiv2$CSIv2IORInterceptor).getName();
    }

    public void destroy() {
    }

    public void establish_components(IORInfo info) {
        CSIv2Policy csiv2Policy;
        block10: {
            csiv2Policy = null;
            try {
                csiv2Policy = (CSIv2Policy)info.get_effective_policy(-2023406815);
            }
            catch (BAD_PARAM e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No CSIv2Policy");
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block10;
                log.debug((Object)"Error fetching CSIv2Policy", (Throwable)e);
            }
        }
        if (csiv2Policy != null) {
            TaggedComponent csiv2Component;
            TaggedComponent sslComponent = csiv2Policy.getSSLTaggedComponent();
            if (sslComponent != null && CorbaORBService.getSSLComponentsEnabledFlag()) {
                info.add_ior_component_to_profile(sslComponent, 0);
            }
            if ((csiv2Component = csiv2Policy.getSecurityTaggedComponent()) != null) {
                info.add_ior_component_to_profile(csiv2Component, 0);
            }
        } else {
            if (this.defaultSSLComponent != null && CorbaORBService.getSSLComponentsEnabledFlag()) {
                info.add_ior_component_to_profile(this.defaultSSLComponent, 0);
            }
            if (this.defaultCSIComponent != null) {
                info.add_ior_component_to_profile(this.defaultCSIComponent, 0);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

