/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.crypto.Cipher;
import junit.framework.TestCase;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.ENCRYPT;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolObserver;

public class ENCRYPTAsymmetricTest
extends TestCase {
    public void testInitNoProperties() {
        ENCRYPT encrypt = new ENCRYPT();
        try {
            encrypt.init();
        }
        catch (Exception e) {
            ENCRYPTAsymmetricTest.fail((String)e.getMessage());
        }
        ENCRYPTAsymmetricTest.assertEquals((String)"RSA", (String)encrypt.getAsymAlgorithm());
        ENCRYPTAsymmetricTest.assertEquals((int)512, (int)encrypt.getAsymInit());
        ENCRYPTAsymmetricTest.assertEquals((String)"RSA", (String)encrypt.getKpair().getPublic().getAlgorithm());
        ENCRYPTAsymmetricTest.assertEquals((String)"X509", (String)encrypt.getKpair().getPublic().getFormat());
        ENCRYPTAsymmetricTest.assertNotNull((Object)encrypt.getKpair().getPublic().getEncoded());
        ENCRYPTAsymmetricTest.assertEquals((String)"Blowfish", (String)encrypt.getSymAlgorithm());
        ENCRYPTAsymmetricTest.assertEquals((int)56, (int)encrypt.getSymInit());
        ENCRYPTAsymmetricTest.assertEquals((String)"Blowfish", (String)encrypt.getDesKey().getAlgorithm());
        ENCRYPTAsymmetricTest.assertEquals((String)"RAW", (String)encrypt.getDesKey().getFormat());
        ENCRYPTAsymmetricTest.assertNotNull((Object)encrypt.getDesKey().getEncoded());
        System.out.println("Provider:" + encrypt.getAsymCipher().getProvider());
        ENCRYPTAsymmetricTest.assertNotNull((Object)encrypt.getAsymCipher());
        ENCRYPTAsymmetricTest.assertNotNull((Object)encrypt.getSymDecodingCipher());
        ENCRYPTAsymmetricTest.assertNotNull((Object)encrypt.getSymEncodingCipher());
    }

    public void testInitBCAsymProperties() {
        Properties props = new Properties();
        props.put("asym_provider", "BC");
        props.put("asym_algorithm", "RSA");
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        try {
            encrypt.init();
        }
        catch (Exception e) {
            ENCRYPTAsymmetricTest.fail((String)e.getMessage());
        }
        ENCRYPTAsymmetricTest.assertEquals((String)"RSA", (String)encrypt.getAsymAlgorithm());
        ENCRYPTAsymmetricTest.assertEquals((int)512, (int)encrypt.getAsymInit());
        ENCRYPTAsymmetricTest.assertEquals((String)"RSA", (String)encrypt.getKpair().getPublic().getAlgorithm());
        ENCRYPTAsymmetricTest.assertEquals((String)"X.509", (String)encrypt.getKpair().getPublic().getFormat());
        ENCRYPTAsymmetricTest.assertNotNull((Object)encrypt.getKpair().getPublic().getEncoded());
        ENCRYPTAsymmetricTest.assertNotNull((Object)encrypt.getAsymCipher());
    }

    public void testInitRSABlockAsymProperties() {
        Properties props = new Properties();
        props.put("asym_algorithm", "RSA/ECB/OAEPPadding");
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        try {
            encrypt.init();
        }
        catch (Exception e) {
            ENCRYPTAsymmetricTest.fail((String)e.getMessage());
        }
        ENCRYPTAsymmetricTest.assertEquals((String)"RSA/ECB/OAEPPadding", (String)encrypt.getAsymAlgorithm());
        ENCRYPTAsymmetricTest.assertEquals((int)512, (int)encrypt.getAsymInit());
        ENCRYPTAsymmetricTest.assertEquals((String)"RSA", (String)encrypt.getKpair().getPublic().getAlgorithm());
        ENCRYPTAsymmetricTest.assertEquals((String)"X509", (String)encrypt.getKpair().getPublic().getFormat());
        ENCRYPTAsymmetricTest.assertNotNull((Object)encrypt.getKpair().getPublic().getEncoded());
        ENCRYPTAsymmetricTest.assertNotNull((Object)encrypt.getAsymCipher());
    }

    public void testInitIDEAProperties() {
        Properties props = new Properties();
        props.put("sym_algorithm", "IDEA");
        props.put("sym_init", "128");
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        try {
            encrypt.init();
        }
        catch (Exception e) {
            ENCRYPTAsymmetricTest.fail((String)e.getMessage());
        }
        ENCRYPTAsymmetricTest.assertEquals((String)"IDEA", (String)encrypt.getSymAlgorithm());
        ENCRYPTAsymmetricTest.assertEquals((int)128, (int)encrypt.getSymInit());
        ENCRYPTAsymmetricTest.assertEquals((String)"IDEA", (String)encrypt.getDesKey().getAlgorithm());
        ENCRYPTAsymmetricTest.assertEquals((String)"RAW", (String)encrypt.getDesKey().getFormat());
        ENCRYPTAsymmetricTest.assertNotNull((Object)encrypt.getDesKey().getEncoded());
        ENCRYPTAsymmetricTest.assertNotNull((Object)encrypt.getSymDecodingCipher());
        ENCRYPTAsymmetricTest.assertNotNull((Object)encrypt.getSymEncodingCipher());
    }

    public void testInitAESProperties() {
        Properties props = new Properties();
        props.put("sym_algorithm", "AES");
        props.put("sym_init", "192");
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        try {
            encrypt.init();
        }
        catch (Exception e) {
            ENCRYPTAsymmetricTest.fail((String)e.getMessage());
        }
        ENCRYPTAsymmetricTest.assertEquals((String)"AES", (String)encrypt.getSymAlgorithm());
        ENCRYPTAsymmetricTest.assertEquals((int)192, (int)encrypt.getSymInit());
        ENCRYPTAsymmetricTest.assertEquals((String)"AES", (String)encrypt.getDesKey().getAlgorithm());
        ENCRYPTAsymmetricTest.assertEquals((String)"RAW", (String)encrypt.getDesKey().getFormat());
        ENCRYPTAsymmetricTest.assertNotNull((Object)encrypt.getDesKey().getEncoded());
        ENCRYPTAsymmetricTest.assertNotNull((Object)encrypt.getSymDecodingCipher());
        ENCRYPTAsymmetricTest.assertNotNull((Object)encrypt.getSymEncodingCipher());
    }

    public void testViewChangeBecomeKeyserver() throws Exception {
        ENCRYPT encrypt = new ENCRYPT();
        try {
            encrypt.init();
        }
        catch (Exception e) {
            ENCRYPTAsymmetricTest.fail((String)e.getMessage());
        }
        MockAddress tempAddress = new MockAddress("encrypt");
        encrypt.setLocal_addr(tempAddress);
        MockObserver observer = new MockObserver();
        encrypt.setObserver(observer);
        Cipher cipher = encrypt.getSymEncodingCipher();
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.reset();
        digest.update(encrypt.getDesKey().getEncoded());
        String symVersion = new String(digest.digest());
        encrypt.keyServer = false;
        Message msg = new Message();
        msg.setBuffer(cipher.doFinal("hello".getBytes()));
        msg.putHeader("encrypt", new ENCRYPT.EncryptHeader(0, symVersion));
        Event evt = new Event(1, msg);
        encrypt.up(evt);
        ENCRYPTAsymmetricTest.assertTrue((boolean)observer.getUpMessages().isEmpty());
        Vector<MockAddress> tempVector = new Vector<MockAddress>();
        tempVector.add(tempAddress);
        View tempView = new View(new ViewId(tempAddress, 1L), tempVector);
        Event event = new Event(6, tempView);
        encrypt.up(event);
        Message msg2 = new Message();
        msg2.setBuffer(cipher.doFinal("hello2".getBytes()));
        msg2.putHeader("encrypt", new ENCRYPT.EncryptHeader(0, symVersion));
        Event evt2 = new Event(1, msg2);
        encrypt.up(evt2);
        ENCRYPTAsymmetricTest.assertEquals((int)3, (int)observer.getUpMessages().size());
        Event sent = (Event)observer.getUpMessages().get("message1");
        ENCRYPTAsymmetricTest.assertEquals((String)new String(((Message)sent.getArg()).getBuffer()), (String)"hello");
        sent = (Event)observer.getUpMessages().get("message2");
        ENCRYPTAsymmetricTest.assertEquals((String)new String(((Message)sent.getArg()).getBuffer()), (String)"hello2");
    }

    public void testViewChangeNewKeyServer() throws Exception {
        ENCRYPT peer = new ENCRYPT();
        try {
            peer.init();
        }
        catch (Exception e) {
            ENCRYPTAsymmetricTest.fail((String)e.getMessage());
        }
        ENCRYPT server = new ENCRYPT();
        try {
            server.init();
        }
        catch (Exception e) {
            ENCRYPTAsymmetricTest.fail((String)e.getMessage());
        }
        server.keyServer = true;
        MockObserver serverObserver = new MockObserver();
        server.setObserver(serverObserver);
        MockAddress serverAddress = new MockAddress("server");
        server.setLocal_addr(serverAddress);
        Vector<MockAddress> serverVector = new Vector<MockAddress>();
        serverVector.add(serverAddress);
        View tempView = new View(new ViewId(serverAddress, 1L), serverVector);
        Event serverEvent = new Event(6, tempView);
        server.up(serverEvent);
        MockAddress peerAddress = new MockAddress("peer");
        peer.setLocal_addr(peerAddress);
        MockObserver peerObserver = new MockObserver();
        peer.setObserver(peerObserver);
        peer.keyServer = false;
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.reset();
        digest.update(server.getDesKey().getEncoded());
        String symVersion = new String(digest.digest());
        Cipher cipher = server.getSymEncodingCipher();
        Message msg = new Message();
        msg.setBuffer(cipher.doFinal("hello".getBytes()));
        msg.putHeader("encrypt", new ENCRYPT.EncryptHeader(0, symVersion));
        Event evt = new Event(1, msg);
        peer.up(evt);
        ENCRYPTAsymmetricTest.assertTrue((boolean)peerObserver.getUpMessages().isEmpty());
        peer.up(serverEvent);
        ENCRYPTAsymmetricTest.assertTrue((serverAddress == peer.getKeyServerAddr() ? 1 : 0) != 0);
        Event sent = (Event)peerObserver.getDownMessages().get("message0");
        ENCRYPTAsymmetricTest.assertTrue((((ENCRYPT.EncryptHeader)((Message)sent.getArg()).getHeader("encrypt")).getType() == 1 ? 1 : 0) != 0);
        ENCRYPTAsymmetricTest.assertEquals((String)new String(((Message)sent.getArg()).getBuffer()), (String)new String(peer.getKpair().getPublic().getEncoded()));
        server.up(sent);
        Event reply = (Event)serverObserver.getDownMessages().get("message1");
        ENCRYPTAsymmetricTest.assertTrue((((ENCRYPT.EncryptHeader)((Message)reply.getArg()).getHeader("encrypt")).getType() == 3 ? 1 : 0) != 0);
        ENCRYPTAsymmetricTest.assertNotSame((Object)peer.getDesKey(), (Object)server.getDesKey());
        peer.up(reply);
        ENCRYPTAsymmetricTest.assertEquals((Object)peer.getDesKey(), (Object)server.getDesKey());
        Message msg2 = new Message();
        msg2.setBuffer(cipher.doFinal("hello2".getBytes()));
        msg2.putHeader("encrypt", new ENCRYPT.EncryptHeader(0, symVersion));
        Event evt2 = new Event(1, msg2);
        peer.up(evt2);
        ENCRYPTAsymmetricTest.assertEquals((int)3, (int)peerObserver.getUpMessages().size());
        Event tempEvt = (Event)peerObserver.getUpMessages().get("message2");
        ENCRYPTAsymmetricTest.assertEquals((String)new String(((Message)tempEvt.getArg()).getBuffer()), (String)"hello");
        tempEvt = (Event)peerObserver.getUpMessages().get("message3");
        ENCRYPTAsymmetricTest.assertEquals((String)new String(((Message)tempEvt.getArg()).getBuffer()), (String)"hello2");
    }

    public void testViewChangeNewKeyServerNewKey() throws Exception {
        ENCRYPT peer = new ENCRYPT();
        try {
            peer.init();
        }
        catch (Exception e) {
            ENCRYPTAsymmetricTest.fail((String)e.getMessage());
        }
        ENCRYPT server = new ENCRYPT();
        try {
            server.init();
        }
        catch (Exception e) {
            ENCRYPTAsymmetricTest.fail((String)e.getMessage());
        }
        ENCRYPT peer2 = new ENCRYPT();
        try {
            peer2.init();
        }
        catch (Exception e) {
            ENCRYPTAsymmetricTest.fail((String)e.getMessage());
        }
        server.keyServer = true;
        MockObserver serverObserver = new MockObserver();
        server.setObserver(serverObserver);
        MockAddress serverAddress = new MockAddress("server");
        server.setLocal_addr(serverAddress);
        Vector<MockAddress> serverVector = new Vector<MockAddress>();
        serverVector.add(serverAddress);
        View tempView = new View(new ViewId(serverAddress, 1L), serverVector);
        Event serverEvent = new Event(6, tempView);
        server.up(serverEvent);
        MockAddress peerAddress = new MockAddress("peer");
        peer.setLocal_addr(peerAddress);
        MockObserver peerObserver = new MockObserver();
        peer.setObserver(peerObserver);
        peer.keyServer = false;
        MockAddress peer2Address = new MockAddress("peer2");
        peer2.setLocal_addr(peer2Address);
        MockObserver peer2Observer = new MockObserver();
        peer2.setObserver(peer2Observer);
        peer2.keyServer = false;
        peer2.setKeyServerAddr(serverAddress);
        Message msg = new Message();
        msg.setBuffer("hello".getBytes());
        Event evt = new Event(1, msg);
        server.down(evt);
        Event encEvt = (Event)serverObserver.getDownMessages().get("message1");
        peer.up(encEvt);
        ENCRYPTAsymmetricTest.assertTrue((boolean)peerObserver.getUpMessages().isEmpty());
        Vector<MockAddress> peerVector = new Vector<MockAddress>();
        peerVector.add(peer2Address);
        View tempPeerView = new View(new ViewId(peer2Address, 1L), peerVector);
        Event event = new Event(6, tempPeerView);
        peer.up(event);
        ENCRYPTAsymmetricTest.assertTrue((peer2Address == peer.getKeyServerAddr() ? 1 : 0) != 0);
        Event sent = (Event)peerObserver.getDownMessages().get("message0");
        ENCRYPTAsymmetricTest.assertTrue((((ENCRYPT.EncryptHeader)((Message)sent.getArg()).getHeader("encrypt")).getType() == 1 ? 1 : 0) != 0);
        ENCRYPTAsymmetricTest.assertEquals((String)new String(((Message)sent.getArg()).getBuffer()), (String)new String(peer.getKpair().getPublic().getEncoded()));
        Vector<MockAddress> peer2Vector = new Vector<MockAddress>();
        peer2Vector.add(peer2Address);
        View tempPeer2View = new View(new ViewId(peer2Address, 1L), peer2Vector);
        Event event2 = new Event(6, tempPeer2View);
        peer2.up(event2);
        peer2.up(sent);
        Event reply = (Event)peer2Observer.getDownMessages().get("message1");
        ENCRYPTAsymmetricTest.assertTrue((((ENCRYPT.EncryptHeader)((Message)reply.getArg()).getHeader("encrypt")).getType() == 3 ? 1 : 0) != 0);
        ENCRYPTAsymmetricTest.assertNotSame((Object)peer.getDesKey(), (Object)peer2.getDesKey());
        ENCRYPTAsymmetricTest.assertNotSame((Object)server.getDesKey(), (Object)peer2.getDesKey());
        peer.up(reply);
        ENCRYPTAsymmetricTest.assertEquals((Object)peer.getDesKey(), (Object)peer2.getDesKey());
        ENCRYPTAsymmetricTest.assertNotSame((Object)server.getDesKey(), (Object)peer.getDesKey());
        Message msg2 = new Message();
        msg2.setBuffer("hello2".getBytes());
        Event evt2 = new Event(1, msg2);
        peer2.down(evt2);
        Event Evt2 = (Event)peer2Observer.getDownMessages().get("message2");
        peer.up(Evt2);
        ENCRYPTAsymmetricTest.assertEquals((int)2, (int)peerObserver.getUpMessages().size());
        Event tempEvt = (Event)peerObserver.getUpMessages().get("message2");
        ENCRYPTAsymmetricTest.assertEquals((String)new String(((Message)tempEvt.getArg()).getBuffer()), (String)"hello2");
    }

    class MockAddress
    implements Address {
        String name;

        public MockAddress(String name) {
            this.name = name;
        }

        public boolean isMulticastAddress() {
            return false;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public int compareTo(Object o) {
            return -1;
        }

        public boolean equals(Object obj) {
            MockAddress address = (MockAddress)obj;
            return address.name.equals(this.name);
        }
    }

    class MockObserver
    implements ProtocolObserver {
        private Map upMessages = new HashMap();
        private Map downMessages = new HashMap();
        private int counter = 0;

        MockObserver() {
        }

        private void storeUp(Event evt) {
            this.upMessages.put("message" + this.counter++, evt);
        }

        private void storeDown(Event evt) {
            this.downMessages.put("message" + this.counter++, evt);
        }

        public void up(Event evt) {
            this.storeUp(evt);
            System.out.println("Up:" + evt.toString());
        }

        public void setProtocol(Protocol prot) {
        }

        public boolean up(Event evt, int num_evts) {
            System.out.println("Up:" + evt.toString());
            return false;
        }

        public boolean passUp(Event evt) {
            this.storeUp(evt);
            System.out.println("PassUp:" + evt.toString());
            return false;
        }

        public boolean down(Event evt, int num_evts) {
            System.out.println("down:" + evt.toString());
            return false;
        }

        public boolean passDown(Event evt) {
            this.storeDown(evt);
            System.out.println("passdown:" + evt.toString());
            return false;
        }

        protected Map getUpMessages() {
            return this.upMessages;
        }

        protected void setUpMessages(Map upMessages) {
            this.upMessages = upMessages;
        }

        protected Map getDownMessages() {
            return this.downMessages;
        }

        protected void setDownMessages(Map downMessages) {
            this.downMessages = downMessages;
        }
    }
}

