/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.conf.ClassMap;
import org.jgroups.conf.MagicNumberReader;
import org.jgroups.util.Util;

public class ClassConfigurator {
    static ClassConfigurator instance = null;
    private Map classMap;
    private Map magicMap;
    protected Log log;
    static /* synthetic */ Class class$org$jgroups$conf$ClassConfigurator;

    private ClassConfigurator(boolean init) {
        block14: {
            this.classMap = new HashMap();
            this.magicMap = new TreeMap();
            this.log = LogFactory.getLog(this.getClass());
            if (!init) {
                return;
            }
            try {
                this.getClass().getClassLoader().loadClass("javax.xml.parsers.DocumentBuilderFactory");
                MagicNumberReader reader = new MagicNumberReader();
                try {
                    String mnfile = System.getProperty("org.jgroups.conf.magicNumberFile");
                    if (mnfile != null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Using " + mnfile + " as magic number file"));
                        }
                        reader.setFilename(mnfile);
                    }
                }
                catch (SecurityException ex) {
                    // empty catch block
                }
                ClassMap[] mapping = reader.readMagicNumberMapping();
                if (mapping != null) {
                    for (int i = 0; i < mapping.length; ++i) {
                        try {
                            Integer m = new Integer(mapping[i].getMagicNumber());
                            Class clazz = mapping[i].getClassForMap();
                            if (clazz == null) {
                                if (!this.log.isErrorEnabled()) continue;
                                this.log.error((Object)("failed to create class " + mapping[i].getClassName()));
                                continue;
                            }
                            if (this.magicMap.containsKey(m)) {
                                if (!this.log.isErrorEnabled()) continue;
                                this.log.error((Object)("magic key " + m + " (" + clazz.getName() + ')' + " is already in map (won't be overwritten). Please make sure that " + "all magic keys are unique"));
                                continue;
                            }
                            this.magicMap.put(m, clazz);
                            this.classMap.put(clazz, m);
                            continue;
                        }
                        catch (Exception cx) {
                            if (!this.log.isErrorEnabled()) continue;
                            this.log.error((Object)("Failed to load class:" + mapping[i].getClassName()));
                        }
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("mapping is:\n" + this.printMagicMap()));
                    }
                }
            }
            catch (Throwable x) {
                if (!this.log.isErrorEnabled()) break block14;
                this.log.error((Object)("JAXP Error: the required XML parsing classes are not available; make sure that JAXP compatible libraries are in the classpath.\nstack trace:\n" + Util.print(x)));
            }
        }
    }

    public static ClassConfigurator getInstance() {
        return instance != null ? instance : (instance = new ClassConfigurator(true));
    }

    public Class get(int magic) {
        return (Class)this.magicMap.get(new Integer(magic));
    }

    public Class get(String clazzname) {
        try {
            return (class$org$jgroups$conf$ClassConfigurator == null ? (class$org$jgroups$conf$ClassConfigurator = ClassConfigurator.class$("org.jgroups.conf.ClassConfigurator")) : class$org$jgroups$conf$ClassConfigurator).getClassLoader().loadClass(clazzname);
        }
        catch (Exception x) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)Util.getStackTrace(x));
            }
            return null;
        }
    }

    public int getMagicNumber(Class clazz) {
        Integer i = (Integer)this.classMap.get(clazz);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public String toString() {
        return this.printMagicMap();
    }

    public String printMagicMap() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.magicMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append(entry.getKey()).append(":\t").append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    public String printClassMap() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.classMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        ClassConfigurator test = ClassConfigurator.getInstance();
        System.out.println('\n' + test.printMagicMap());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

