/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.Enumeration;
import org.hsqldb.Column;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Record;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashSet;
import org.hsqldb.persist.HsqlProperties;

public class HsqlDatabaseProperties
extends HsqlProperties {
    public static final int FILES_NOT_MODIFIED = 0;
    public static final int FILES_MODIFIED = 1;
    public static final int FILES_NEW = 2;
    private static HashSet fullyProtectedProperties = new HashSet();
    private static HashSet setProtectedProperties = new HashSet();
    private static HashSet booleanProperties = new HashSet();
    private static HashSet integralProperties = new HashSet();
    private static HashSet stringProperties = new HashSet();
    public static final String VERSION_STRING_1_7_0 = "1.7.0";
    public static final String VERSION_STRING_1_8_0 = "1.8.0";
    public static final String FIRST_COMPATIBLE_VERSION = "1.7.2";
    public static final String THIS_VERSION = "1.8.0";
    public static final String PRODUCT_NAME = "HSQL Database Engine";
    public static final int MAJOR = 1;
    public static final int MINOR = 8;
    public static final int REVISION = 0;
    public static final String DEFRAG_LIMIT = "hsqldb.defrag_limit";
    public static final String CACHE_VERSION = "hsqldb.cache_version";
    public static final String CACHE_FILE_SCALE = "hsqldb.cache_file_scale";
    public static final String DEFAULT_TABLE_TYPE = "hsqldb.default_table_type";
    private Database database;

    public HsqlDatabaseProperties(Database database) {
        super(database.getPath(), database.isStoredFileAccess() ? database.getFileAccess() : null, database.isFilesInJar());
        this.database = database;
        this.setProperty("sql.enforce_size", false);
        this.setProperty("sql.enforce_strict_size", false);
        this.setProperty("sql.compare_in_locale", false);
        this.setProperty("version", "1.8.0");
        this.setProperty("hsqldb.compatible_version", FIRST_COMPATIBLE_VERSION);
        this.setProperty(CACHE_VERSION, VERSION_STRING_1_7_0);
        this.setProperty("hsqldb.original_version", "1.8.0");
        this.setProperty("runtime.gc_interval", 0);
        this.setProperty(CACHE_FILE_SCALE, 1);
        this.setProperty("hsqldb.cache_size_scale", 8);
        this.setProperty("hsqldb.cache_scale", 14);
        this.setProperty("hsqldb.log_size", "200");
        this.setProperty("hsqldb.script_format", 0);
        this.setProperty("hsqldb.first_identity", 0);
        this.setProperty("readonly", false);
        this.setProperty("modified", "no-new-files");
        this.setProperty("hsqldb.nio_data_file", true);
        this.setProperty(DEFAULT_TABLE_TYPE, "memory");
        if (database.isStoredFileAccess()) {
            this.setProperty(DEFAULT_TABLE_TYPE, "cached");
            this.setProperty("hsqldb.cache_scale", 13);
            this.setProperty("hsqldb.log_size", 10);
            this.setProperty("sql.enforce_strict_size", true);
            this.setProperty("hsqldb.first_identity", 1);
        }
        this.setSystemVariables();
        this.setDatabaseVariables();
    }

    private void setSystemVariables() {
        Column.setCompareInLocal(this.isPropertyTrue("sql.compare_in_locale"));
        Record.gcFrequency = this.getIntegerProperty("runtime.gc_interval", 0);
    }

    public boolean load() throws HsqlException {
        boolean bl;
        if (this.database.getType().equals("mem:")) {
            return true;
        }
        try {
            bl = super.load();
        }
        catch (Exception exception) {
            throw Trace.error(29, 116, new Object[]{this.fileName, exception});
        }
        if (!bl) {
            return false;
        }
        this.filterLoadedProperties();
        String string = this.getProperty("hsqldb.compatible_version");
        int n = string.substring(0, 5).compareTo("1.8.0");
        Trace.check(n <= 0, 30);
        string = this.getProperty("version");
        if (string.charAt(2) == '6') {
            this.setProperty(CACHE_VERSION, "1.6.0");
        }
        this.setSystemVariables();
        this.setDatabaseVariables();
        return true;
    }

    private void setDatabaseVariables() {
        if (this.isPropertyTrue("readonly")) {
            this.database.setReadOnly();
        }
        if (this.isPropertyTrue("hsqldb.files_readonly")) {
            this.database.setFilesReadOnly();
        }
        this.database.sqlEnforceSize = this.isPropertyTrue("sql.enforce_size");
        this.database.sqlEnforceStrictSize = this.isPropertyTrue("sql.enforce_strict_size");
        this.database.firstIdentity = this.getIntegerProperty("hsqldb.first_identity", 0);
        this.database.setMetaDirty(false);
    }

    public void save() throws HsqlException {
        if (this.database.getType().equals("mem:") || this.database.isFilesReadOnly() || this.database.isFilesInJar()) {
            return;
        }
        try {
            super.save();
        }
        catch (Exception exception) {
            throw Trace.error(29, 116, new Object[]{this.fileName, exception});
        }
    }

    void filterLoadedProperties() {
        Enumeration<?> enumeration = this.stringProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl = fullyProtectedProperties.contains(string) || setProtectedProperties.contains(string) || booleanProperties.contains(string) || integralProperties.contains(string) || stringProperties.contains(string);
            if (bl) continue;
            this.stringProps.remove(string);
        }
    }

    public void setURLProperties(HsqlProperties hsqlProperties) {
        if (hsqlProperties != null) {
            Enumeration enumeration = hsqlProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!this.isBoolean(string) && !this.isIntegral(string) && !this.isString(string)) continue;
                this.setProperty(string, hsqlProperties.getProperty(string));
            }
        }
    }

    public boolean isSetPropertyAllowed(String string) {
        return !fullyProtectedProperties.contains(string) && !setProtectedProperties.contains(string);
    }

    public boolean isBoolean(String string) {
        return booleanProperties.contains(string);
    }

    public boolean isIntegral(String string) {
        return integralProperties.contains(string);
    }

    boolean isString(String string) {
        return stringProperties.contains(string);
    }

    public String setProperty(String string, String string2) {
        string2 = super.setProperty(string, string2);
        this.setDatabaseVariables();
        return string2;
    }

    public int getDefaultWriteDelay() {
        return this.database.isStoredFileAccess() ? 2 : 20;
    }

    public void setDBModified(int n) throws HsqlException {
        String string = "no";
        if (n == 1) {
            string = "yes";
        } else if (n == 2) {
            string = "no-new-files";
        }
        this.setProperty("modified", string);
        this.save();
    }

    public int getDBModified() throws HsqlException {
        String string = this.getProperty("modified");
        if ("yes".equals(string)) {
            return 1;
        }
        if ("no-new-files".equals(string)) {
            return 2;
        }
        return 0;
    }

    static {
        Object[] objectArray = new String[]{"version", "hsqldb.compatible_version", CACHE_VERSION, "hsqldb.original_version", "hsqldb.files_readonly", "readonly", "modified", "sql.compare_in_locale", "textdb.allow_full_path"};
        fullyProtectedProperties.addAll(objectArray);
        Object[] objectArray2 = new String[]{"hsqldb.log_size", "hsqldb.script_format", DEFRAG_LIMIT};
        setProtectedProperties.addAll(objectArray2);
        Object[] objectArray3 = new String[]{"hsqldb.nio_data_file", "hsqldb.schemas", "hsqldb.catalogs", "sql.enforce_size", "sql.enforce_strict_size", "textdb.quoted", "textdb.all_quoted", "textdb.ignore_first"};
        booleanProperties.addAll(objectArray3);
        Object[] objectArray4 = new String[]{"runtime.gc_interval", "hsqldb.max_nio_scale", CACHE_FILE_SCALE, "hsqldb.cache_scale", "hsqldb.cache_size_scale", "hsqldb.first_identity", "hsqldb.log_size", "textdb.cache_scale", "textdb.cache_size_scale"};
        integralProperties.addAll(objectArray4);
        Object[] objectArray5 = new String[]{"textdb.fs", "textdb.vs", "textdb.lvs", "textdb.encoding", DEFAULT_TABLE_TYPE};
        stringProperties.addAll(objectArray5);
    }
}

