/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.server;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.axis.AxisEngine;
import org.jboss.axis.AxisFault;
import org.jboss.axis.MessageContext;
import org.jboss.axis.handlers.soap.SOAPService;
import org.jboss.axis.server.AxisServer;
import org.jboss.logging.Logger;
import org.jboss.webservice.server.AbstractServlet;

public class ServiceEndpointServlet
extends AbstractServlet {
    static final long serialVersionUID = 3806847653370058302L;
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String url = req.getRequestURL().toString();
        String queryString = req.getQueryString();
        this.log.debug((Object)("doGet: " + url + (queryString != null ? "?" + queryString : "")));
        PrintWriter writer = res.getWriter();
        try {
            String transportURL;
            boolean wsdlRequested;
            AxisServer engine = this.getEngine();
            String serviceName = this.getServiceName(req);
            SOAPService service = serviceName != null ? engine.getService(serviceName) : null;
            boolean bl = wsdlRequested = req.getParameter("wsdl") != null || req.getParameter("WSDL") != null;
            if (!wsdlRequested) {
                this.log.debug((Object)"Report available services");
                this.reportAvailableServices(res, writer, req);
                return;
            }
            if (service == null) {
                this.log.error((Object)("Cannot get axis service: " + serviceName));
                this.reportCantGetAxisService(req, res, writer);
                return;
            }
            MessageContext msgContext = this.createMessageContext((AxisEngine)engine, req, res);
            if (service != null) {
                msgContext.setTargetService(serviceName);
            }
            if ((transportURL = this.getTransportURL(req, serviceName)) != null) {
                msgContext.setProperty("transport.url", (Object)transportURL);
                this.log.debug((Object)("Set transport.url=" + transportURL));
            }
            if (wsdlRequested) {
                String wsdlResource = req.getParameter("resource");
                if (wsdlResource != null) {
                    this.log.debug((Object)("Process wsdl import request: " + wsdlResource));
                    msgContext.setProperty("axis.wsdlgen.resource", (Object)wsdlResource);
                } else {
                    this.log.debug((Object)"Process wsdl request");
                }
                this.processWsdlRequest(msgContext, res, writer);
                return;
            }
            this.log.debug((Object)"Report service info");
            this.reportServiceInfo(res, writer, service, serviceName);
        }
        catch (AxisFault fault) {
            this.reportTrouble((Exception)((Object)fault), res, writer);
        }
        catch (Exception e) {
            this.reportTrouble(e, res, writer);
        }
        finally {
            AxisEngine.setCurrentMessageContext(null);
            writer.close();
        }
    }

    protected String getServiceName(HttpServletRequest req) {
        String serviceName = this.getServletConfig().getInitParameter("WebServiceID");
        return serviceName;
    }
}

