/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.jasper;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.servlet.ServletContext;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;
import org.jboss.logging.Logger;

public class TagLibCache
extends TldLocationsCache {
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$web$tomcat$tc5$jasper$TagLibCache == null ? (class$org$jboss$web$tomcat$tc5$jasper$TagLibCache = TagLibCache.class$("org.jboss.web.tomcat.tc5.jasper.TagLibCache")) : class$org$jboss$web$tomcat$tc5$jasper$TagLibCache));
    private ServletContext ctx;
    private HashMap mappings;
    private ArrayList tagLibJars;
    static /* synthetic */ Class class$org$jboss$web$tomcat$tc5$jasper$TagLibCache;

    public TagLibCache(ServletContext ctx, ArrayList tagLibJars) {
        super(ctx, true);
        this.ctx = ctx;
        this.tagLibJars = tagLibJars;
    }

    public String[] getLocation(String uri) throws JasperException {
        if (this.mappings == null) {
            this.init();
        }
        String[] locations = (String[])this.mappings.get(uri);
        return locations;
    }

    private void init() throws JasperException {
        try {
            this.mappings = new HashMap();
            this.processWebDotXml();
            this.loadStandardTlds();
            this.processTldsInFileSystem("/WEB-INF/");
        }
        catch (Exception ex) {
            String msg = Localizer.getMessage((String)"jsp.error.internal.tldinit", (String)ex.getMessage());
            throw new JasperException(msg, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processWebDotXml() throws Exception {
        InputStream is = null;
        try {
            String altDDName = (String)this.ctx.getAttribute("org.apache.catalina.deploy.alt_dd");
            if (altDDName != null) {
                try {
                    is = new FileInputStream(altDDName);
                }
                catch (FileNotFoundException e) {
                    log.warn((Object)Localizer.getMessage((String)"jsp.error.internal.filenotfound", (String)altDDName));
                }
            } else {
                is = this.ctx.getResourceAsStream(WEB_XML);
                if (is == null) {
                    log.warn((Object)Localizer.getMessage((String)"jsp.error.internal.filenotfound", (String)WEB_XML));
                }
            }
            if (is == null) {
                return;
            }
            TreeNode webtld = null;
            webtld = altDDName != null ? new ParserUtils().parseXMLDocument(altDDName, is) : new ParserUtils().parseXMLDocument(WEB_XML, is);
            TreeNode jspConfig = webtld.findChild("jsp-config");
            if (jspConfig != null) {
                webtld = jspConfig;
            }
            Iterator taglibs = webtld.findChildren("taglib");
            while (taglibs.hasNext()) {
                TreeNode taglib = (TreeNode)taglibs.next();
                String tagUri = null;
                String tagLoc = null;
                TreeNode child = taglib.findChild("taglib-uri");
                if (child != null) {
                    tagUri = child.getBody();
                }
                if ((child = taglib.findChild("taglib-location")) != null) {
                    tagLoc = child.getBody();
                }
                if (tagLoc == null) continue;
                if (TagLibCache.uriType((String)tagLoc) == 2) {
                    tagLoc = "/WEB-INF/" + tagLoc;
                }
                String tagLoc2 = null;
                if (tagLoc.endsWith(JAR_FILE_SUFFIX)) {
                    tagLoc = this.ctx.getResource(tagLoc).toString();
                    tagLoc2 = "META-INF/taglib.tld";
                }
                this.mappings.put(tagUri, new String[]{tagLoc, tagLoc2});
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected void loadStandardTlds() throws MalformedURLException {
        if (this.tagLibJars.size() == 0) {
            return;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL web = loader.getResource("conf/web.xml");
        URL sarURL = new URL(web, "..");
        for (int n = 0; n < this.tagLibJars.size(); ++n) {
            String jarPath = (String)this.tagLibJars.get(n);
            try {
                URL url = new URL(sarURL, jarPath);
                String resourcePath = url.toString();
                log.debug((Object)("Scanning for tlds in: " + resourcePath));
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                this.scanJar(conn, resourcePath, true);
                continue;
            }
            catch (Exception e) {
                log.debug((Object)("Failed to scan: " + jarPath), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTldsInFileSystem(String startPath) throws Exception {
        Set dirList = this.ctx.getResourcePaths(startPath);
        if (dirList != null) {
            Iterator it = dirList.iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                if (path.endsWith("/")) {
                    this.processTldsInFileSystem(path);
                }
                if (path.endsWith(JAR_FILE_SUFFIX)) {
                    URL resURL = this.ctx.getResource(path);
                    URLConnection conn = resURL.openConnection();
                    conn.setUseCaches(false);
                    this.scanJar(conn, resURL.toString(), false);
                    continue;
                }
                if (!path.endsWith(".tld")) continue;
                InputStream stream = this.ctx.getResourceAsStream(path);
                String uri = null;
                try {
                    uri = this.getUriFromTld(path, stream);
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                if (uri == null || this.mappings.get(uri) != null) continue;
                this.mappings.put(uri, new String[]{path, null});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJar(URLConnection conn, String resourcePath, boolean ignore) throws JasperException, IOException {
        InputStream connIS = conn.getInputStream();
        JarInputStream jis = new JarInputStream(connIS);
        try {
            JarEntry entry = jis.getNextJarEntry();
            while (entry != null) {
                String name = entry.getName();
                if (!name.endsWith(".tld")) {
                    entry = jis.getNextJarEntry();
                    continue;
                }
                EntryInputStream eis = new EntryInputStream(jis);
                String uri = this.getUriFromTld(resourcePath, eis);
                if (uri != null && this.mappings.get(uri) == null) {
                    this.mappings.put(uri, new String[]{resourcePath, name});
                }
                entry = jis.getNextJarEntry();
            }
        }
        catch (Exception ex) {
            if (!ignore) {
                throw new JasperException((Throwable)ex);
            }
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (Throwable t) {}
            }
            if (connIS != null) {
                try {
                    connIS.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private String getUriFromTld(String resourcePath, InputStream in) throws JasperException {
        String body;
        TreeNode tld = new ParserUtils().parseXMLDocument(resourcePath, in);
        TreeNode uri = tld.findChild("uri");
        if (uri != null && (body = uri.getBody()) != null) {
            return body;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class EntryInputStream
    extends InputStream {
        private JarInputStream jis;

        EntryInputStream(JarInputStream jis) {
            this.jis = jis;
        }

        public int read() throws IOException {
            return this.jis.read();
        }

        public int available() throws IOException {
            return this.jis.available();
        }

        public void close() throws IOException {
        }

        public void reset() throws IOException {
            this.jis.reset();
        }

        public boolean markSupported() {
            return this.jis.markSupported();
        }

        public synchronized void mark(int readlimit) {
            this.jis.mark(readlimit);
        }

        public long skip(long n) throws IOException {
            return this.jis.skip(n);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.jis.read(b, off, len);
        }
    }
}

