/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.security;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.Principal;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.security.SecurityAssociation;

public final class SecurityClientInterceptor
implements Interceptor,
Serializable {
    public static final SecurityClientInterceptor singleton = new SecurityClientInterceptor();

    public String getName() {
        return "SecurityClientInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object credential;
        Principal principal = SecurityAssociation.getPrincipal();
        if (principal != null) {
            invocation.getMetaData().addMetaData((Object)"security", (Object)"principal", (Object)principal);
        }
        if ((credential = SecurityAssociation.getCredential()) != null) {
            invocation.getMetaData().addMetaData((Object)"security", (Object)"credential", credential);
        }
        return invocation.invokeNext();
    }

    Object readResolve() throws ObjectStreamException {
        return singleton;
    }
}

