/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.IOException;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TransformEnvelopedSignature
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";

    public boolean wantsOctetStream() {
        return true;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return true;
    }

    public boolean returnsNodeSet() {
        return false;
    }

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput) throws TransformationException {
        try {
            Element element;
            Node node = element = this._transformObject.getElement();
            node = TransformEnvelopedSignature.searchSignatureElement(node);
            if (xMLSignatureInput.isElement()) {
                XMLSignatureInput xMLSignatureInput2 = new XMLSignatureInput(xMLSignatureInput.getSubNode(), xMLSignatureInput.getCachedXPathAPI());
                xMLSignatureInput2.setExcludeNode(node);
                xMLSignatureInput2.setExcludeComments(xMLSignatureInput.isExcludeComments());
                return xMLSignatureInput2;
            }
            Set set = xMLSignatureInput.getNodeSet();
            if (set.isEmpty()) {
                Object[] objectArray = new Object[]{"input node set contains no nodes"};
                throw new TransformationException("generic.EmptyMessage", objectArray);
            }
            Set set2 = XMLUtils.excludeNodeFromSet(node, set);
            XMLSignatureInput xMLSignatureInput3 = new XMLSignatureInput(set2, null);
            return xMLSignatureInput3;
        }
        catch (IOException iOException) {
            throw new TransformationException("empty", iOException);
        }
        catch (SAXException sAXException) {
            throw new TransformationException("empty", sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformationException("empty", parserConfigurationException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new TransformationException("empty", canonicalizationException);
        }
    }

    private static Node searchSignatureElement(Node node) throws TransformationException {
        boolean bl = false;
        while (node != null && node.getNodeType() != 9) {
            Element element = (Element)node;
            if (element.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && element.getLocalName().equals("Signature")) {
                bl = true;
                break;
            }
            node = node.getParentNode();
        }
        if (!bl) {
            throw new TransformationException("envelopedSignatureTransformNotInSignatureElement");
        }
        return node;
    }
}

