/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.annotation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.AnnotationsWriter;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;

public class Annotation {
    ConstPool pool;
    int typeIndex;
    HashMap members;

    public Annotation(int type, ConstPool cp) {
        this.pool = cp;
        this.typeIndex = type;
        this.members = null;
    }

    public Annotation(String typeName, ConstPool cp) {
        this(cp.addUtf8Info(Descriptor.of(typeName)), cp);
    }

    public Annotation(ConstPool cp, CtClass clazz) throws NotFoundException {
        this(cp.addUtf8Info(Descriptor.of(clazz.getName())), cp);
        if (!clazz.isInterface()) {
            throw new RuntimeException("Only interfaces are allowed for Annotation creation.");
        }
        CtMethod[] methods = clazz.getDeclaredMethods();
        if (methods.length > 0) {
            this.members = new HashMap();
        }
        for (int i = 0; i < methods.length; ++i) {
            CtClass returnType = methods[i].getReturnType();
            this.addMemberValue(methods[i].getName(), Annotation.createMemberValue(cp, returnType));
        }
    }

    public static MemberValue createMemberValue(ConstPool cp, CtClass returnType) throws NotFoundException {
        if (returnType == CtClass.booleanType) {
            return new BooleanMemberValue(cp);
        }
        if (returnType == CtClass.byteType) {
            return new ByteMemberValue(cp);
        }
        if (returnType == CtClass.charType) {
            return new CharMemberValue(cp);
        }
        if (returnType == CtClass.shortType) {
            return new ShortMemberValue(cp);
        }
        if (returnType == CtClass.intType) {
            return new IntegerMemberValue(cp);
        }
        if (returnType == CtClass.longType) {
            return new LongMemberValue(cp);
        }
        if (returnType == CtClass.floatType) {
            return new FloatMemberValue(cp);
        }
        if (returnType == CtClass.doubleType) {
            return new DoubleMemberValue(cp);
        }
        if (returnType.getName().equals("java.lang.Class")) {
            return new ClassMemberValue(cp);
        }
        if (returnType.getName().equals("java.lang.String")) {
            return new StringMemberValue(cp);
        }
        if (returnType.isArray()) {
            CtClass arrayType = returnType.getComponentType();
            MemberValue type = Annotation.createMemberValue(cp, arrayType);
            return new ArrayMemberValue(type, cp);
        }
        if (returnType.isInterface()) {
            Annotation info = new Annotation(cp, returnType);
            return new AnnotationMemberValue(info, cp);
        }
        EnumMemberValue emv = new EnumMemberValue(cp);
        emv.setType(returnType.getName());
        return emv;
    }

    public void addMemberValue(int nameIndex, MemberValue value) {
        Pair p = new Pair();
        p.name = nameIndex;
        p.value = value;
        this.addMemberValue(p);
    }

    public void addMemberValue(String name, MemberValue value) {
        Pair p = new Pair();
        p.name = this.pool.addUtf8Info(name);
        p.value = value;
        if (this.members == null) {
            this.members = new HashMap();
        }
        this.members.put(name, p);
    }

    private void addMemberValue(Pair pair) {
        String name = this.pool.getUtf8Info(pair.name);
        if (this.members == null) {
            this.members = new HashMap();
        }
        this.members.put(name, pair);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("@");
        buf.append(this.getTypeName());
        if (this.members != null) {
            buf.append("(");
            Iterator mit = this.members.keySet().iterator();
            while (mit.hasNext()) {
                String name = (String)mit.next();
                buf.append(name).append("=").append(this.getMemberValue(name));
                if (!mit.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public String getTypeName() {
        return Descriptor.toClassName(this.pool.getUtf8Info(this.typeIndex));
    }

    public Set getMemberNames() {
        if (this.members == null) {
            return null;
        }
        return this.members.keySet();
    }

    public MemberValue getMemberValue(String name) {
        if (this.members == null) {
            return null;
        }
        Pair p = (Pair)this.members.get(name);
        if (p == null) {
            return null;
        }
        return p.value;
    }

    public void write(AnnotationsWriter writer) throws IOException {
        if (this.members == null) {
            writer.annotation(this.typeIndex, 0);
            return;
        }
        writer.annotation(this.typeIndex, this.members.size());
        Iterator it = this.members.values().iterator();
        while (it.hasNext()) {
            Pair pair = (Pair)it.next();
            writer.memberValuePair(pair.name);
            pair.value.write(writer);
        }
    }

    static class Pair {
        int name;
        MemberValue value;

        Pair() {
        }
    }
}

