/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.utils.URI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EnvelopeIdResolver
extends ResourceResolverSpi {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$message$EnvelopeIdResolver == null ? (class$org$apache$ws$security$message$EnvelopeIdResolver = EnvelopeIdResolver.class$("org.apache.ws.security.message.EnvelopeIdResolver")) : class$org$apache$ws$security$message$EnvelopeIdResolver).getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");
    private static EnvelopeIdResolver resolver = null;
    private boolean doDebug = false;
    static /* synthetic */ Class class$org$apache$ws$security$message$EnvelopeIdResolver;

    public static synchronized ResourceResolverSpi getInstance() {
        if (resolver == null) {
            resolver = new EnvelopeIdResolver();
        }
        return resolver;
    }

    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        this.doDebug = log.isDebugEnabled();
        long t0 = 0L;
        long t1 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        String uriNodeValue = uri.getNodeValue();
        if (this.doDebug) {
            log.debug((Object)("enter engineResolve, look for: " + uriNodeValue));
        }
        Document doc = uri.getOwnerDocument();
        XMLUtils.circumventBug2650((Document)doc);
        String id = uriNodeValue.substring(1);
        SOAPConstants sc = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        Element selectedElem = WSSecurityUtil.findBodyElement(doc, sc);
        if (selectedElem == null) {
            throw new ResourceResolverException("generic.EmptyMessage", new Object[]{"Body element not found"}, uri, BaseURI);
        }
        String cId = selectedElem.getAttributeNS(WSConstants.WSU_NS, "Id");
        if (!id.equals(cId)) {
            cId = null;
            selectedElem = WSSecurityUtil.getElementByWsuId(doc, uriNodeValue);
            if (selectedElem != null) {
                cId = selectedElem.getAttribute("Id");
            } else {
                selectedElem = WSSecurityUtil.getElementByGenId(doc, uriNodeValue);
                if (selectedElem != null) {
                    cId = selectedElem.getAttribute("Id");
                }
            }
            if (cId == null) {
                throw new ResourceResolverException("generic.EmptyMessage", new Object[]{"Id not found"}, uri, BaseURI);
            }
        }
        Set resultSet = this.dereferenceSameDocumentURI(selectedElem);
        XMLSignatureInput result = new XMLSignatureInput(resultSet);
        result.setMIMEType("text/xml");
        try {
            URI uriNew = new URI(new URI(BaseURI), uri.getNodeValue());
            result.setSourceURI(uriNew.toString());
        }
        catch (URI.MalformedURIException ex) {
            result.setSourceURI(BaseURI);
        }
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
            tlog.debug((Object)("engineResolve= " + (t1 - t0)));
        }
        if (this.doDebug) {
            log.debug((Object)("exit engineResolve, result: " + result));
        }
        return result;
    }

    public boolean engineCanResolve(Attr uri, String BaseURI) {
        if (uri == null) {
            return false;
        }
        String uriNodeValue = uri.getNodeValue();
        return uriNodeValue.startsWith("#");
    }

    private Set dereferenceSameDocumentURI(Node node) {
        HashSet nodeSet = new HashSet();
        if (node != null) {
            this.nodeSetMinusCommentNodes(node, nodeSet, null);
        }
        return nodeSet;
    }

    private void nodeSetMinusCommentNodes(Node node, Set nodeSet, Node prevSibling) {
        if (this.doDebug) {
            log.debug((Object)("Tag: " + node.getNodeName() + ", '" + node.getNodeValue() + "'"));
        }
        switch (node.getNodeType()) {
            case 1: {
                NamedNodeMap attrs = node.getAttributes();
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        if (this.doDebug) {
                            log.debug((Object)("Attr: " + attrs.item(i).getNodeName() + ", '" + attrs.item(i).getNodeValue() + "'"));
                        }
                        nodeSet.add(attrs.item(i));
                    }
                }
                nodeSet.add(node);
                Node pSibling = null;
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.nodeSetMinusCommentNodes(child, nodeSet, pSibling);
                    pSibling = child;
                }
                break;
            }
            case 3: 
            case 4: {
                if (prevSibling != null && (prevSibling.getNodeType() == 3 || prevSibling.getNodeType() == 4)) {
                    return;
                }
            }
            case 7: {
                nodeSet.add(node);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

