/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.conversation.message.token;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.EncryptedKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SecurityContextToken {
    public static final QName TOKEN = new QName(WSConstants.WSSE_NS, "SecurityContextToken");
    protected Element element = null;
    protected Element elementIdentifier = null;
    protected Element elementCreated = null;
    protected Element elementExpires = null;
    protected Element elementKeys = null;
    protected Element elementEncryptedKey = null;
    protected Element elementSecurityTokenReference = null;
    protected int timeout = 12;

    public SecurityContextToken(Document doc) {
        this.element = doc.createElementNS(WSConstants.WSSE_NS, "wsse:SecurityContextToken");
        WSSecurityUtil.setNamespace(this.element, WSConstants.WSSE_NS, "wsse");
        this.addIdentifier(doc);
        if (this.elementCreated == null) {
            this.addCreatedAndExpires(doc);
        }
    }

    public SecurityContextToken(Document doc, String identifier) {
        this.element = doc.createElementNS(WSConstants.WSSE_NS, "wsse:SecurityContextToken");
        WSSecurityUtil.setNamespace(this.element, WSConstants.WSSE_NS, "wsse");
        this.elementIdentifier = doc.createElementNS(WSConstants.WSSE_NS, "wsse:Identifier");
        this.element.appendChild(this.elementIdentifier);
        this.elementIdentifier.appendChild(doc.createTextNode(identifier));
    }

    public SecurityContextToken(Document doc, int timeout) {
        this.element = doc.createElementNS(WSConstants.WSSE_NS, "wsse:SecurityContextToken");
        WSSecurityUtil.setNamespace(this.element, WSConstants.WSSE_NS, "wsse");
        this.addIdentifier(doc);
        this.setTimeout(timeout);
        if (this.elementCreated == null) {
            this.addCreatedAndExpires(doc);
        }
    }

    private void addIdentifier(Document doc) {
        this.elementIdentifier = doc.createElementNS(WSConstants.WSSE_NS, "wsse:Identifier");
        WSSecurityUtil.setNamespace(this.elementIdentifier, WSConstants.WSSE_NS, "wsse");
        String uuid = "uuid:secureZone";
        this.elementIdentifier.appendChild(doc.createTextNode(uuid));
        this.element.appendChild(this.elementIdentifier);
    }

    public SecurityContextToken(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badTokenType00", new Object[]{el});
        }
        this.elementIdentifier = (Element)WSSecurityUtil.getDirectChild(this.element, "Identifier", WSConstants.WSSE_NS);
        this.elementCreated = (Element)WSSecurityUtil.getDirectChild(this.element, "Created", WSConstants.WSU_NS);
        this.elementExpires = (Element)WSSecurityUtil.getDirectChild(this.element, "Expires", WSConstants.WSU_NS);
        System.out.println("*\n*\n**\n*\n*\n*\n*\n*****");
    }

    private void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setIdentifier(Document doc, String uuid) {
        Text node = this.getFirstNode(this.elementIdentifier);
        node.setData(uuid);
    }

    public void addCreatedAndExpires(Document doc) {
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
        Calendar rightNow = Calendar.getInstance();
        this.elementCreated = doc.createElementNS(WSConstants.WSU_NS, "wsu:Created");
        WSSecurityUtil.setNamespace(this.elementCreated, WSConstants.WSU_NS, "wsu");
        this.elementExpires = doc.createElementNS(WSConstants.WSU_NS, "wsu:Expires");
        WSSecurityUtil.setNamespace(this.elementCreated, WSConstants.WSU_NS, "wsu");
        this.elementCreated.appendChild(doc.createTextNode(zulu.format(rightNow.getTime())));
        this.element.appendChild(this.elementCreated);
        String expTimeZone = "GMT+" + this.timeout + ":00";
        zulu.setTimeZone(TimeZone.getTimeZone(expTimeZone));
        this.elementExpires.appendChild(doc.createTextNode(zulu.format(rightNow.getTime())));
        this.element.appendChild(this.elementExpires);
    }

    public void setEncryptedKey(Document doc, EncryptedKey encryptedKey) {
        if (this.elementKeys == null) {
            this.elementKeys = doc.createElementNS(WSConstants.WSSE_NS, "wsse:Keys");
            this.element.appendChild(this.elementKeys);
        }
    }

    public void setSecuityTokenReference(Document doc, SecurityTokenReference ref) {
        if (this.elementKeys == null) {
            this.elementKeys = doc.createElementNS(WSConstants.WSSE_NS, "wsse:Keys");
            WSSecurityUtil.setNamespace(this.elementKeys, WSConstants.WSSE_NS, "wsse");
            this.element.appendChild(this.elementKeys);
        }
        WSSecurityUtil.appendChildElement(doc, this.elementKeys, ref.getElement());
    }

    public String getCreated() {
        if (this.elementCreated != null) {
            return this.getFirstNode(this.elementCreated).getData();
        }
        return null;
    }

    public String getIdentifier() {
        if (this.elementIdentifier != null) {
            return this.getFirstNode(this.elementIdentifier).getData();
        }
        return null;
    }

    public String getExpires() {
        if (this.elementExpires != null) {
            System.out.println("Date is ..............:: " + this.elementExpires.getChildNodes().item(0).getNodeValue());
            return this.elementExpires.getChildNodes().item(0).getNodeValue();
        }
        return null;
    }

    public void setCreated(String created) {
        Text node = this.getFirstNode(this.elementCreated);
        node.setData(created);
    }

    private Text getFirstNode(Element e) {
        Node node = e.getFirstChild();
        return node != null && node instanceof Text ? (Text)node : null;
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public String getID() {
        return this.element.getAttributeNS(WSConstants.WSU_NS, "Id");
    }

    public void setID(String id) {
        String prefix = WSSecurityUtil.setNamespace(this.element, WSConstants.WSU_NS, "wsu");
        this.element.setAttributeNS(WSConstants.WSU_NS, prefix + ":Id", id);
    }
}

