/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.conversation.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.message.token.SecurityContextToken;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RequestedSecurityToken {
    private SecurityContextToken securityContextToken;
    private Element element = null;
    public static final QName TOKEN = new QName(WSConstants.WSSE_NS, "RequestedSecurityToken");

    public RequestedSecurityToken(Document doc, SecurityContextToken securityContextToken) throws Exception {
        this.securityContextToken = securityContextToken;
        this.element = doc.createElementNS(WSConstants.WSSE_NS, "wsse:RequestedSecurityToken");
        this.securityContextToken = securityContextToken;
        this.element.appendChild(securityContextToken.getElement());
    }

    public RequestedSecurityToken(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badTokenType00", new Object[]{el});
        }
        Element token = (Element)WSSecurityUtil.getDirectChild(this.element, "SecurityContextToken", WSConstants.WSSE_NS);
        this.securityContextToken = new SecurityContextToken(token);
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public SecurityContextToken getSecurityContextToken() {
        return this.securityContextToken;
    }

    public void setSecurityContextToken(SecurityContextToken securityContextToken) {
        this.securityContextToken = securityContextToken;
    }
}

