/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.conversation.message.token;

import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.conversation.message.token.BaseToken;
import org.apache.ws.security.message.WSEncryptBody;
import org.apache.ws.security.util.DOM2Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RequestedProofToken {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$conversation$message$token$RequestedProofToken == null ? (class$org$apache$ws$security$conversation$message$token$RequestedProofToken = RequestedProofToken.class$("org.apache.ws.security.conversation.message.token.RequestedProofToken")) : class$org$apache$ws$security$conversation$message$token$RequestedProofToken).getName());
    public static final QName TOKEN = new QName(WSConstants.WSSE_NS, "RequestedProofToken");
    private Element proofEle;
    private Element keyInfoEle;
    private Element mgmtDataEle;
    private byte[] sharedSecret = null;
    private Crypto encCrypto = null;
    private boolean doDebug = false;
    private BaseToken base;
    protected String symEncAlgo = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    protected String keyEncAlgo = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    static /* synthetic */ Class class$org$apache$ws$security$conversation$message$token$RequestedProofToken;

    public RequestedProofToken(Document doc) throws WSSecurityException {
        this.proofEle = doc.createElementNS(WSConstants.WSSE_NS, "wsse:RequestedProofToken");
        System.out.println("RequestedProofToken....... created .....");
    }

    public RequestedProofToken(Element elem) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        QName el = new QName(elem.getNamespaceURI(), elem.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(0, "badElement", new Object[]{TOKEN, el});
        }
        this.proofEle = elem;
    }

    public void doDecryption(String callback, Crypto crypto) throws WSSecurityException {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        NodeList ndList = this.proofEle.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
        if (ndList.getLength() < 1) {
            throw new WSSecurityException(7, "RequestedProofToken is empty");
        }
        if (callback != null) {
            CallbackHandler cbHandler;
            Class<?> cbClass = null;
            try {
                cbClass = Class.forName(callback);
            }
            catch (ClassNotFoundException e) {
                throw new WSSecurityException(8, "RequestedProofToken: cannot load password callback class: " + callback);
            }
            try {
                cbHandler = (CallbackHandler)cbClass.newInstance();
            }
            catch (Exception e) {
                throw new WSSecurityException(8, "RequestedProofToken: cannot create instance of password callback: " + callback);
            }
            secEngine.handleEncryptedKey((Element)ndList.item(0), cbHandler, crypto);
            this.sharedSecret = secEngine.getDecryptedBytes();
            System.out.println(new String(this.sharedSecret));
        } else {
            System.out.println("Do somehting....... Decryption problem");
        }
    }

    public void doEncryptProof(Document doc) throws WSSecurityException {
        WSEncryptBody wsEncrypt = new WSEncryptBody();
        try {
            Crypto crypto = CryptoFactory.getInstance("crypto.properties");
            wsEncrypt.setKeyIdentifierType(1);
            wsEncrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e");
            wsEncrypt.setParentNode((Element)doc.getElementsByTagNameNS(WSConstants.WSSE_NS, "RequestedProofToken").item(0));
            wsEncrypt.build(doc, crypto);
            this.sharedSecret = wsEncrypt.getSymmetricKey().getEncoded();
        }
        catch (WSSecurityException e) {
            e.printStackTrace();
        }
    }

    public Element getElement() {
        return this.proofEle;
    }

    public byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    public String getID() {
        return this.proofEle.getAttributeNS(WSConstants.WSU_NS, "Id");
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.proofEle);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

