/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.conversation.message.token;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DerivedKeyToken {
    public static final QName TOKEN = new QName("http://schemas.xmlsoap.org/ws/2004/04/sc", "DerivedKeyToken");
    protected Element element = null;
    protected Element elementSecurityTokenReference = null;
    protected Element elementProperties = null;
    protected Element elementGeneration = null;
    protected Element elementOffset = null;
    protected Element elementLength = null;
    protected Element elementLabel = null;
    protected Element elementNonce = null;

    public DerivedKeyToken(Document doc) {
        this.element = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/sc", "wsc:DerivedKeyToken");
        WSSecurityUtil.setNamespace(this.element, "http://schemas.xmlsoap.org/ws/2004/04/sc", "wsc");
    }

    public DerivedKeyToken(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badTokenType00", new Object[]{el});
        }
        this.elementSecurityTokenReference = (Element)WSSecurityUtil.getDirectChild(this.element, "SecurityTokenReference", WSConstants.WSSE_NS);
        this.elementProperties = (Element)WSSecurityUtil.getDirectChild(this.element, "Properties", "http://schemas.xmlsoap.org/ws/2004/04/sc");
        this.elementGeneration = (Element)WSSecurityUtil.getDirectChild(this.element, "Generation", "http://schemas.xmlsoap.org/ws/2004/04/sc");
        this.elementOffset = (Element)WSSecurityUtil.getDirectChild(this.element, "Offset", "http://schemas.xmlsoap.org/ws/2004/04/sc");
        this.elementLength = (Element)WSSecurityUtil.getDirectChild(this.element, "Length", "http://schemas.xmlsoap.org/ws/2004/04/sc");
        this.elementLabel = (Element)WSSecurityUtil.getDirectChild(this.element, "Label", "http://schemas.xmlsoap.org/ws/2004/04/sc");
        this.elementNonce = (Element)WSSecurityUtil.getDirectChild(this.element, "Nonce", "http://schemas.xmlsoap.org/ws/2004/04/sc");
    }

    public void setSecuityTokenReference(Document doc, SecurityTokenReference ref) {
        WSSecurityUtil.appendChildElement(doc, this.element, ref.getElement());
    }

    public SecurityTokenReference getSecuityTokenReference() throws WSSecurityException {
        if (this.elementSecurityTokenReference != null) {
            return new SecurityTokenReference(this.elementSecurityTokenReference);
        }
        return null;
    }

    private void addProperty(Document doc, String propName, String propValue) {
        if (this.elementProperties == null) {
            this.elementProperties = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/sc", "wsc:Properties");
            WSSecurityUtil.setNamespace(this.elementProperties, "http://schemas.xmlsoap.org/ws/2004/04/sc", "wsse");
            this.element.appendChild(this.elementProperties);
        }
        Element tempElement = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/sc", "wsc:" + propName);
        tempElement.appendChild(doc.createTextNode(propValue));
        this.elementProperties.appendChild(tempElement);
    }

    public void setProperties(Document doc, String name, String label, String nonce) {
        Hashtable<String, String> table = new Hashtable<String, String>(3);
        table.put("Name", name);
        table.put("Label", label);
        table.put("Nonce", nonce);
        this.setProperties(doc, table);
    }

    public void setProperties(Document doc, Hashtable properties) {
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String propertyName = (String)keys.nextElement();
            Node node = WSSecurityUtil.findElement(this.elementProperties, propertyName, "http://schemas.xmlsoap.org/ws/2004/04/sc");
            if (node != null && node instanceof Element) {
                Text node1 = this.getFirstNode((Element)node);
                node1.setData((String)properties.get(propertyName));
                continue;
            }
            this.addProperty(doc, propertyName, (String)properties.get(propertyName));
        }
    }

    public Hashtable getProperties() {
        if (this.elementProperties != null) {
            Hashtable<String, String> table = new Hashtable<String, String>();
            NodeList nodes = this.elementProperties.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node tempNode = nodes.item(i);
                if (!(tempNode instanceof Element)) continue;
                Text text = this.getFirstNode((Element)tempNode);
                System.out.println(tempNode.getNodeName() + " : " + text.getData());
                table.put(tempNode.getNodeName(), text.getData());
            }
        }
        return null;
    }

    public void setLength(Document doc, long length) {
        this.elementLength = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/sc", "wsc:Length");
        WSSecurityUtil.setNamespace(this.elementLength, "http://schemas.xmlsoap.org/ws/2004/04/sc", "wsse");
        this.elementLength.appendChild(doc.createTextNode(Long.toString(length)));
        this.element.appendChild(this.elementLength);
    }

    public long getLength() {
        if (this.elementLength != null) {
            return Long.parseLong(this.getFirstNode(this.elementLength).getData());
        }
        return -1L;
    }

    public void setOffset(Document doc, int offset) {
        if (this.elementGeneration == null) {
            this.elementOffset = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/sc", "wsc:Offset");
            WSSecurityUtil.setNamespace(this.elementOffset, "http://schemas.xmlsoap.org/ws/2004/04/sc", "wsse");
            this.elementOffset.appendChild(doc.createTextNode(Integer.toString(offset)));
            this.element.appendChild(this.elementOffset);
        }
    }

    public int getOffset() {
        if (this.elementOffset != null) {
            return Integer.parseInt(this.getFirstNode(this.elementOffset).getData());
        }
        return -1;
    }

    public void setGeneration(Document doc, int generation) {
        if (this.elementOffset == null) {
            this.elementGeneration = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/sc", "wsc:Generation");
            WSSecurityUtil.setNamespace(this.elementGeneration, "http://schemas.xmlsoap.org/ws/2004/04/sc", "wsse");
            this.elementGeneration.appendChild(doc.createTextNode(Integer.toString(generation)));
            this.element.appendChild(this.elementGeneration);
        }
    }

    public int getGeneration() {
        if (this.elementGeneration != null) {
            return Integer.parseInt(this.getFirstNode(this.elementGeneration).getData());
        }
        return -1;
    }

    public void setLabel(Document doc, String label) {
        this.elementLabel = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/sc", "wsc:Label");
        WSSecurityUtil.setNamespace(this.elementLabel, "http://schemas.xmlsoap.org/ws/2004/04/sc", "wsse");
        this.elementLabel.appendChild(doc.createTextNode(label));
        this.element.appendChild(this.elementLabel);
    }

    public void setNonce(Document doc, String nonce) {
        this.elementNonce = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/sc", "wsc:Nonce");
        WSSecurityUtil.setNamespace(this.elementNonce, "http://schemas.xmlsoap.org/ws/2004/04/sc", "wsse");
        this.elementNonce.appendChild(doc.createTextNode(nonce));
        this.element.appendChild(this.elementNonce);
    }

    public String getLabel() {
        if (this.elementLabel != null) {
            return this.getFirstNode(this.elementLabel).getData();
        }
        return null;
    }

    public String getNonce() {
        if (this.elementNonce != null) {
            return this.getFirstNode(this.elementNonce).getData();
        }
        return null;
    }

    private Text getFirstNode(Element e) {
        Node node = e.getFirstChild();
        return node != null && node instanceof Text ? (Text)node : null;
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public String getID() {
        return this.element.getAttributeNS(WSConstants.WSU_NS, "Id");
    }

    public void setID(String id) {
        String prefix = WSSecurityUtil.setNamespace(this.element, WSConstants.WSU_NS, "wsu");
        this.element.setAttributeNS(WSConstants.WSU_NS, prefix + ":Id", id);
    }
}

