/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.utils.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSSecurityEngine {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$WSSecurityEngine == null ? (class$org$apache$ws$security$WSSecurityEngine = WSSecurityEngine.class$("org.apache.ws.security.WSSecurityEngine")) : class$org$apache$ws$security$WSSecurityEngine).getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");
    private static final Class[] constructorType = new Class[]{class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = WSSecurityEngine.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element};
    private static Map tokenImpl = new Hashtable();
    private static boolean sigCheck = true;
    private static WSSecurityEngine engine = null;
    private byte[] decryptedBytes = null;
    private boolean doDebug = false;
    protected static final QName BINARY_TOKEN = new QName(WSConstants.WSSE_NS, "BinarySecurityToken");
    protected static final QName USERNAME_TOKEN = new QName(WSConstants.WSSE_NS, "UsernameToken");
    protected static final QName SIGNATURE = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature");
    protected static final QName ENCRYPTED_KEY = new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
    protected static final QName REFERENCE_LIST = new QName("http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
    protected static final QName TIMESTAMP = new QName(WSConstants.WSU_NS, "Timestamp");
    protected static final QName SAML_TOKEN = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
    static /* synthetic */ Class class$org$apache$ws$security$WSSecurityEngine;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$org$apache$ws$security$message$token$PKIPathSecurity;
    static /* synthetic */ Class class$org$apache$ws$security$message$token$X509Security;

    public static synchronized WSSecurityEngine getInstance() {
        if (engine == null) {
            engine = new WSSecurityEngine();
        }
        return engine;
    }

    public Vector processSecurityHeader(Document doc, String actor, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        return this.processSecurityHeader(doc, actor, cb, crypto, crypto);
    }

    public Vector processSecurityHeader(Document doc, String actor, CallbackHandler cb, Crypto sigCrypto, Crypto decCrypto) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        if (this.doDebug) {
            log.debug((Object)"enter processSecurityHeader()");
        }
        if (actor == null) {
            actor = "";
        }
        Vector wsResult = null;
        SOAPConstants sc = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        Element elem = WSSecurityUtil.getSecurityHeader(doc, actor, sc);
        if (elem != null) {
            if (this.doDebug) {
                log.debug((Object)("Processing WS-Security header for '" + actor + "' actor."));
            }
            wsResult = this.processSecurityHeader(elem, cb, sigCrypto, decCrypto);
        }
        return wsResult;
    }

    protected Vector processSecurityHeader(Element securityHeader, CallbackHandler cb, Crypto sigCrypto, Crypto decCrypto) throws WSSecurityException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        WSDocInfo wsDocInfo = new WSDocInfo(securityHeader.getOwnerDocument().hashCode());
        wsDocInfo.setCrypto(sigCrypto);
        NodeList list = securityHeader.getChildNodes();
        int len = list.getLength();
        Object localName = null;
        Object namespace = null;
        Principal lastPrincipalFound = null;
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        Vector<WSSecurityEngineResult> returnResults = new Vector<WSSecurityEngineResult>();
        for (int i = 0; i < len; ++i) {
            Node elem = list.item(i);
            if (elem.getNodeType() != 1) continue;
            QName el = new QName(elem.getNamespaceURI(), elem.getLocalName());
            if (el.equals(SIGNATURE)) {
                if (this.doDebug) {
                    log.debug((Object)"Found signature element");
                }
                if (sigCrypto == null) {
                    throw new WSSecurityException(0, "noSigCryptoFile");
                }
                WSDocInfoStore.store(wsDocInfo);
                X509Certificate[] returnCert = new X509Certificate[1];
                Vector[] returnQname = new Vector[1];
                try {
                    lastPrincipalFound = this.verifyXMLSignature((Element)elem, sigCrypto, returnCert, returnQname);
                }
                catch (WSSecurityException ex) {
                    throw ex;
                }
                finally {
                    WSDocInfoStore.delete(wsDocInfo);
                }
                returnResults.add(0, new WSSecurityEngineResult(2, lastPrincipalFound, returnCert[0], returnQname[0]));
                continue;
            }
            if (el.equals(ENCRYPTED_KEY)) {
                if (this.doDebug) {
                    log.debug((Object)"Found encrypted key element");
                }
                if (decCrypto == null) {
                    throw new WSSecurityException(0, "noDecCryptoFile");
                }
                if (cb == null) {
                    throw new WSSecurityException(0, "noCallback");
                }
                this.handleEncryptedKey((Element)elem, cb, decCrypto);
                returnResults.add(0, new WSSecurityEngineResult(4, null, null, null));
                continue;
            }
            if (el.equals(REFERENCE_LIST)) {
                if (this.doDebug) {
                    log.debug((Object)"Found reference list element");
                }
                if (cb == null) {
                    throw new WSSecurityException(0, "noCallback");
                }
                this.handleReferenceList((Element)elem, cb);
                returnResults.add(0, new WSSecurityEngineResult(4, null, null, null));
                continue;
            }
            if (el.equals(USERNAME_TOKEN)) {
                if (this.doDebug) {
                    log.debug((Object)"Found UsernameToken list element");
                }
                if (cb == null) {
                    throw new WSSecurityException(0, "noCallback");
                }
                lastPrincipalFound = this.handleUsernameToken((Element)elem, cb);
                returnResults.add(0, new WSSecurityEngineResult(1, lastPrincipalFound, null, null));
                continue;
            }
            if (el.equals(SAML_TOKEN)) {
                if (this.doDebug) {
                    log.debug((Object)"Found SAML Assertion element");
                }
                SAMLAssertion assertion = this.handleSAMLToken((Element)elem);
                wsDocInfo.setAssertion((Element)elem);
                returnResults.add(0, new WSSecurityEngineResult(8, assertion));
                continue;
            }
            if (el.equals(TIMESTAMP)) {
                if (this.doDebug) {
                    log.debug((Object)"Found Timestamp list element");
                }
                Timestamp timestamp = new Timestamp((Element)elem);
                this.handleTimestamp(timestamp);
                returnResults.add(0, new WSSecurityEngineResult(32, timestamp));
                continue;
            }
            if (!this.doDebug) continue;
            log.debug((Object)("Unknown Element: " + elem.getLocalName() + " " + elem.getNamespaceURI()));
        }
        if (tlog.isDebugEnabled()) {
            t2 = System.currentTimeMillis();
            tlog.debug((Object)("processHeader: total= " + (t2 - t0) + ", prepare= " + (t1 - t0) + ", handle= " + (t2 - t1)));
        }
        return returnResults;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Principal verifyXMLSignature(Element elem, Crypto crypto, X509Certificate[] returnCert, Vector[] returnQname) throws WSSecurityException {
        if (this.doDebug) {
            log.debug((Object)"Verify XML Signature");
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        XMLSignature sig = null;
        try {
            sig = new XMLSignature(elem, null);
        }
        catch (XMLSignatureException e2) {
            throw new WSSecurityException(6, "noXMLSig");
        }
        catch (XMLSecurityException e2) {
            throw new WSSecurityException(6, "noXMLSig");
        }
        catch (IOException e2) {
            throw new WSSecurityException(6, "noXMLSig");
        }
        sig.addResourceResolver(EnvelopeIdResolver.getInstance());
        X509Certificate[] certs = null;
        KeyInfo info = sig.getKeyInfo();
        if (info != null) {
            Node node = WSSecurityUtil.getDirectChild(info.getElement(), SecurityTokenReference.TOKEN.getLocalPart(), SecurityTokenReference.TOKEN.getNamespaceURI());
            if (node == null) {
                throw new WSSecurityException(3, "unsupportedKeyInfo");
            }
            SecurityTokenReference secRef = new SecurityTokenReference((Element)node);
            int docHash = elem.getOwnerDocument().hashCode();
            if (this.doDebug) {
                log.debug((Object)("XML Verify doc: " + docHash));
            }
            WSDocInfo wsDocInfo = WSDocInfoStore.lookup(docHash);
            if (secRef.containsReference()) {
                Element token = secRef.getTokenElement(elem.getOwnerDocument(), wsDocInfo);
                QName el = new QName(token.getNamespaceURI(), token.getLocalName());
                if (el.equals(BINARY_TOKEN)) {
                    certs = this.getCertificatesTokenReference(token, crypto);
                } else {
                    if (!el.equals(SAML_TOKEN)) throw new WSSecurityException(3, "unsupportedToken", new Object[]{el.toString()});
                    certs = this.getCertificatesFromSAML(token, crypto);
                }
            } else if (secRef.containsX509IssuerSerial()) {
                certs = secRef.getX509IssuerSerial(crypto);
            } else if (secRef.containsKeyIdentifier()) {
                certs = secRef.getKeyIdentifier(crypto);
            }
        } else {
            if (crypto.getDefaultX509Alias() == null) throw new WSSecurityException(3, "unsupportedKeyInfo");
            certs = crypto.getCertificates(crypto.getDefaultX509Alias());
        }
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        if (certs == null || certs.length == 0 || certs[0] == null) {
            throw new WSSecurityException(6);
        }
        try {
            certs[0].checkValidity();
        }
        catch (CertificateExpiredException e) {
            throw new WSSecurityException(6, "invalidCert");
        }
        catch (CertificateNotYetValidException e) {
            throw new WSSecurityException(6, "invalidCert");
        }
        try {
            if (!sigCheck || !sig.checkSignatureValue(certs[0])) throw new WSSecurityException(6);
            if (tlog.isDebugEnabled()) {
                t2 = System.currentTimeMillis();
                tlog.debug((Object)("Verify: total= " + (t2 - t0) + ", prepare-cert= " + (t1 - t0) + ", verify= " + (t2 - t1)));
            }
            SignedInfo si = sig.getSignedInfo();
            int numReferences = si.getLength();
            Vector<QName> qvec = new Vector<QName>(numReferences);
            for (int i = 0; i < numReferences; ++i) {
                Reference siRef;
                try {
                    siRef = si.item(i);
                }
                catch (XMLSecurityException e3) {
                    throw new WSSecurityException(6);
                }
                String uri = siRef.getURI();
                Element se = WSSecurityUtil.getElementByWsuId(elem.getOwnerDocument(), uri);
                if (se == null) {
                    se = WSSecurityUtil.getElementByGenId(elem.getOwnerDocument(), uri);
                }
                if (se == null) {
                    throw new WSSecurityException(6);
                }
                QName qn = new QName(se.getNamespaceURI(), se.getLocalName());
                qvec.add(qn);
            }
            returnQname[0] = qvec;
            returnCert[0] = certs[0];
            return certs[0].getSubjectDN();
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(6);
        }
    }

    protected X509Certificate[] getCertificatesTokenReference(Element elem, Crypto crypto) throws WSSecurityException {
        BinarySecurity token = this.createSecurityToken(elem);
        if (token instanceof PKIPathSecurity) {
            return ((PKIPathSecurity)token).getX509Certificates(true, crypto);
        }
        if (token instanceof X509Security) {
            X509Certificate cert = ((X509Security)token).getX509Certificate(crypto);
            X509Certificate[] certs = new X509Certificate[]{cert};
            return certs;
        }
        throw new WSSecurityException(1, "unhandledToken", new Object[]{token.getClass().getName()});
    }

    protected X509Certificate[] getCertificatesFromSAML(Element elem, Crypto crypto) throws WSSecurityException {
        SAMLAssertion assertion;
        try {
            assertion = new SAMLAssertion(elem);
        }
        catch (SAMLException e) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (cannot parse)"});
        }
        SAMLSubjectStatement samlSubjS = null;
        Iterator it = assertion.getStatements();
        while (it.hasNext()) {
            SAMLObject so = (SAMLObject)it.next();
            if (!(so instanceof SAMLSubjectStatement)) continue;
            samlSubjS = (SAMLSubjectStatement)so;
            break;
        }
        SAMLSubject samlSubj = null;
        if (samlSubjS != null) {
            samlSubj = samlSubjS.getSubject();
        }
        if (samlSubj == null) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (no Subject)"});
        }
        Element e = samlSubj.getKeyInfo();
        X509Certificate[] certs = null;
        try {
            KeyInfo ki = new KeyInfo(e, null);
            if (ki.containsX509Data()) {
                X509Data data = ki.itemX509Data(0);
                XMLX509Certificate certElem = null;
                if (data != null && data.containsCertificate()) {
                    certElem = data.itemCertificate(0);
                }
                if (certElem != null) {
                    X509Certificate cert = certElem.getX509Certificate();
                    certs = new X509Certificate[]{cert};
                }
            }
        }
        catch (XMLSecurityException e3) {
            throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate (key holder)"});
        }
        return certs;
    }

    private BinarySecurity createSecurityToken(Element element) throws WSSecurityException {
        BinarySecurity token = new BinarySecurity(element);
        String type = token.getValueType();
        Class clazz = (Class)tokenImpl.get(type);
        if (clazz == null) {
            throw new WSSecurityException(1, "unsupportedBinaryTokenType", new Object[]{type});
        }
        try {
            Constructor constructor = clazz.getConstructor(constructorType);
            if (constructor == null) {
                throw new WSSecurityException(0, "invalidConstructor", new Object[]{clazz});
            }
            return (BinarySecurity)constructor.newInstance(element);
        }
        catch (InvocationTargetException e) {
            Throwable ee = e.getTargetException();
            if (ee instanceof WSSecurityException) {
                throw (WSSecurityException)ee;
            }
            throw new WSSecurityException(0, null, null, e);
        }
        catch (NoSuchMethodException e) {
            throw new WSSecurityException(0, null, null, e);
        }
        catch (InstantiationException e) {
            throw new WSSecurityException(0, null, null, e);
        }
        catch (IllegalAccessException e) {
            throw new WSSecurityException(0, null, null, e);
        }
    }

    public WSUsernameTokenPrincipal handleUsernameToken(Element token, CallbackHandler cb) throws WSSecurityException {
        UsernameToken ut = new UsernameToken(token);
        String user = ut.getName();
        if (this.doDebug) {
            log.debug((Object)("UsernameToken user " + user));
        }
        WSPasswordCallback pwCb = new WSPasswordCallback(user, 2);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            cb.handle(callbacks);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{user});
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{user});
        }
        String origPassword = pwCb.getPassword();
        if (this.doDebug) {
            log.debug((Object)("UsernameToken password " + origPassword));
        }
        if (origPassword == null) {
            throw new WSSecurityException(0, "noPassword", new Object[]{user});
        }
        String password = ut.getPassword();
        boolean result = false;
        WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(user, ut.isHashed());
        String nonce = ut.getNonce();
        String createdTime = ut.getCreated();
        principal.setNonce(nonce);
        principal.setCreatedTime(createdTime);
        if (ut.isHashed()) {
            String passDigest;
            if (nonce != null && createdTime != null && (passDigest = UsernameToken.doPasswordDigest(nonce, createdTime, origPassword)).equals(password)) {
                result = true;
            }
        } else if (origPassword.equals(password)) {
            result = true;
        }
        if (!result) {
            throw new WSSecurityException(5);
        }
        return principal;
    }

    public SAMLAssertion handleSAMLToken(Element token) throws WSSecurityException {
        boolean result = false;
        SAMLAssertion assertion = null;
        try {
            assertion = new SAMLAssertion(token);
            result = true;
            if (this.doDebug) {
                log.debug((Object)("SAML Assertion issuer " + assertion.getIssuer()));
            }
        }
        catch (SAMLException e) {
            throw new WSSecurityException(0, "invalidSAMLsecurity", null, e);
        }
        if (!result) {
            throw new WSSecurityException(5);
        }
        return assertion;
    }

    public void handleTimestamp(Timestamp timestamp) throws WSSecurityException {
        if (this.doDebug) {
            log.debug((Object)"Preparing to verify the timestamp");
            SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
            log.debug((Object)("Current time: " + zulu.format(Calendar.getInstance().getTime())));
            log.debug((Object)("Timestamp created: " + zulu.format(timestamp.getCreated().getTime())));
            log.debug((Object)("Timestamp expires: " + zulu.format(timestamp.getExpires().getTime())));
        }
        Calendar rightNow = Calendar.getInstance();
        if (timestamp.getExpires().before(rightNow)) {
            throw new WSSecurityException(3, "invalidTimestamp", new Object[]{"The security semantics of message have expired"});
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEncryptedKey(Element xencEncryptedKey, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        void var18_17;
        String alias;
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        Document doc = xencEncryptedKey.getOwnerDocument();
        Element envelope = doc.getDocumentElement();
        Element nsContext = WSSecurityUtil.createNamespaceContext(doc);
        Node tmpE = null;
        tmpE = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        String keyEncAlgo = null;
        if (tmpE != null) {
            keyEncAlgo = tmpE.getAttribute("Algorithm");
        }
        if (keyEncAlgo == null) {
            throw new WSSecurityException(2, "noEncAlgo");
        }
        Cipher cipher = WSSecurityUtil.getCipherInstance(keyEncAlgo);
        Element xencCipherValue = null;
        tmpE = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "CipherData", "http://www.w3.org/2001/04/xmlenc#");
        if (tmpE != null) {
            xencCipherValue = (Element)WSSecurityUtil.getDirectChild(tmpE, "CipherValue", "http://www.w3.org/2001/04/xmlenc#");
        }
        if (xencCipherValue == null) {
            throw new WSSecurityException(3, "noCipher");
        }
        Element keyInfo = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        if (keyInfo != null) {
            Element secRefToken = (Element)WSSecurityUtil.getDirectChild(keyInfo, "SecurityTokenReference", WSConstants.WSSE_NS);
            if (secRefToken == null) {
                throw new WSSecurityException(3, "noSecTokRef");
            }
            SecurityTokenReference secRef = new SecurityTokenReference(secRefToken);
            alias = null;
            if (secRef.containsX509IssuerSerial()) {
                alias = secRef.getX509IssuerSerialAlias(crypto);
                if (this.doDebug) {
                    log.debug((Object)("X509IssuerSerial alias: " + alias));
                }
            } else if (secRef.containsKeyIdentifier()) {
                X509Certificate[] certs = secRef.getKeyIdentifier(crypto);
                if (certs == null || certs.length != 1 || certs[0] == null) {
                    throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for decryption (KeyId)"});
                }
                alias = crypto.getAliasForX509Cert(certs[0]);
                if (this.doDebug) {
                    log.debug((Object)("cert: " + certs[0]));
                    log.debug((Object)("KeyIdentifier Alias: " + alias));
                }
            } else {
                if (!secRef.containsReference()) throw new WSSecurityException(0, "unsupportedKeyId");
                Element bstElement = secRef.getTokenElement(doc, null);
                QName el = new QName(bstElement.getNamespaceURI(), bstElement.getLocalName());
                if (!el.equals(BINARY_TOKEN)) throw new WSSecurityException(3, "unsupportedToken", null);
                X509Security token = null;
                String value = bstElement.getAttribute("ValueType");
                if (value.length() == 0) {
                    value = bstElement.getAttributeNS(WSConstants.WSSE_NS, "ValueType");
                }
                if (!value.endsWith("X509v3") || (token = new X509Security(bstElement)) == null) {
                    throw new WSSecurityException(1, "unsupportedBinaryTokenType", new Object[]{"for decryption (BST)"});
                }
                X509Certificate cert = token.getX509Certificate(crypto);
                if (cert == null) {
                    throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for decryption"});
                }
                alias = crypto.getAliasForX509Cert(cert);
                if (this.doDebug) {
                    log.debug((Object)("BST Alias: " + alias));
                }
            }
        } else {
            if (crypto.getDefaultX509Alias() == null) throw new WSSecurityException(3, "noKeyinfo");
            alias = crypto.getDefaultX509Alias();
        }
        WSPasswordCallback pwCb = new WSPasswordCallback((String)var18_17, 1);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            cb.handle(callbacks);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{var18_17});
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{var18_17});
        }
        String password = pwCb.getPassword();
        if (password == null) {
            throw new WSSecurityException(0, "noPassword", new Object[]{var18_17});
        }
        try {
            cipher.init(2, crypto.getPrivateKey((String)var18_17, password));
        }
        catch (InvalidKeyException e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
        catch (Exception e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
        try {
            this.decryptedBytes = cipher.doFinal(WSSecurityEngine.getDecodedBase64EncodedData(xencCipherValue));
        }
        catch (IllegalStateException e2) {
            throw new WSSecurityException(8, null, null, e2);
        }
        catch (IllegalBlockSizeException e2) {
            throw new WSSecurityException(8, null, null, e2);
        }
        catch (BadPaddingException e2) {
            throw new WSSecurityException(8, null, null, e2);
        }
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        String dataRefURI = null;
        String keyRefURI = null;
        Element refList = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "ReferenceList", "http://www.w3.org/2001/04/xmlenc#");
        if (refList != null) {
            for (tmpE = refList.getFirstChild(); tmpE != null; tmpE = tmpE.getNextSibling()) {
                if (tmpE.getNodeType() != 1 || !tmpE.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#")) continue;
                if (tmpE.getLocalName().equals("DataReference")) {
                    dataRefURI = ((Element)tmpE).getAttribute("URI");
                    this.decryptDataRef(doc, dataRefURI, this.decryptedBytes);
                    continue;
                }
                if (!tmpE.getLocalName().equals("KeyReference")) continue;
                keyRefURI = ((Element)tmpE).getAttribute("URI");
            }
        }
        if (!tlog.isDebugEnabled()) return;
        t2 = System.currentTimeMillis();
        tlog.debug((Object)("XMLDecrypt: total= " + (t2 - t0) + ", get-sym-key= " + (t1 - t0) + ", decrypt= " + (t2 - t1)));
    }

    private void decryptDataRef(Document doc, String dataRefURI, byte[] decryptedBytes) throws WSSecurityException {
        if (this.doDebug) {
            log.debug((Object)("found data refernce: " + dataRefURI));
        }
        Element encBodyData = null;
        encBodyData = WSSecurityUtil.getElementByWsuId(doc, dataRefURI);
        if (encBodyData == null) {
            encBodyData = WSSecurityUtil.getElementByGenId(doc, dataRefURI);
        }
        if (encBodyData == null) {
            throw new WSSecurityException(3, "dataRef", new Object[]{dataRefURI});
        }
        boolean content = this.isContent(encBodyData);
        String symEncAlgo = this.getEncAlgo(encBodyData);
        SecretKey symmetricKey = WSSecurityUtil.prepareSecretKey(symEncAlgo, decryptedBytes);
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)symEncAlgo);
            xmlCipher.init(2, (Key)symmetricKey);
        }
        catch (XMLEncryptionException e) {
            throw new WSSecurityException(2, null, null, e);
        }
        if (content) {
            encBodyData = (Element)encBodyData.getParentNode();
        }
        try {
            xmlCipher.doFinal(doc, encBodyData, content);
        }
        catch (Exception e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
    }

    private void handleReferenceList(Element elem, CallbackHandler cb) throws WSSecurityException {
        Document doc = elem.getOwnerDocument();
        Node tmpE = null;
        for (tmpE = elem.getFirstChild(); tmpE != null; tmpE = tmpE.getNextSibling()) {
            if (tmpE.getNodeType() != 1 || !tmpE.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#")) continue;
            if (tmpE.getLocalName().equals("DataReference")) {
                String dataRefURI = ((Element)tmpE).getAttribute("URI");
                this.decryptDataRefEmbedded(doc, dataRefURI, cb);
                continue;
            }
            if (!tmpE.getLocalName().equals("KeyReference")) continue;
            String keyRefURI = ((Element)tmpE).getAttribute("URI");
        }
    }

    private void decryptDataRefEmbedded(Document doc, String dataRefURI, CallbackHandler cb) throws WSSecurityException {
        if (this.doDebug) {
            log.debug((Object)("Embedded found data refernce: " + dataRefURI));
        }
        Element encBodyData = null;
        encBodyData = WSSecurityUtil.getElementByWsuId(doc, dataRefURI);
        if (encBodyData == null) {
            encBodyData = WSSecurityUtil.getElementByGenId(doc, dataRefURI);
        }
        if (encBodyData == null) {
            throw new WSSecurityException(3, "dataRef", new Object[]{dataRefURI});
        }
        boolean content = this.isContent(encBodyData);
        String symEncAlgo = this.getEncAlgo(encBodyData);
        Element tmpE = (Element)WSSecurityUtil.findElement(encBodyData, "KeyName", "http://www.w3.org/2000/09/xmldsig#");
        byte[] decryptedBytes = this.getSharedKey(tmpE, cb);
        SecretKey symmetricKey = WSSecurityUtil.prepareSecretKey(symEncAlgo, decryptedBytes);
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)symEncAlgo);
            xmlCipher.init(2, (Key)symmetricKey);
        }
        catch (XMLEncryptionException e1) {
            throw new WSSecurityException(2, null, null, e1);
        }
        if (content) {
            encBodyData = (Element)encBodyData.getParentNode();
        }
        try {
            xmlCipher.doFinal(doc, encBodyData, content);
        }
        catch (Exception e) {
            throw new WSSecurityException(8, null, null, e);
        }
    }

    private boolean isContent(Node encBodyData) {
        Element tmpE = (Element)WSSecurityUtil.findElement(encBodyData, "EncryptedData", "http://www.w3.org/2001/04/xmlenc#");
        String typeStr = null;
        boolean content = true;
        if (tmpE != null) {
            typeStr = tmpE.getAttribute("Type");
        }
        if (typeStr != null) {
            content = typeStr.equals("http://www.w3.org/2001/04/xmlenc#Content");
        }
        return content;
    }

    private String getEncAlgo(Node encBodyData) throws WSSecurityException {
        Element tmpE = (Element)WSSecurityUtil.findElement(encBodyData, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        String symEncAlgo = null;
        if (tmpE != null) {
            symEncAlgo = tmpE.getAttribute("Algorithm");
        }
        if (symEncAlgo == null) {
            throw new WSSecurityException(2, "noEncAlgo");
        }
        if (this.doDebug) {
            log.debug((Object)("Sym Enc Algo: " + symEncAlgo));
        }
        return symEncAlgo;
    }

    private byte[] getSharedKey(Element keyNmElem, CallbackHandler cb) throws WSSecurityException {
        String keyName = null;
        if (keyNmElem != null) {
            keyNmElem.normalize();
            Node tmpN = keyNmElem.getFirstChild();
            if (tmpN != null && tmpN.getNodeType() == 3) {
                keyName = tmpN.getNodeValue();
            }
        }
        if (keyName == null) {
            throw new WSSecurityException(3, "noKeyname");
        }
        WSPasswordCallback pwCb = new WSPasswordCallback(keyName, 4);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            cb.handle(callbacks);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{keyName});
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{keyName});
        }
        byte[] decryptedBytes = pwCb.getKey();
        if (decryptedBytes == null) {
            throw new WSSecurityException(0, "noPassword", new Object[]{keyName});
        }
        return decryptedBytes;
    }

    public static byte[] getDecodedBase64EncodedData(Element element) throws WSSecurityException {
        StringBuffer sb = new StringBuffer();
        NodeList children = element.getChildNodes();
        int iMax = children.getLength();
        for (int i = 0; i < iMax; ++i) {
            Node curr = children.item(i);
            if (curr.getNodeType() != 3) continue;
            sb.append(((Text)curr).getData());
        }
        String encodedData = sb.toString();
        try {
            return Base64.decode((String)encodedData);
        }
        catch (Base64DecodingException e) {
            throw new WSSecurityException(0, null, null, e);
        }
    }

    public byte[] getDecryptedBytes() {
        return this.decryptedBytes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Init.init();
        String Id = "BC";
        if (Security.getProvider(Id) == null) {
            log.debug((Object)("The provider " + Id + " had to be added to the java.security.Security"));
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        tokenImpl.put(PKIPathSecurity.TYPE, class$org$apache$ws$security$message$token$PKIPathSecurity == null ? (class$org$apache$ws$security$message$token$PKIPathSecurity = WSSecurityEngine.class$("org.apache.ws.security.message.token.PKIPathSecurity")) : class$org$apache$ws$security$message$token$PKIPathSecurity);
        tokenImpl.put(X509Security.TYPE, class$org$apache$ws$security$message$token$X509Security == null ? (class$org$apache$ws$security$message$token$X509Security = WSSecurityEngine.class$("org.apache.ws.security.message.token.X509Security")) : class$org$apache$ws$security$message$token$X509Security);
        Transform.init();
        try {
            Transform.register((String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", (String)"org.apache.ws.security.transform.STRTransform");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

