/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security.conversation;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.ws.axis.security.WSDoAllSender;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.conversation.ConversationManager;
import org.apache.ws.security.conversation.ConversationUtil;
import org.apache.ws.security.conversation.DerivedKeyCallbackHandler;
import org.apache.ws.security.conversation.message.info.SecurityContextInfo;
import org.apache.ws.security.conversation.message.token.DerivedKeyToken;
import org.apache.ws.security.conversation.message.token.RequestSecurityTokenResponse;
import org.apache.ws.security.conversation.message.token.RequestedProofToken;
import org.apache.ws.security.conversation.message.token.SecurityContextToken;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConversationClientHandler
extends BasicHandler {
    private boolean isTokenInMemory = false;
    private int requestCount = 0;
    private RequestSecurityTokenResponse stRes;
    private DerivedKeyCallbackHandler dkcbHandler;
    private int frequency = 2;
    private WSSecurityEngine secEng = null;
    private String uuid = null;

    public ConversationClientHandler() {
        System.out.println("ConversationClientHandler :: created");
        this.dkcbHandler = new DerivedKeyCallbackHandler();
    }

    public void invoke(MessageContext msg) throws AxisFault {
        System.out.println("ConversationClientHandler :: invoked");
        if (msg.getPastPivot()) {
            this.doResponse(msg);
        } else {
            this.doRequest(msg);
        }
    }

    private void doRequest(MessageContext msg) throws AxisFault {
        Init.init();
        Object sHeader = null;
        Message sm = msg.getCurrentMessage();
        SOAPPart sPart = (SOAPPart)sm.getSOAPPart();
        Document doc = null;
        try {
            doc = ((SOAPEnvelope)sPart.getEnvelope()).getAsDocument();
            if (this.isTokenInMemory) {
                System.out.println("Token in memory .");
                String genID = ConversationUtil.genericID();
                ConversationManager conMan = new ConversationManager();
                conMan.addDerivedKeyToken(doc, this.uuid, this.dkcbHandler, genID);
                Element securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(doc, doc.getDocumentElement(), false);
                WSSecurityUtil.appendChildElement(doc, securityHeader, new SecurityContextToken(doc, this.uuid).getElement());
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
                String osStr = os.toString();
                sPart.setCurrentMessage((Object)osStr, 1);
                Reference ref = new Reference(doc);
                ref.setURI("#" + genID);
                ref.setValueType("DerivedKeyToken");
                SecurityTokenReference stRef = new SecurityTokenReference(doc);
                stRef.setReference(ref);
                msg.setProperty("encryptionPropFile", (Object)"crypto.properties");
                msg.setProperty("encryptionKeyIdentifier", (Object)"EmbeddedKeyName");
                msg.setProperty("EmbeddedKeyName", (Object)stRef.toString());
                msg.setUsername(ConversationUtil.generateIdentifier(this.uuid, genID));
                msg.setProperty("EmbeddedKeyCallbackRef", (Object)this.dkcbHandler);
                msg.setProperty("action", (Object)"Encrypt");
                WSDoAllSender wsd = new WSDoAllSender();
                wsd.invoke(msg);
            } else {
                this.stRes = new RequestSecurityTokenResponse(doc);
                this.uuid = this.stRes.getRequestedSecurityToken().getSecurityContextToken().getIdentifier();
                this.isTokenInMemory = true;
                this.stRes.build(doc);
                RequestedProofToken reqProof = this.stRes.getRequestedProofToken();
                reqProof.doEncryptProof(doc);
                SecurityContextInfo info = new SecurityContextInfo(this.stRes.getRequestedSecurityToken().getSecurityContextToken(), reqProof, 1);
                DerivedKeyCallbackHandler.addSecurtiyContext(this.uuid, info);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
                String osStr = os.toString();
                sPart.setCurrentMessage((Object)osStr, 1);
            }
        }
        catch (AxisFault e) {
            e.printStackTrace();
        }
        catch (WSSecurityException e) {
            e.printStackTrace();
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doResponse(MessageContext msgContext) throws AxisFault {
        Document doc = null;
        Message message = msgContext.getCurrentMessage();
        this.secEng = new WSSecurityEngine();
        SOAPPart sPart = (SOAPPart)message.getSOAPPart();
        try {
            doc = ((SOAPEnvelope)sPart.getEnvelope()).getAsDocument();
        }
        catch (Exception e) {
            throw new AxisFault("WSDoAllSender: cannot get SOAP envlope from message" + e);
        }
        try {
            NodeList ndList = doc.getElementsByTagNameNS(WSConstants.WSSE_NS, "DerivedKeyToken");
            for (int i = 0; i < ndList.getLength(); ++i) {
                Element tmpE = (Element)ndList.item(i);
                DerivedKeyToken tmpDKT = new DerivedKeyToken(tmpE);
                String tmpID = tmpDKT.getID();
            }
            this.secEng.processSecurityHeader(doc, "", this.dkcbHandler, null);
        }
        catch (WSSecurityException e1) {
            e1.printStackTrace();
            throw new AxisFault("Error !!!! " + e1.getMessage());
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
        sPart.setCurrentMessage((Object)os.toByteArray(), 4);
    }

    private Crypto loadEncryptionCrypto() throws AxisFault {
        Crypto crypto = null;
        String encPropFile = "crypto.properties";
        crypto = CryptoFactory.getInstance(encPropFile);
        return crypto;
    }
}

