/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.scanner;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.Deployer;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.scanner.AbstractDeploymentScanner;
import org.jboss.deployment.scanner.DeploymentScanner;
import org.jboss.deployment.scanner.URLDirectoryScannerMBean;
import org.jboss.system.server.ServerConfigLocator;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class URLDirectoryScanner
extends AbstractDeploymentScanner
implements DeploymentScanner,
URLDirectoryScannerMBean {
    private FileFilter defaultFilter;
    private Comparator defaultComparator;
    private ArrayList scanners = new ArrayList();
    private HashMap urlScannerMap = new HashMap();
    private File serverHome;
    static /* synthetic */ Class class$java$net$URL;

    public void addScanURL(URL url) {
        Scanner scanner = new Scanner(url);
        this.addScanner(scanner);
    }

    public void addScanURL(String url) throws MalformedURLException {
        this.addScanURL(this.toUrl(url));
    }

    public void addScanDir(URL url, Comparator comp, FileFilter filter) {
        DirScanner scanner = new DirScanner(url, comp, filter);
        this.addScanner(scanner);
    }

    public void addScanDir(String urlSpec, String compClassName, String filterClassName) throws MalformedURLException {
        URL url = this.toUrl(urlSpec);
        Comparator comp = null;
        if (compClassName != null) {
            try {
                Class<?> compClass = Thread.currentThread().getContextClassLoader().loadClass("compClassName");
                comp = (Comparator)compClass.newInstance();
            }
            catch (Exception e) {
                this.log.warn((Object)"Unable to create instance of Comparator.  Ignoring.", (Throwable)e);
            }
        }
        FileFilter filter = null;
        if (filterClassName != null) {
            try {
                Class<?> filterClass = Thread.currentThread().getContextClassLoader().loadClass(filterClassName);
                filter = (FileFilter)filterClass.newInstance();
            }
            catch (Exception e) {
                this.log.warn((Object)"Unable to create instance of Filter.  Ignoring.", (Throwable)e);
            }
        }
        this.addScanDir(url, comp, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addScanner(Scanner scanner) {
        ArrayList arrayList = this.scanners;
        synchronized (arrayList) {
            if (this.isScanEnabled()) {
                ArrayList<Scanner> localScanners = new ArrayList<Scanner>(this.scanners);
                HashMap<URL, Scanner> localMap = new HashMap<URL, Scanner>(this.urlScannerMap);
                localScanners.add(scanner);
                localMap.put(scanner.url, scanner);
                this.scanners = localScanners;
                this.urlScannerMap = localMap;
            } else {
                this.scanners.add(scanner);
                this.urlScannerMap.put(scanner.url, scanner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScanURL(URL url) {
        ArrayList arrayList = this.scanners;
        synchronized (arrayList) {
            if (this.isScanEnabled()) {
                ArrayList localScanners = new ArrayList(this.scanners);
                HashMap localMap = new HashMap(this.urlScannerMap);
                Scanner scanner = (Scanner)localMap.remove(url);
                if (scanner != null) {
                    localScanners.remove(scanner);
                }
                this.scanners = localScanners;
                this.urlScannerMap = localMap;
            } else {
                Scanner scanner = (Scanner)this.urlScannerMap.remove(url);
                if (scanner != null) {
                    this.scanners.remove(scanner);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURLs(Element elem) {
        ArrayList localScanners = new ArrayList();
        HashMap localMap = new HashMap();
        NodeList list = elem.getChildNodes();
        ArrayList arrayList = this.scanners;
        synchronized (arrayList) {
            this.scanners.clear();
            this.urlScannerMap.clear();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (node.getNodeType() != 1) continue;
                NamedNodeMap nodeMap = node.getAttributes();
                String name = this.getNodeValue(nodeMap.getNamedItem("name"));
                if (name == null) {
                    this.log.warn((Object)("No name specified in URLDirectoryScanner config: " + node + ".  Ignoring"));
                    continue;
                }
                try {
                    if (node.getNodeName().equals("dir")) {
                        String filter = this.getNodeValue(nodeMap.getNamedItem("filter"));
                        String comp = this.getNodeValue(nodeMap.getNamedItem("comparator"));
                        this.addScanDir(name, comp, filter);
                        continue;
                    }
                    if (!node.getNodeName().equals("url")) continue;
                    this.addScanURL(name);
                    continue;
                }
                catch (MalformedURLException e) {
                    this.log.warn((Object)"Invalid url in DeploymentScanner.  Ignoring.", (Throwable)e);
                }
            }
        }
    }

    private String getNodeValue(Node node) {
        if (node == null) {
            return null;
        }
        String val = node.getNodeValue();
        if (val == null) {
            return null;
        }
        if ((val = val.trim()).length() == 0) {
            return null;
        }
        return val;
    }

    private URL toUrl(String value) throws MalformedURLException {
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            File file = new File(value);
            if (!file.isAbsolute()) {
                file = new File(this.serverHome, value);
            }
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException ioe) {
                throw new MalformedURLException("Can not obtain file: " + ioe);
            }
            return file.toURL();
        }
    }

    public void setURLComparator(String comparatorClassName) {
        this.log.debug((Object)("Setting Comparator: " + comparatorClassName));
        try {
            this.defaultComparator = (Comparator)Thread.currentThread().getContextClassLoader().loadClass(comparatorClassName).newInstance();
        }
        catch (Exception e) {
            this.log.warn((Object)"Unable to create URLComparator.", (Throwable)e);
        }
    }

    public String getURLComparator() {
        if (this.defaultComparator == null) {
            return null;
        }
        return this.defaultComparator.getClass().getName();
    }

    public void setFilter(String filterClassName) {
        this.log.debug((Object)("Setting Filter: " + filterClassName));
        try {
            this.defaultFilter = (FileFilter)Thread.currentThread().getContextClassLoader().loadClass(filterClassName).newInstance();
        }
        catch (Exception e) {
            this.log.warn((Object)"Unable to create URLComparator.", (Throwable)e);
        }
    }

    public String getFilter() {
        if (this.defaultFilter == null) {
            return null;
        }
        return this.defaultFilter.getClass().getName();
    }

    Deployer getDeployerObj() {
        return this.deployer;
    }

    public void scan() {
        this.log.trace((Object)"Scanning urls...");
        Iterator iter = this.scanners.iterator();
        while (iter.hasNext()) {
            ((Scanner)iter.next()).scan();
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.serverHome = ServerConfigLocator.locate().getServerHomeDir();
        return super.preRegister(server, name);
    }

    private static class FileComparator
    implements Comparator {
        private Comparator urlComparator;

        public FileComparator(Comparator urlComparator) {
            this.urlComparator = urlComparator;
        }

        public int compare(Object o1, Object o2) {
            File file2;
            URL url2;
            File file1;
            URL url1;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 instanceof URL) {
                url1 = (URL)o1;
                file1 = new File(url1.getPath());
            } else {
                file1 = (File)o1;
                try {
                    url1 = file1.toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException("Unable to create file url: " + file1 + ": " + e);
                }
            }
            if (o2 instanceof URL) {
                url2 = (URL)o2;
                file2 = new File(url2.getPath());
            } else {
                file2 = (File)o2;
                try {
                    url2 = file2.toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException("Unable to create file url: " + file2 + ": " + e);
                }
            }
            int comp = 0;
            if (this.urlComparator != null) {
                comp = this.urlComparator.compare(url1, url2);
            }
            if (comp == 0) {
                comp = file1.compareTo(file2);
            }
            return comp < 0 ? -1 : (comp > 0 ? 1 : 0);
        }
    }

    private class DirScanner
    extends Scanner {
        private File dir;
        private FileFilter filter;
        private Comparator comp;
        private ArrayList deployed;

        public DirScanner(URL url, Comparator comp, FileFilter filter) {
            super(url);
            this.deployed = new ArrayList();
            if (!url.getProtocol().equals("file")) {
                throw new IllegalArgumentException("Urls for directory scanning must use the file: protocol.");
            }
            this.dir = new File(url.getPath()).getAbsoluteFile();
            this.filter = filter == null ? URLDirectoryScanner.this.defaultFilter : filter;
            this.comp = new FileComparator(comp == null ? URLDirectoryScanner.this.defaultComparator : comp);
        }

        public void scan() {
            if (!this.dir.exists()) {
                URLDirectoryScanner.this.getLog().warn((Object)("The director to scan does not exist: " + this.dir));
                return;
            }
            if (!this.dir.isDirectory()) {
                URLDirectoryScanner.this.getLog().warn((Object)("The directory to scan is not a directory: " + this.dir));
                return;
            }
            File[] files = this.filter == null ? this.dir.listFiles() : this.dir.listFiles(this.filter);
            Arrays.sort(files, this.comp);
            int deployedIndex = 0;
            int fileIndex = 0;
            while (true) {
                Scanner scanner = null;
                if (deployedIndex < this.deployed.size()) {
                    scanner = (Scanner)this.deployed.get(deployedIndex);
                }
                File file = null;
                if (fileIndex < files.length) {
                    file = files[fileIndex];
                }
                if (scanner == null && file == null) break;
                switch (this.comp.compare(file, scanner == null ? null : scanner.url)) {
                    case -1: {
                        URLDirectoryScanner.this.getLog().debug((Object)("Found new deployable application in directory " + this.dir + ": " + file));
                        try {
                            scanner = new Scanner(file.toURL());
                            this.deployed.add(deployedIndex, scanner);
                        }
                        catch (MalformedURLException e) {
                            URLDirectoryScanner.this.getLog().warn((Object)("Unable to obtain URL for file: " + file), (Throwable)e);
                            ++fileIndex;
                        }
                    }
                    case 0: {
                        scanner.scan();
                        ++deployedIndex;
                        ++fileIndex;
                        break;
                    }
                    case 1: {
                        URLDirectoryScanner.this.getLog().debug((Object)("Deployed application removed from directory " + this.dir + ": " + file));
                        scanner.scan();
                        if (!scanner.deployed) {
                            this.deployed.remove(deployedIndex);
                            break;
                        }
                        ++deployedIndex;
                    }
                }
            }
        }
    }

    private class Scanner {
        protected URL url;
        private URL watchUrl;
        private long lastModified;
        private boolean deployed;

        public Scanner(URL url) {
            this.url = url;
        }

        public void scan() {
            if (URLDirectoryScanner.this.getLog().isTraceEnabled()) {
                URLDirectoryScanner.this.getLog().trace((Object)("Scanning url: " + this.url));
            }
            if (this.lastModified != this.getLastModified()) {
                if (this.exists()) {
                    try {
                        URLDirectoryScanner.this.getLog().debug((Object)("Deploying Modified (or new) url: " + this.url));
                        this.deploy();
                    }
                    catch (DeploymentException e) {
                        URLDirectoryScanner.this.getLog().error((Object)("Failed to (re)deploy url: " + this.url), (Throwable)((Object)e));
                    }
                } else {
                    try {
                        URLDirectoryScanner.this.getLog().debug((Object)("Undeploying url: " + this.url));
                        this.undeploy();
                    }
                    catch (DeploymentException e) {
                        URLDirectoryScanner.this.getLog().error((Object)("Failed to undeploy url: " + this.url), (Throwable)((Object)e));
                    }
                }
            }
        }

        private boolean exists() {
            try {
                if (this.url.getProtocol().equals("file")) {
                    File file = new File(this.url.getPath());
                    return file.exists();
                }
                this.url.openStream().close();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }

        private long getLastModified() {
            try {
                URL lmUrl = this.watchUrl == null ? this.url : this.watchUrl;
                return lmUrl.openConnection().getLastModified();
            }
            catch (IOException e) {
                return 0L;
            }
        }

        private void deploy() throws DeploymentException {
            if (this.deployed) {
                URLDirectoryScanner.this.getDeployerObj().undeploy(this.url);
            }
            URLDirectoryScanner.this.getDeployerObj().deploy(this.url);
            try {
                Object o = URLDirectoryScanner.this.getServer().invoke(URLDirectoryScanner.this.getDeployer(), "getWatchUrl", new Object[]{this.url}, new String[]{(class$java$net$URL == null ? (class$java$net$URL = URLDirectoryScanner.class$("java.net.URL")) : class$java$net$URL).getName()});
                this.watchUrl = o == null ? this.url : (URL)o;
                URLDirectoryScanner.this.getLog().debug((Object)("Watch URL for: " + this.url + " -> " + this.watchUrl));
            }
            catch (Exception e) {
                this.watchUrl = this.url;
                URLDirectoryScanner.this.getLog().debug((Object)("Unable to obtain watchUrl from deployer.  Use url: " + this.url), (Throwable)e);
            }
            this.lastModified = this.getLastModified();
            this.deployed = true;
        }

        private void undeploy() throws DeploymentException {
            if (!this.deployed) {
                return;
            }
            URLDirectoryScanner.this.getDeployerObj().undeploy(this.url);
            this.deployed = false;
            this.lastModified = 0L;
            this.watchUrl = null;
        }
    }
}

