/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms.inflow;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.inflow.DLQHandler;
import org.jboss.resource.adapter.jms.inflow.JmsActivation;
import org.jboss.resource.adapter.jms.inflow.JmsActivationSpec;
import org.jboss.resource.adapter.jms.inflow.JmsServerSessionPool;

public class JmsServerSession
implements ServerSession,
MessageListener,
Work,
WorkListener {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$resource$adapter$jms$inflow$JmsServerSession == null ? (class$org$jboss$resource$adapter$jms$inflow$JmsServerSession = JmsServerSession.class$("org.jboss.resource.adapter.jms.inflow.JmsServerSession")) : class$org$jboss$resource$adapter$jms$inflow$JmsServerSession));
    JmsServerSessionPool pool;
    boolean transacted;
    int acknowledge;
    Session session;
    XASession xaSession;
    MessageEndpoint endpoint;
    DLQHandler dlqHandler;
    static /* synthetic */ Class class$org$jboss$resource$adapter$jms$inflow$JmsServerSession;

    public JmsServerSession(JmsServerSessionPool pool) {
        this.pool = pool;
    }

    public void setup() throws Exception {
        JmsActivation activation = this.pool.getActivation();
        JmsActivationSpec spec = activation.getActivationSpec();
        this.dlqHandler = activation.getDLQHandler();
        Connection connection = activation.getConnection();
        if (connection instanceof XAConnection) {
            this.xaSession = ((XAConnection)connection).createXASession();
            this.session = this.xaSession.getSession();
        } else {
            this.transacted = spec.isSessionTransacted();
            this.acknowledge = spec.getAcknowledgeModeInt();
            this.session = connection.createSession(this.transacted, this.acknowledge);
        }
        MessageEndpointFactory endpointFactory = activation.getMessageEndpointFactory();
        XAResource xaResource = null;
        if (activation.isDeliveryTransacted() && this.xaSession != null) {
            xaResource = this.xaSession.getXAResource();
        }
        this.endpoint = endpointFactory.createEndpoint(xaResource);
        this.session.setMessageListener((MessageListener)this);
    }

    public void teardown() {
        try {
            if (this.endpoint != null) {
                this.endpoint.release();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error releasing endpoint " + this.endpoint), t);
        }
        try {
            if (this.xaSession != null) {
                this.xaSession.close();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error releasing xaSession " + this.xaSession), t);
        }
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error releasing session " + this.session), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            this.endpoint.beforeDelivery(JmsActivation.ONMESSAGE);
            try {
                if (this.dlqHandler == null || !this.dlqHandler.handleRedeliveredMessage(message)) {
                    ((MessageListener)this.endpoint).onMessage(message);
                }
            }
            finally {
                this.endpoint.afterDelivery();
                if (this.dlqHandler != null) {
                    this.dlqHandler.messageDelivered(message);
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)("Unexpected error delivering message " + message), t);
        }
    }

    public Session getSession() throws JMSException {
        return this.session;
    }

    public void start() throws JMSException {
        JmsActivation activation = this.pool.getActivation();
        WorkManager workManager = activation.getWorkManager();
        try {
            workManager.scheduleWork((Work)this, 0L, null, (WorkListener)this);
        }
        catch (WorkException e) {
            log.error((Object)"Unable to schedule work", (Throwable)e);
            throw new JMSException("Unable to schedule work: " + e.toString());
        }
    }

    public void run() {
        this.session.run();
    }

    public void release() {
    }

    public void workAccepted(WorkEvent e) {
    }

    public void workCompleted(WorkEvent e) {
        this.pool.returnServerSession(this);
    }

    public void workRejected(WorkEvent e) {
        this.pool.returnServerSession(this);
    }

    public void workStarted(WorkEvent e) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

