/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms.inflow;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.lang.reflect.Method;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Context;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.resource.adapter.jms.JmsResourceAdapter;
import org.jboss.resource.adapter.jms.inflow.DLQHandler;
import org.jboss.resource.adapter.jms.inflow.JmsActivationSpec;
import org.jboss.resource.adapter.jms.inflow.JmsServerSessionPool;
import org.jboss.util.Strings;

public class JmsActivation
implements ExceptionListener {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$resource$adapter$jms$inflow$JmsActivation == null ? (class$org$jboss$resource$adapter$jms$inflow$JmsActivation = JmsActivation.class$("org.jboss.resource.adapter.jms.inflow.JmsActivation")) : class$org$jboss$resource$adapter$jms$inflow$JmsActivation));
    public static final Method ONMESSAGE;
    protected JmsResourceAdapter ra;
    protected JmsActivationSpec spec;
    protected MessageEndpointFactory endpointFactory;
    protected SynchronizedBoolean deliveryActive;
    protected JMSProviderAdapter adapter;
    protected Destination destination;
    protected Connection connection;
    protected JmsServerSessionPool pool;
    protected boolean isDeliveryTransacted;
    protected DLQHandler dlqHandler;
    static /* synthetic */ Class class$org$jboss$resource$adapter$jms$inflow$JmsActivation;
    static /* synthetic */ Class class$javax$jms$Message;
    static /* synthetic */ Class class$javax$jms$MessageListener;
    static /* synthetic */ Class class$org$jboss$jms$jndi$JMSProviderAdapter;
    static /* synthetic */ Class class$javax$jms$Topic;
    static /* synthetic */ Class class$javax$jms$Queue;
    static /* synthetic */ Class class$javax$jms$QueueConnectionFactory;
    static /* synthetic */ Class class$javax$jms$TopicConnectionFactory;

    public JmsActivation(JmsResourceAdapter ra, MessageEndpointFactory endpointFactory, JmsActivationSpec spec) throws ResourceException {
        this.ra = ra;
        this.endpointFactory = endpointFactory;
        this.spec = spec;
        try {
            this.isDeliveryTransacted = endpointFactory.isDeliveryTransacted(ONMESSAGE);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public JmsActivationSpec getActivationSpec() {
        return this.spec;
    }

    public MessageEndpointFactory getMessageEndpointFactory() {
        return this.endpointFactory;
    }

    public boolean isDeliveryTransacted() {
        return this.isDeliveryTransacted;
    }

    public WorkManager getWorkManager() {
        return this.ra.getWorkManager();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public JMSProviderAdapter getProviderAdapter() {
        return this.adapter;
    }

    public DLQHandler getDLQHandler() {
        return this.dlqHandler;
    }

    public void start() throws ResourceException {
        this.deliveryActive = new SynchronizedBoolean(true);
        this.ra.getWorkManager().scheduleWork((Work)new SetupActivation());
    }

    public void stop() {
        this.deliveryActive.set(false);
        this.teardown();
    }

    public void handleFailure(Throwable failure) {
        log.warn((Object)("Failure in jms activation " + this.spec), failure);
        while (this.deliveryActive.get()) {
            this.teardown();
            try {
                Thread.sleep(this.spec.getReconnectIntervalLong());
            }
            catch (InterruptedException e) {
                log.debug((Object)("Interrupted trying to reconnect " + this.spec), (Throwable)e);
                break;
            }
            log.info((Object)("Attempting to reconnect " + this.spec));
            try {
                this.setup();
            }
            catch (Throwable t) {
                log.error((Object)("Unable to reconnect " + this.spec), t);
            }
        }
    }

    public void onException(JMSException exception) {
        this.handleFailure(exception);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Strings.defaultToString((Object)this)).append('(');
        buffer.append("spec=").append(Strings.defaultToString((Object)this.spec));
        buffer.append(" mepf=").append(Strings.defaultToString((Object)this.endpointFactory));
        buffer.append(" active=").append(this.deliveryActive.get());
        if (this.destination != null) {
            buffer.append(" destination=").append(this.destination);
        }
        if (this.connection != null) {
            buffer.append(" connection=").append(this.connection);
        }
        if (this.pool != null) {
            buffer.append(" pool=").append(Strings.defaultToString((Object)this.pool));
        }
        if (this.dlqHandler != null) {
            buffer.append(" dlq=").append(Strings.defaultToString((Object)this.dlqHandler));
        }
        buffer.append(" transacted=").append(this.isDeliveryTransacted);
        buffer.append(')');
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setup() throws Exception {
        log.debug((Object)("Setting up " + this.spec));
        this.setupJMSProviderAdapter();
        Context ctx = this.adapter.getInitialContext();
        log.debug((Object)("Using context " + ctx.getEnvironment() + " for " + this.spec));
        try {
            this.setupDLQ(ctx);
            this.setupDestination(ctx);
            this.setupConnection(ctx);
        }
        finally {
            ctx.close();
        }
        this.setupSessionPool();
        log.debug((Object)("Setup complete " + this));
    }

    protected void teardown() {
        log.debug((Object)("Tearing down " + this.spec));
        this.teardownSessionPool();
        this.teardownConnection();
        this.teardownDestination();
        this.teardownDLQ();
        log.debug((Object)("Tearing down complete " + this));
    }

    protected void setupJMSProviderAdapter() throws Exception {
        String providerAdapterJNDI = this.spec.getProviderAdapterJNDI();
        if (!providerAdapterJNDI.startsWith("java:")) {
            providerAdapterJNDI = "java:" + providerAdapterJNDI;
        }
        log.debug((Object)("Retrieving the jms provider adapter " + providerAdapterJNDI + " for " + this));
        this.adapter = (JMSProviderAdapter)Util.lookup((String)providerAdapterJNDI, (Class)(class$org$jboss$jms$jndi$JMSProviderAdapter == null ? (class$org$jboss$jms$jndi$JMSProviderAdapter = JmsActivation.class$("org.jboss.jms.jndi.JMSProviderAdapter")) : class$org$jboss$jms$jndi$JMSProviderAdapter));
        log.debug((Object)("Using jms provider adapter " + this.adapter + " for " + this));
    }

    protected void setupDLQ(Context ctx) throws Exception {
        if (this.spec.isUseDLQ()) {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.spec.getDLQHandler());
            this.dlqHandler = (DLQHandler)clazz.newInstance();
            this.dlqHandler.setup(this, ctx);
        }
        log.debug((Object)("Setup DLQ " + this));
    }

    protected void teardownDLQ() {
        log.debug((Object)("Removing DLQ " + this));
        try {
            if (this.dlqHandler != null) {
                this.dlqHandler.teardown();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error tearing down the DLQ " + this.dlqHandler), t);
        }
        this.dlqHandler = null;
    }

    protected void setupDestination(Context ctx) throws Exception {
        Class destinationType = this.spec.isTopic() ? (class$javax$jms$Topic == null ? (class$javax$jms$Topic = JmsActivation.class$("javax.jms.Topic")) : class$javax$jms$Topic) : (class$javax$jms$Queue == null ? (class$javax$jms$Queue = JmsActivation.class$("javax.jms.Queue")) : class$javax$jms$Queue);
        String destinationName = this.spec.getDestination();
        log.debug((Object)("Retrieving destination " + destinationName + " of type " + destinationType.getName()));
        this.destination = (Destination)Util.lookup((Context)ctx, (String)destinationName, (Class)destinationType);
        log.debug((Object)("Got destination " + this.destination + " from " + destinationName));
    }

    protected void teardownDestination() {
    }

    protected void setupConnection(Context ctx) throws Exception {
        log.debug((Object)("setup connection " + this));
        String user = this.spec.getUser();
        String pass = this.spec.getPassword();
        String clientID = this.spec.getClientId();
        this.connection = this.spec.isTopic() ? this.setupTopicConnection(ctx, user, pass, clientID) : this.setupQueueConnection(ctx, user, pass, clientID);
        log.debug((Object)("established connection " + this));
    }

    protected QueueConnection setupQueueConnection(Context ctx, String user, String pass, String clientID) throws Exception {
        QueueConnection result;
        String queueFactoryRef = this.adapter.getQueueFactoryRef();
        log.debug((Object)("Attempting to lookup queue connection factory " + queueFactoryRef));
        QueueConnectionFactory qcf = (QueueConnectionFactory)Util.lookup((Context)ctx, (String)queueFactoryRef, (Class)(class$javax$jms$QueueConnectionFactory == null ? (class$javax$jms$QueueConnectionFactory = JmsActivation.class$("javax.jms.QueueConnectionFactory")) : class$javax$jms$QueueConnectionFactory));
        log.debug((Object)("Got queue connection factory " + qcf + " from " + queueFactoryRef));
        log.debug((Object)("Attempting to create queue connection with user " + user));
        if (qcf instanceof XAQueueConnectionFactory && this.isDeliveryTransacted) {
            XAQueueConnectionFactory xaqcf = (XAQueueConnectionFactory)qcf;
            result = user != null ? xaqcf.createXAQueueConnection(user, pass) : xaqcf.createXAQueueConnection();
        } else {
            result = user != null ? qcf.createQueueConnection(user, pass) : qcf.createQueueConnection();
        }
        if (clientID != null) {
            result.setClientID(clientID);
        }
        result.setExceptionListener((ExceptionListener)this);
        log.debug((Object)("Using queue connection " + result));
        return result;
    }

    protected TopicConnection setupTopicConnection(Context ctx, String user, String pass, String clientID) throws Exception {
        TopicConnection result;
        String topicFactoryRef = this.adapter.getTopicFactoryRef();
        log.debug((Object)("Attempting to lookup topic connection factory " + topicFactoryRef));
        TopicConnectionFactory tcf = (TopicConnectionFactory)Util.lookup((Context)ctx, (String)topicFactoryRef, (Class)(class$javax$jms$TopicConnectionFactory == null ? (class$javax$jms$TopicConnectionFactory = JmsActivation.class$("javax.jms.TopicConnectionFactory")) : class$javax$jms$TopicConnectionFactory));
        log.debug((Object)("Got topic connection factory " + tcf + " from " + topicFactoryRef));
        log.debug((Object)("Attempting to create topic connection with user " + user));
        if (tcf instanceof XATopicConnectionFactory && this.isDeliveryTransacted) {
            XATopicConnectionFactory xatcf = (XATopicConnectionFactory)tcf;
            result = user != null ? xatcf.createXATopicConnection(user, pass) : xatcf.createXATopicConnection();
        } else {
            result = user != null ? tcf.createTopicConnection(user, pass) : tcf.createTopicConnection();
        }
        if (clientID != null) {
            result.setClientID(clientID);
        }
        result.setExceptionListener((ExceptionListener)this);
        log.debug((Object)("Using topic connection " + result));
        return result;
    }

    protected void teardownConnection() {
        try {
            if (this.connection != null) {
                log.debug((Object)("Closing the " + this.connection));
                this.connection.close();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error closing the connection " + this.connection), t);
        }
        this.connection = null;
    }

    protected void setupSessionPool() throws Exception {
        this.pool = new JmsServerSessionPool(this);
        log.debug((Object)("Created session pool " + this.pool));
        log.debug((Object)("Starting session pool " + this.pool));
        this.pool.start();
        log.debug((Object)("Started session pool " + this.pool));
        log.debug((Object)("Starting delivery " + this.connection));
        this.connection.start();
        log.debug((Object)("Started delivery " + this.connection));
    }

    protected void teardownSessionPool() {
        try {
            if (this.connection != null) {
                log.debug((Object)("Stopping delivery " + this.connection));
                this.connection.stop();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error stopping delivery " + this.connection), t);
        }
        try {
            if (this.pool != null) {
                log.debug((Object)("Stopping the session pool " + this.pool));
                this.pool.stop();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error clearing the pool " + this.pool), t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            ONMESSAGE = (class$javax$jms$MessageListener == null ? (class$javax$jms$MessageListener = JmsActivation.class$("javax.jms.MessageListener")) : class$javax$jms$MessageListener).getMethod("onMessage", class$javax$jms$Message == null ? (class$javax$jms$Message = JmsActivation.class$("javax.jms.Message")) : class$javax$jms$Message);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class SetupActivation
    implements Work {
        private SetupActivation() {
        }

        public void run() {
            try {
                JmsActivation.this.setup();
            }
            catch (Throwable t) {
                JmsActivation.this.handleFailure(t);
            }
        }

        public void release() {
        }
    }
}

