/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import javax.resource.spi.ConnectionRequestInfo;
import org.jboss.resource.adapter.jms.JmsMCFProperties;
import org.jboss.util.Strings;

public class JmsConnectionRequestInfo
implements ConnectionRequestInfo {
    private String userName;
    private String password;
    private String clientID;
    private boolean transacted = true;
    private int acknowledgeMode = 1;
    private int type = 0;

    public JmsConnectionRequestInfo(JmsMCFProperties prop) {
        this.userName = prop.getUserName();
        this.password = prop.getPassword();
        this.clientID = prop.getClientID();
        this.type = prop.getType();
    }

    public JmsConnectionRequestInfo(boolean transacted, int acknowledgeMode, int type) {
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.type = type;
    }

    public void setDefaults(JmsMCFProperties prop) {
        if (this.userName == null) {
            this.userName = prop.getUserName();
        }
        if (this.password == null) {
            this.password = prop.getPassword();
        }
        if (this.clientID == null) {
            this.clientID = prop.getClientID();
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public int getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof JmsConnectionRequestInfo) {
            JmsConnectionRequestInfo you = (JmsConnectionRequestInfo)obj;
            return this.transacted == you.isTransacted() && this.acknowledgeMode == you.getAcknowledgeMode() && this.type == you.getType() && Strings.compare((String)this.userName, (String)you.getUserName()) && Strings.compare((String)this.password, (String)you.getPassword()) && Strings.compare((String)this.clientID, (String)you.getClientID());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.transacted) {
            ++hashCode;
        }
        if (this.type == 1) {
            hashCode += 3;
        } else if (this.type == 2) {
            hashCode += 5;
        }
        if (this.acknowledgeMode == 1) {
            hashCode += 7;
        } else if (this.acknowledgeMode == 3) {
            hashCode += 11;
        }
        if (this.userName != null) {
            hashCode += this.userName.hashCode();
        }
        if (this.password != null) {
            hashCode += this.password.hashCode();
        }
        if (this.clientID != null) {
            hashCode += this.clientID.hashCode();
        }
        return hashCode;
    }
}

