/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util.threadpool;

import java.util.LinkedList;
import org.jacorb.util.threadpool.ConsumerFactory;
import org.jacorb.util.threadpool.ConsumerTie;

public class ThreadPool {
    private int max_threads = 0;
    private int max_idle_threads = 0;
    private int total_threads = 0;
    private int idle_threads = 0;
    private LinkedList job_queue = null;
    private ConsumerFactory factory = null;

    public ThreadPool(ConsumerFactory factory) {
        this(new LinkedList(), factory, 10, 10);
    }

    public ThreadPool(ConsumerFactory factory, int max_threads, int max_idle_threads) {
        this(new LinkedList(), factory, max_threads, max_idle_threads);
    }

    private ThreadPool(LinkedList job_queue, ConsumerFactory factory, int max_threads, int max_idle_threads) {
        this.job_queue = job_queue;
        this.factory = factory;
        this.max_threads = max_threads;
        this.max_idle_threads = max_idle_threads;
    }

    protected synchronized Object getJob() {
        if (this.idle_threads >= this.max_idle_threads) {
            --this.total_threads;
            return null;
        }
        ++this.idle_threads;
        while (this.job_queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.job_queue.removeFirst();
    }

    public synchronized void putJob(Object job) {
        this.job_queue.add(job);
        this.notifyAll();
        if (this.idle_threads <= 0) {
            if (this.total_threads < this.max_threads) {
                this.createNewThread();
                --this.idle_threads;
            }
        } else {
            --this.idle_threads;
        }
    }

    private void createNewThread() {
        Thread t = new Thread(new ConsumerTie(this, this.factory.create()));
        t.setDaemon(true);
        t.start();
        ++this.total_threads;
    }
}

