/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;

public class DoubleValue
implements Value {
    private Double m_value;

    public DoubleValue() {
        this(0.0);
    }

    public DoubleValue(double value) {
        this.m_value = new Double(value);
    }

    public DoubleValue(Object value) {
        this.m_value = (Double)value;
    }

    public void setValue(Object value) {
        this.m_value = (Double)value;
    }

    public int getTypeId() {
        return 6;
    }

    public Object getValue() {
        return this.m_value;
    }

    public boolean equals(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 6) {
            throw new IllegalArgumentException();
        }
        result = this.m_value.equals(nv.getValue());
        return result;
    }

    public boolean lessThan(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 6) {
            throw new IllegalArgumentException();
        }
        Double d = (Double)nv.getValue();
        result = this.m_value < d;
        return result;
    }

    public boolean lessThanEqual(Value nv) {
        return this.lessThan(nv) || this.equals(nv);
    }

    public boolean greaterThan(Value nv) {
        return !this.lessThan(nv) && !this.equals(nv);
    }

    public boolean greaterThanEqual(Value nv) {
        return !this.lessThan(nv);
    }

    public Value plus(Value nv) {
        DoubleValue result = null;
        if (nv.getTypeId() != 6) {
            throw new IllegalArgumentException();
        }
        Double d = (Double)nv.getValue();
        result = new DoubleValue(this.m_value + d);
        return result;
    }

    public Value minus(Value nv) {
        DoubleValue result = null;
        if (nv.getTypeId() != 6) {
            throw new IllegalArgumentException();
        }
        Double d = (Double)nv.getValue();
        result = new DoubleValue(this.m_value - d);
        return result;
    }

    public Value multiply(Value nv) {
        DoubleValue result = null;
        if (nv.getTypeId() != 6) {
            throw new IllegalArgumentException();
        }
        Double d = (Double)nv.getValue();
        result = new DoubleValue(this.m_value * d);
        return result;
    }

    public Value divide(Value nv) {
        DoubleValue result = null;
        if (nv.getTypeId() != 6) {
            throw new IllegalArgumentException();
        }
        Double d = (Double)nv.getValue();
        result = new DoubleValue(this.m_value / d);
        return result;
    }

    public Value negate() {
        DoubleValue result = null;
        result = new DoubleValue(-1.0 * this.m_value);
        return result;
    }

    public Value convert(int typeId) {
        DoubleValue result = null;
        switch (typeId) {
            case 6: {
                result = new DoubleValue(this.m_value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result;
    }

    public String toString() {
        return this.m_value.toString();
    }
}

