/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import java.io.StringReader;
import org.jacorb.trading.constraint.Expression;
import org.jacorb.trading.constraint.Lex;
import org.jacorb.trading.constraint.ParseException;
import org.jacorb.trading.constraint.PropertySchema;
import org.jacorb.trading.constraint.PropertySource;
import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueType;

public class Constraint {
    private PropertySchema m_schema;
    private Expression m_expr;
    private String m_constraint;

    private Constraint() {
    }

    public Constraint(PropertySchema schema) {
        this.m_schema = schema;
    }

    public void parse(String constraint) throws ParseException {
        if (constraint.length() == 0) {
            constraint = "TRUE";
        }
        StringReader reader = new StringReader(constraint);
        Lex lex = new Lex(reader);
        this.m_constraint = constraint;
        this.m_expr = new Expression(this.m_schema);
        ValueType type = this.m_expr.parse(lex);
        if (!ValueType.isCompatible(type.getId(), 0) || type.isSequence()) {
            throw new ParseException("constraint expression must be boolean");
        }
    }

    public String getConstraint() {
        return this.m_constraint;
    }

    public boolean evaluate(PropertySource source) {
        boolean result = false;
        Value nv = this.m_expr.evaluate(source);
        if (nv != null) {
            Boolean b = (Boolean)nv.getValue();
            result = b;
        }
        return result;
    }
}

