/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.HashMap;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.security.level2.CurrentImpl;
import org.jacorb.security.level2.KeyAndCert;
import org.jacorb.security.level2.ReceivedCredentialsImpl;
import org.jacorb.security.level2.SecAttributeManager;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.omg.Security.AttributeType;
import org.omg.Security.ExtensibleFamily;
import org.omg.Security.SecAttribute;
import org.omg.SecurityLevel2.Current;
import org.omg.SecurityLevel2.ReceivedCredentials;

public class ServerInvocationInterceptor
extends LocalObject
implements ServerRequestInterceptor,
Configurable {
    public static final String DEFAULT_NAME = "ServerInvocationInterceptor";
    private String name = null;
    private CurrentImpl current = null;
    private SecAttributeManager attrib_mgr = null;
    private AttributeType type = null;
    private HashMap sessionCredentials = new HashMap();
    private Logger logger;
    private short serverSupportedOptions = 0;
    private short serverRequiredOptions = 0;

    public ServerInvocationInterceptor(Current current, ORB orb) throws ConfigurationException {
        this.current = (CurrentImpl)current;
        this.name = DEFAULT_NAME;
        this.attrib_mgr = SecAttributeManager.getInstance();
        this.type = new AttributeType(new ExtensibleFamily(0, 1), 2);
        this.configure((Configuration)orb.getConfiguration());
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.security.ssl.interceptor");
        this.serverSupportedOptions = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
        this.serverRequiredOptions = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
    }

    public String name() {
        return this.name;
    }

    public void destroy() {
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        CertificateFactory certificateFactory;
        SSLSocket sslSocket;
        block14: {
            ServerRequest request = ((ServerRequestInfoImpl)ri).request;
            GIOPConnection connection = request.getConnection();
            if (connection == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("target has no connection!");
                }
                return;
            }
            if (!connection.isSSL()) {
                return;
            }
            ServerIIOPConnection transport = (ServerIIOPConnection)connection.getTransport();
            sslSocket = (SSLSocket)transport.getSocket();
            SSLSession session = sslSocket.getSession();
            if (this.sessionCredentials.containsKey(session)) {
                ReceivedCredentialsImpl sessionRcvCredentials = (ReceivedCredentialsImpl)this.sessionCredentials.get(session);
                this.current.set_received_credentials(sessionRcvCredentials);
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("Reusing SSL session credentials.");
                }
                return;
            }
            certificateFactory = null;
            try {
                certificateFactory = CertificateFactory.getInstance("X.509");
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block14;
                this.logger.warn(e.getMessage());
            }
        }
        KeyAndCert kac = null;
        try {
            X509Certificate[] certs = sslSocket.getSession().getPeerCertificateChain();
            int size = certs.length;
            Certificate[] newCerts = new java.security.cert.X509Certificate[size];
            for (int i = size - 1; 0 <= i; --i) {
                newCerts[i] = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certs[i].getEncoded()));
            }
            kac = new KeyAndCert(null, newCerts);
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception " + e.getMessage() + " in ServerInvocationInterceptor");
            }
            if ((this.serverRequiredOptions & 0x40) != 0) {
                throw new NO_PERMISSION("Establish trust in client required, but failed");
            }
            return;
        }
        if (kac.chain == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Client sent no certificate chain!");
            }
            return;
        }
        SecAttribute[] atts = new SecAttribute[]{this.attrib_mgr.createAttribute(kac, this.type)};
        this.current.set_received_credentials(new ReceivedCredentialsImpl(atts));
    }

    public void send_reply(ServerRequestInfo ri) {
        this.removeAttribute();
        this.current.remove_received_credentials();
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        this.removeAttribute();
        this.current.remove_received_credentials();
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        this.removeAttribute();
        this.current.remove_received_credentials();
    }

    private void removeAttribute() {
        ReceivedCredentials creds = this.current.received_credentials();
        if (creds == null) {
            return;
        }
        SecAttribute[] attributes = creds.get_attributes(new AttributeType[]{this.type});
        if (attributes.length != 0) {
            this.attrib_mgr.removeAttribute(attributes[0]);
        }
    }
}

