/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.level2;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.security.level2.AccessDecisionImpl;
import org.jacorb.security.level2.CredentialsImpl;
import org.jacorb.security.level2.InvocationCredentialsPolicyImpl;
import org.jacorb.security.level2.KeyAndCert;
import org.jacorb.security.level2.MechanismPolicyImpl;
import org.jacorb.security.level2.QOPPolicyImpl;
import org.jacorb.security.level2.SecAttributeManager;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.Security.AttributeType;
import org.omg.Security.AuthenticationStatus;
import org.omg.Security.CredentialType;
import org.omg.Security.ExtensibleFamily;
import org.omg.Security.MechandOptions;
import org.omg.Security.QOP;
import org.omg.Security.SecAttribute;
import org.omg.Security.SecurityFeature;
import org.omg.Security.SecurityMechanismData;
import org.omg.SecurityLevel2.AccessDecision;
import org.omg.SecurityLevel2.AuditDecision;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.CredentialsHolder;
import org.omg.SecurityLevel2.Current;
import org.omg.SecurityLevel2.DelegationMode;
import org.omg.SecurityLevel2.InvocationCredentialsPolicy;
import org.omg.SecurityLevel2.MechanismPolicy;
import org.omg.SecurityLevel2.PrincipalAuthenticator;
import org.omg.SecurityLevel2.QOPPolicy;
import org.omg.SecurityLevel2.ReceivedCredentials;
import org.omg.SecurityLevel2.RequiredRights;

public class CurrentImpl
extends LocalObject
implements Current,
Configurable {
    private CredentialsImpl[] own_credentials;
    private PrincipalAuthenticator principalAuthenticator;
    private AccessDecision access_decision = null;
    private Hashtable policies = null;
    private SecAttributeManager attrib_mgr = null;
    private Hashtable ts_credentials = null;
    private Hashtable ts_received_credentials = null;
    private String defaultSecurityName = null;
    private String defaultPassword = null;
    private List authenticators = new Vector();
    private ORB orb = null;
    private Logger logger;
    private org.jacorb.config.Configuration configuration;
    static /* synthetic */ Class class$org$omg$CORBA$ORB;

    public CurrentImpl(ORB orb) {
        this.orb = orb;
        this.attrib_mgr = SecAttributeManager.getInstance();
        this.ts_credentials = new Hashtable();
        this.ts_received_credentials = new Hashtable();
        this.policies = new Hashtable();
    }

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        String s;
        this.configuration = (org.jacorb.config.Configuration)myConfiguration;
        this.logger = this.configuration.getNamedLogger("jacorb.security.current");
        this.defaultSecurityName = this.configuration.getAttribute("jacorb.security.default_user", "");
        this.defaultPassword = this.configuration.getAttribute("jacorb.security.default_password", "");
        String accDecClassName = this.configuration.getAttribute("jacorb.security.access_decision", null);
        if (accDecClassName != null) {
            try {
                Class ad_class = ObjectUtil.classForName(accDecClassName);
                this.access_decision = (AccessDecision)ad_class.newInstance();
            }
            catch (Exception e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Class " + accDecClassName + " not found! Please check property \"jacorb.security.access_decision\"");
                }
                this.access_decision = new AccessDecisionImpl();
            }
        } else {
            this.access_decision = new AccessDecisionImpl();
        }
        if ((s = this.configuration.getAttribute("jacorb.security.principal_authenticator", null)) != null) {
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                PrincipalAuthenticator pa = this.createAuthenticator(st.nextToken());
                if (pa == null) continue;
                this.authenticators.add(pa);
            }
        }
    }

    public void init() {
        this.authenticate();
    }

    public Logger getLogger() {
        return this.logger;
    }

    private PrincipalAuthenticator createAuthenticator(String class_name) {
        block10: {
            try {
                Class pa_class = ObjectUtil.classForName(class_name);
                Constructor<?>[] constructors = pa_class.getConstructors();
                if (constructors.length != 1) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("PrincAuth " + class_name + " must have exactly one constructor that takes either no args or org.omg.CORBA.ORB");
                    }
                    return null;
                }
                Class<?>[] params = constructors[0].getParameterTypes();
                if (params.length == 0) {
                    PrincipalAuthenticator pa = (PrincipalAuthenticator)pa_class.newInstance();
                    ((Configurable)pa).configure((Configuration)this.configuration);
                    return pa;
                }
                if (params.length == 1) {
                    if (params[0].equals(class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = CurrentImpl.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB)) {
                        return (PrincipalAuthenticator)constructors[0].newInstance(this.orb);
                    }
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("PrincAuth " + class_name + "'s constructor has an arg of type " + params[0].getName() + " but it must have an arg of type org.omg.CORBA.ORB");
                    }
                } else if (this.logger.isErrorEnabled()) {
                    this.logger.error("PrincAuth " + class_name + " must have exactly one constructor that takes either no arg or one arg of type org.omg.CORBA.ORB");
                }
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block10;
                this.logger.warn("Exception " + e.getMessage() + " in CurrentImpl");
            }
        }
        return null;
    }

    private void authenticate() {
        if (this.authenticators.size() == 0) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("No PrincipalAuthenticator set. Will not authenticate!");
            }
            this.own_credentials = new CredentialsImpl[0];
            return;
        }
        this.principalAuthenticator = (PrincipalAuthenticator)this.authenticators.get(0);
        byte[] pwd = this.defaultPassword == null ? null : this.defaultPassword.getBytes();
        Vector<CredentialsImpl> own_creds = new Vector<CredentialsImpl>();
        for (int i = 0; i < this.authenticators.size(); ++i) {
            CredentialsHolder coh;
            PrincipalAuthenticator pa = (PrincipalAuthenticator)this.authenticators.get(i);
            if (pa.authenticate(0, null, this.defaultSecurityName, pwd, null, coh = new CredentialsHolder(), null, null) == AuthenticationStatus.SecAuthSuccess) {
                own_creds.add((CredentialsImpl)coh.value);
                this.own_credentials = new CredentialsImpl[own_creds.size()];
                own_creds.copyInto(this.own_credentials);
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info("PrincAuth " + i + ": AuthenticationStatus.SecAuthSuccess");
                continue;
            }
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("PrincAuth " + i + ": AuthenticationStatus.SecAuthFailure");
        }
    }

    public SecAttribute[] get_attributes(AttributeType[] types) {
        CredentialsImpl[] tsc = this.getTSCredentials();
        if (tsc != null && tsc.length > 0) {
            return tsc[0].get_attributes(types);
        }
        if (this.own_credentials != null && this.own_credentials.length > 0) {
            return this.own_credentials[0].get_attributes(types);
        }
        return new SecAttribute[0];
    }

    public ReceivedCredentials received_credentials() {
        return (ReceivedCredentials)this.ts_received_credentials.get(Thread.currentThread());
    }

    public void set_credentials(CredentialType cred_type, Credentials[] creds, DelegationMode del) {
        this.ts_credentials.put(Thread.currentThread(), creds);
    }

    public void set_received_credentials(ReceivedCredentials creds) {
        this.ts_received_credentials.put(Thread.currentThread(), creds);
    }

    public void remove_received_credentials() {
        this.ts_received_credentials.remove(Thread.currentThread());
    }

    public Credentials[] get_credentials(CredentialType cred_type) {
        CredentialsImpl[] tsc = this.getTSCredentials();
        if (tsc == null) {
            tsc = this.own_credentials;
        }
        Vector<CredentialsImpl> found_creds = new Vector<CredentialsImpl>();
        for (int i = 0; i < tsc.length; ++i) {
            if (cred_type.value() != tsc[i].credentials_type().value()) continue;
            found_creds.addElement(tsc[i]);
        }
        Credentials[] creds = new Credentials[found_creds.size()];
        for (int i = 0; i < creds.length; ++i) {
            creds[i] = (Credentials)found_creds.elementAt(i);
        }
        return creds;
    }

    public Credentials[] own_credentials() {
        return this.own_credentials;
    }

    public void remove_own_credentials(Credentials credentials) {
        int i;
        boolean found_credentials = false;
        Vector<CredentialsImpl> kept_credentials = new Vector<CredentialsImpl>();
        for (i = 0; i < this.own_credentials.length; ++i) {
            if (credentials == this.own_credentials[i]) {
                found_credentials = true;
                continue;
            }
            kept_credentials.addElement(this.own_credentials[i]);
        }
        if (found_credentials) {
            this.own_credentials = new CredentialsImpl[kept_credentials.size()];
            for (i = 0; i < kept_credentials.size(); ++i) {
                this.own_credentials[i] = (CredentialsImpl)kept_credentials.elementAt(i);
            }
        } else {
            throw new BAD_PARAM();
        }
    }

    public SecurityFeature[] received_security_features() {
        return null;
    }

    public Policy get_policy(int policy_type) {
        return (Policy)this.policies.get(new Integer(policy_type));
    }

    public MechandOptions[] supported_mechanisms() {
        return null;
    }

    public SecurityMechanismData[] get_security_mechanisms(Object obj_ref) {
        return null;
    }

    public RequiredRights required_rights_object() {
        return null;
    }

    public PrincipalAuthenticator principal_authenticator() {
        return this.principalAuthenticator;
    }

    public AccessDecision access_decision() {
        return this.access_decision;
    }

    public AuditDecision audit_decision() {
        return null;
    }

    public QOPPolicy create_qop_policy(QOP qop) {
        return new QOPPolicyImpl(qop);
    }

    public MechanismPolicy create_mechanism_policy(String[] mechanisms) {
        return new MechanismPolicyImpl(mechanisms);
    }

    public InvocationCredentialsPolicy create_invoc_creds_policy(Credentials[] creds) {
        return new InvocationCredentialsPolicyImpl(creds);
    }

    private CredentialsImpl[] getTSCredentials() {
        return (CredentialsImpl[])this.ts_credentials.get(Thread.currentThread());
    }

    public KeyAndCert[] getSSLCredentials() {
        if (this.own_credentials == null || this.own_credentials.length == 0) {
            return new KeyAndCert[0];
        }
        AttributeType access_id = new AttributeType(new ExtensibleFamily(0, 1), 2);
        AttributeType role = new AttributeType(new ExtensibleFamily(0, 1), 5);
        SecAttribute[] attribs = this.own_credentials[0].get_attributes(new AttributeType[]{access_id, role});
        KeyAndCert[] certs = new KeyAndCert[attribs.length];
        for (int i = 0; i < certs.length; ++i) {
            certs[i] = this.attrib_mgr.getAttributeCertValue(attribs[i]);
        }
        return certs;
    }

    public void close() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Closing Current");
        }
        this.principalAuthenticator = null;
        this.policies.clear();
        this.ts_credentials.clear();
        this.ts_received_credentials.clear();
    }

    public void finalize() {
        this.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

