/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jacorb.orb.ORB;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.portableInterceptor.IORInfoExt;
import org.jacorb.poa.POA;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Policy;
import org.omg.ETF.Profile;
import org.omg.IOP.TaggedComponent;

public class IORInfoImpl
extends LocalObject
implements IORInfoExt {
    private Map components = null;
    private Map policy_overrides = null;
    private ORB orb = null;
    private POA poa = null;
    private List _profiles = null;

    public IORInfoImpl(ORB orb, POA poa, Map components, Map policy_overrides, List profiles) {
        this.orb = orb;
        this.poa = poa;
        this.components = components;
        this.policy_overrides = policy_overrides;
        this._profiles = profiles;
    }

    public void add_ior_component(TaggedComponent component) {
        Iterator i = this.components.values().iterator();
        while (i.hasNext()) {
            TaggedComponentList l = (TaggedComponentList)i.next();
            l.addComponent(component);
        }
    }

    public void add_ior_component_to_profile(TaggedComponent component, int id) {
        TaggedComponentList l = (TaggedComponentList)this.components.get(new Integer(id));
        if (l == null) {
            throw new BAD_PARAM("unknown profile tag: " + id, 29, CompletionStatus.COMPLETED_MAYBE);
        }
        l.addComponent(component);
    }

    public Policy get_effective_policy(int type) {
        if (!this.orb.hasPolicyFactoryForType(type)) {
            throw new INV_POLICY("No PolicyFactory for type " + type + " has been registered!", 3, CompletionStatus.COMPLETED_MAYBE);
        }
        Policy policy = null;
        if (this.policy_overrides != null) {
            policy = (Policy)this.policy_overrides.get(new Integer(type));
        }
        return policy != null ? policy : this.poa.getPolicy(type);
    }

    public void add_profile(Profile profile) {
        if (this._profiles != null) {
            this._profiles.add(profile);
        }
    }

    public int get_number_of_profiles(int tag) {
        int retVal = 0;
        for (int i = 0; i < this._profiles.size(); ++i) {
            Profile p = (Profile)this._profiles.get(i);
            if (p.tag() != tag) continue;
            ++retVal;
        }
        return retVal;
    }

    public Profile get_profile(int tag, int position) {
        int cnt = position;
        Profile retVal = null;
        for (int i = 0; i < this._profiles.size(); ++i) {
            Profile p = (Profile)this._profiles.get(i);
            if (p.tag() == tag && cnt == 0) {
                retVal = p;
                break;
            }
            --cnt;
        }
        if (retVal == null) {
            throw new ArrayIndexOutOfBoundsException("no profile with tag=" + tag + " at position" + position);
        }
        return retVal;
    }

    public Profile get_profile(int tag) {
        Profile retVal = null;
        for (int i = 0; i < this._profiles.size(); ++i) {
            Profile p = (Profile)this._profiles.get(i);
            if (p.tag() != tag) continue;
            retVal = p;
            break;
        }
        return retVal;
    }
}

