/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.ORB;
import org.jacorb.orb.etf.ListenerBase;
import org.jacorb.orb.factory.SSLServerSocketFactory;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Connection;
import org.omg.SSLIOP.SSL;

public class IIOPListener
extends ListenerBase {
    private static final int MAX_SSL_OPTIONS = 126;
    private static final int MIN_SSL_OPTIONS = 26;
    private SocketFactoryManager socketFactoryManager = null;
    private ServerSocketFactory serverSocketFactory = null;
    private SSLServerSocketFactory sslServerSocketFactory = null;
    private SSLAcceptor sslAcceptor = null;
    private boolean supportSSL = false;
    private boolean dnsEnabled = false;
    private int serverTimeout = 0;
    private int oaPort = 0;
    private int sslPort = 0;
    private int target_supports = 0;
    private int target_requires = 0;
    private boolean generateSSLComponents = true;
    static /* synthetic */ Class class$org$omg$SSLIOP$SSLHelper;

    public IIOPListener() {
    }

    public IIOPListener(ORB orb) {
        super(orb);
        this.socketFactoryManager = new SocketFactoryManager(orb);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        if (this.orb == null) {
            this.orb = this.configuration.getORB();
            this.socketFactoryManager = new SocketFactoryManager(this.orb);
        }
        this.logger = this.configuration.getNamedLogger("jacorb.iiop.listener");
        this.socketFactoryManager.configure(configuration);
        this.oaPort = configuration.getAttributeAsInteger("OAPort", 0);
        this.sslPort = configuration.getAttributeAsInteger("OASSLPort", 0);
        this.dnsEnabled = configuration.getAttribute("jacorb.dns.enable", "off").equals("on");
        this.serverTimeout = configuration.getAttributeAsInteger("jacorb.connection.server.timeout", 0);
        this.supportSSL = configuration.getAttribute("jacorb.security.support_ssl", "off").equals("on");
        this.target_supports = Integer.parseInt(configuration.getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
        this.target_supports |= 0x1A;
        this.target_requires = Integer.parseInt(configuration.getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
        this.generateSSLComponents = configuration.getAttribute("jacorb.security.ssl_components_added_by_ior_interceptor", "off").equals("off");
        if (!this.isSSLRequired() || configuration.getAttributeAsBoolean("jacorb.security.ssl.always_open_unsecured_endpoint", false)) {
            this.acceptor = new Acceptor();
            ((Acceptor)this.acceptor).init();
        }
        if (this.supportSSL) {
            this.sslAcceptor = new SSLAcceptor();
            this.sslAcceptor.init();
        }
        this.endpoint = this.createEndPointProfile();
    }

    public void listen() {
        super.listen();
        if (this.sslAcceptor != null) {
            this.sslAcceptor.start();
        }
    }

    public void destroy() {
        if (this.sslAcceptor != null) {
            this.sslAcceptor.terminate();
        }
        super.destroy();
    }

    private boolean isSSLSupported() {
        return this.supportSSL;
    }

    private boolean isSSLRequired() throws ConfigurationException {
        if (this.isSSLSupported()) {
            return (this.target_requires & 0x7E) != 0;
        }
        return false;
    }

    private int getServerTimeout() {
        return this.serverTimeout;
    }

    private ServerSocketFactory getServerSocketFactory() {
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = this.socketFactoryManager.getServerSocketFactory();
        }
        return this.serverSocketFactory;
    }

    private SSLServerSocketFactory getSSLServerSocketFactory() {
        if (this.sslServerSocketFactory == null) {
            this.sslServerSocketFactory = this.orb.getBasicAdapter().getSSLSocketFactory();
            if (this.sslServerSocketFactory == null) {
                throw new INITIALIZE("No SSL server socket factory found");
            }
        }
        return this.sslServerSocketFactory;
    }

    private IIOPProfile createEndPointProfile() throws ConfigurationException {
        int port = 0;
        if (this.acceptor != null) {
            port = this.getConfiguredPort();
            if (port == 0) {
                port = ((Acceptor)this.acceptor).getLocalAddress().getPort();
            }
        } else if (this.sslAcceptor == null) {
            throw new INITIALIZE("no acceptors found, cannot create endpoint profile");
        }
        IIOPProfile result = new IIOPProfile(new IIOPAddress(this.dnsEnabled ? this.getHost().getHostName() : this.getHost().getHostAddress(), port), null);
        if (this.sslAcceptor != null && this.generateSSLComponents) {
            result.addComponent(20, this.createSSL(), class$org$omg$SSLIOP$SSLHelper == null ? (class$org$omg$SSLIOP$SSLHelper = IIOPListener.class$("org.omg.SSLIOP.SSLHelper")) : class$org$omg$SSLIOP$SSLHelper);
        }
        result.configure((Configuration)this.configuration);
        return result;
    }

    private SSL createSSL() {
        return new SSL((short)this.target_supports, (short)this.target_requires, (short)this.sslAcceptor.getLocalAddress().getPort());
    }

    private InetAddress getConfiguredHost() {
        try {
            String oa_addr = this.configuration.getAttribute("OAIAddr", "");
            return oa_addr.length() == 0 ? null : InetAddress.getByName(oa_addr);
        }
        catch (UnknownHostException e) {
            throw new INITIALIZE("Could not resolve configured listener host");
        }
    }

    private InetAddress getHost() {
        try {
            InetAddress configuredHost = this.getConfiguredHost();
            return configuredHost == null ? InetAddress.getLocalHost() : configuredHost;
        }
        catch (UnknownHostException e) {
            throw new INITIALIZE("Could not resolve configured listener host");
        }
    }

    private int getConfiguredPort() {
        return this.oaPort;
    }

    private int getConfiguredSSLPort() {
        return this.sslPort;
    }

    private void deliverConnection(Socket socket, boolean isSSL) {
        Connection result = null;
        try {
            result = this.createServerConnection(socket, isSSL);
        }
        catch (IOException ex) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Could not create connection from socket: " + ex);
            }
            return;
        }
        this.deliverConnection(result);
    }

    protected Connection createServerConnection(Socket socket, boolean is_ssl) throws IOException {
        ServerIIOPConnection result = new ServerIIOPConnection(socket, is_ssl);
        try {
            result.configure((Configuration)this.configuration);
        }
        catch (ConfigurationException ce) {
            throw new INTERNAL("ConfigurationException: " + ce.getMessage());
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SSLAcceptor
    extends Acceptor {
        private SSLAcceptor() {
        }

        protected ServerSocket createServerSocket() {
            try {
                return IIOPListener.this.getSSLServerSocketFactory().createServerSocket(IIOPListener.this.getConfiguredSSLPort(), 20, IIOPListener.this.getConfiguredHost());
            }
            catch (IOException e) {
                IIOPListener.this.logger.warn(e.getMessage());
                throw new INITIALIZE("Could not create SSL server socket");
            }
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, true);
        }
    }

    protected class Acceptor
    extends ListenerBase.Acceptor {
        protected ServerSocket serverSocket;
        protected boolean terminated = false;

        public Acceptor() {
            this.setDaemon(true);
        }

        public void init() {
            this.serverSocket = this.createServerSocket();
            if (IIOPListener.this.logger.isDebugEnabled()) {
                IIOPListener.this.logger.debug("Created socket listener on " + this.serverSocket.getInetAddress());
            }
        }

        public void run() {
            while (!this.terminated) {
                try {
                    Socket socket = this.serverSocket.accept();
                    this.setup(socket);
                    this.deliverConnection(socket);
                }
                catch (Exception e) {
                    if (this.terminated || !IIOPListener.this.logger.isWarnEnabled()) continue;
                    IIOPListener.this.logger.warn(e.getMessage());
                }
            }
            if (IIOPListener.this.logger.isInfoEnabled()) {
                IIOPListener.this.logger.info("Listener exited");
            }
        }

        public void terminate() {
            block2: {
                this.terminated = true;
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    if (!IIOPListener.this.logger.isWarnEnabled()) break block2;
                    IIOPListener.this.logger.warn(e.getMessage());
                }
            }
        }

        public IIOPAddress getLocalAddress() {
            return new IIOPAddress(this.serverSocket.getInetAddress().getHostAddress(), this.serverSocket.getLocalPort());
        }

        protected ServerSocket createServerSocket() {
            try {
                return IIOPListener.this.getServerSocketFactory().createServerSocket(IIOPListener.this.getConfiguredPort(), 20, IIOPListener.this.getConfiguredHost());
            }
            catch (IOException ex) {
                IIOPListener.this.logger.warn(ex.getMessage());
                throw new INITIALIZE("Could not create server socket");
            }
        }

        protected void setup(Socket socket) throws IOException {
            socket.setSoTimeout(IIOPListener.this.serverTimeout);
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, false);
        }
    }
}

