/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.factory.PortRangeFactory;
import org.jacorb.orb.factory.ServerSocketFactory;

public class PortRangeServerSocketFactory
extends PortRangeFactory
implements ServerSocketFactory {
    public static final String MIN_PROP = "jacorb.net.server_socket_factory.port.min";
    public static final String MAX_PROP = "jacorb.net.server_socket_factory.port.max";
    private Logger logger;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.orb.port_rang_fctry");
        this.portMin = this.getPortProperty(MIN_PROP);
        this.portMax = this.getPortProperty(MAX_PROP);
        if (this.portMin > this.portMax) {
            throw new ConfigurationException("PortRangeFactory: minimum port number not less than or equal to maximum");
        }
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        for (int localPort = this.portMin; localPort <= this.portMax; ++localPort) {
            try {
                ServerSocket socket = new ServerSocket(localPort, backlog);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("PortRangeServerSocketFactory: Created server socket at :" + localPort);
                }
                return socket;
            }
            catch (IOException ex) {
                continue;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Cannot create server socket between ports " + this.portMin + " and " + this.portMax);
        }
        throw new BindException("PortRangeServerSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        for (int localPort = this.portMin; localPort <= this.portMax; ++localPort) {
            try {
                ServerSocket socket = new ServerSocket(localPort, backlog, ifAddress);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Created server socket at :" + localPort);
                }
                return socket;
            }
            catch (IOException ex) {
                continue;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Cannot create server socket between ports " + this.portMin + " and " + this.portMax);
        }
        throw new BindException("PortRangeServerSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        for (int localPort = this.portMin; localPort <= this.portMax; ++localPort) {
            try {
                ServerSocket socket = new ServerSocket(localPort);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Created server socket at :" + localPort);
                }
                return socket;
            }
            catch (IOException ex) {
                continue;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Cannot create server socket between ports " + this.portMin + " and " + this.portMax);
        }
        throw new BindException("PortRangeServerSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }
}

