/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.etf;

import org.apache.avalon.framework.configuration.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.TaggedComponentList;
import org.omg.CORBA.BAD_PARAM;
import org.omg.ETF.Profile;
import org.omg.ETF._ProfileLocalBase;
import org.omg.GIOP.Version;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;

public abstract class ProfileBase
extends _ProfileLocalBase
implements Cloneable,
Configurable {
    protected Version version = null;
    protected byte[] objectKey = null;
    protected TaggedComponentList components = null;
    protected Configuration configuration;
    protected String corbalocStr = null;

    public void set_object_key(byte[] key) {
        this.objectKey = key;
    }

    public byte[] get_object_key() {
        return this.objectKey;
    }

    public Version version() {
        return this.version;
    }

    public abstract int tag();

    public void marshal(TaggedProfileHolder tagged_profile, TaggedComponentSeqHolder components) {
        if (this.encapsulation() != 0) {
            throw new Error("We can only marshal big endian stylee profiles !!");
        }
        CDROutputStream profileDataStream = new CDROutputStream();
        profileDataStream.beginEncapsulatedArray();
        this.writeAddressProfile(profileDataStream);
        profileDataStream.write_long(this.objectKey.length);
        profileDataStream.write_octet_array(this.objectKey, 0, this.objectKey.length);
        switch (this.version.minor) {
            case 0: {
                break;
            }
            default: {
                int i;
                if (components == null) {
                    components = new TaggedComponentSeqHolder(new TaggedComponent[0]);
                }
                profileDataStream.write_long(this.components.size() + components.value.length);
                for (i = 0; i < this.components.asArray().length; ++i) {
                    TaggedComponentHelper.write(profileDataStream, this.components.asArray()[i]);
                }
                for (i = 0; i < components.value.length; ++i) {
                    TaggedComponentHelper.write(profileDataStream, components.value[i]);
                }
            }
        }
        tagged_profile.value = new TaggedProfile(this.tag(), profileDataStream.getBufferCopy());
    }

    public void demarshal(TaggedProfileHolder tagged_profile, TaggedComponentSeqHolder components) {
        if (tagged_profile.value.tag != this.tag()) {
            throw new BAD_PARAM("Wrong tag for Transport, tag: " + tagged_profile.value.tag);
        }
        this.initFromProfileData(tagged_profile.value.profile_data);
        components.value = this.getComponents().asArray();
    }

    public short encapsulation() {
        return 0;
    }

    public abstract void writeAddressProfile(CDROutputStream var1);

    public abstract void readAddressProfile(CDRInputStream var1);

    public TaggedComponentList getComponents() {
        return this.components;
    }

    public Object getComponent(int tag, Class helper) {
        return this.components.getComponent(tag, helper);
    }

    public void addComponent(int tag, Object data, Class helper) {
        this.components.addComponent(tag, data, helper);
    }

    public void addComponent(int tag, byte[] data) {
        this.components.addComponent(tag, data);
    }

    public TaggedProfile asTaggedProfile() {
        TaggedProfileHolder result = new TaggedProfileHolder();
        this.marshal(result, null);
        return result.value;
    }

    public Profile copy() {
        try {
            return (Profile)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("error cloning profile: " + e);
        }
    }

    protected void initFromProfileData(byte[] data) {
        CDRInputStream in = new CDRInputStream(null, data);
        in.openEncapsulatedArray();
        this.readAddressProfile(in);
        int length = in.read_ulong();
        this.objectKey = new byte[length];
        in.read_octet_array(this.objectKey, 0, length);
        this.components = this.version != null && this.version.minor > 0 ? new TaggedComponentList(in) : new TaggedComponentList();
    }
}

