/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.applet.Applet;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imr.ImRAccessImpl;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ImRAccess;
import org.jacorb.orb.NVList;
import org.jacorb.orb.NamedValue;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.ServantDelegate;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.dii.ExceptionList;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.dynany.DynAnyFactoryImpl;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.policies.MaxHopsPolicy;
import org.jacorb.orb.policies.PolicyManager;
import org.jacorb.orb.policies.QueueOrderPolicy;
import org.jacorb.orb.policies.RebindPolicy;
import org.jacorb.orb.policies.RelativeRequestTimeoutPolicy;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.jacorb.orb.policies.ReplyEndTimePolicy;
import org.jacorb.orb.policies.ReplyPriorityPolicy;
import org.jacorb.orb.policies.ReplyStartTimePolicy;
import org.jacorb.orb.policies.RequestEndTimePolicy;
import org.jacorb.orb.policies.RequestPriorityPolicy;
import org.jacorb.orb.policies.RequestStartTimePolicy;
import org.jacorb.orb.policies.RoutingPolicy;
import org.jacorb.orb.policies.SyncScopePolicy;
import org.jacorb.orb.portableInterceptor.CodecFactoryImpl;
import org.jacorb.orb.portableInterceptor.IORInfoImpl;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.poa.POAListener;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_QOS;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.Environment;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.ServiceInformationHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;
import org.omg.IOP.MultipleComponentProfileHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.Servant;
import org.omg.SecurityLevel2.Current;

public final class ORB
extends ORBSingleton
implements POAListener,
Configurable {
    private static final String versionString = "2.2.1 (JBoss patch 2)";
    private static final String dateString = "27-Mar-2005";
    private static final String nullIORString = "IOR:00000000000000010000000000000000";
    private org.jacorb.config.Configuration configuration = null;
    private boolean cacheReferences;
    private String implName;
    private int giopMinorVersion;
    private boolean giopAdd_1_0_Profiles;
    private String hashTableClassName;
    private boolean useIMR;
    private boolean useIMREndpoint;
    private String imrProxyHost = null;
    private int imrProxyPort = -1;
    private String iorProxyHost;
    private int iorProxyPort = -1;
    private boolean printVersion = true;
    private Map initial_references = new HashMap();
    private org.jacorb.poa.POA rootpoa;
    private org.jacorb.poa.Current poaCurrent;
    private BasicAdapter basicAdapter;
    private Current securityCurrent = null;
    private InterceptorManager interceptor_manager = null;
    private boolean hasClientInterceptors = false;
    private boolean hasServerInterceptors = false;
    private org.omg.PortableInterceptor.Current piCurrent = new PICurrent();
    private Map knownReferences = null;
    private ClientConnectionManager clientConnectionManager;
    private TransportManager transport_manager = null;
    private GIOPConnectionManager giop_connection_manager = null;
    private BufferManager bufferManager;
    protected Map valueFactories = new HashMap();
    protected Map boxedValueHelpers = new HashMap();
    private Map objectKeyMap = new HashMap();
    private Properties _props;
    private Logger logger;
    public String[] _args;
    public Applet applet;
    private java.lang.Object orb_synch = new java.lang.Object();
    private boolean run = true;
    private boolean wait = true;
    private boolean shutdown_in_progress = false;
    private boolean destroyed = false;
    private java.lang.Object shutdown_synch = new java.lang.Object();
    private ImRAccess imr = null;
    private int persistentPOACount;
    public static final String orb_id = "jacorb:2.2.1 (JBoss patch 2)";
    private Set requests = Collections.synchronizedSet(new HashSet());
    private Request request = null;
    private PolicyManager policyManager = null;
    private Map policy_factories = null;
    private static TCKind kind;
    private static final String[] services;
    private boolean bidir_giop = false;
    private boolean firstConnection = true;
    private Map connectedObjects = new HashMap();
    static /* synthetic */ Class class$org$omg$CORBA$ORB;
    static /* synthetic */ Class class$org$apache$avalon$framework$configuration$Configuration;
    static /* synthetic */ Class class$org$omg$CORBA$portable$ValueFactory;

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        super.configure(myConfiguration);
        this.configuration = (org.jacorb.config.Configuration)myConfiguration;
        this.logger = this.configuration.getNamedLogger("jacorb.orb");
        this.cacheReferences = this.configuration.getAttribute("jacorb.reference_caching", "off").equals("on");
        this.implName = this.configuration.getAttribute("jacorb.implname", "");
        this.giopMinorVersion = this.configuration.getAttributeAsInteger("jacorb.giop_minor_version", 2);
        this.giopAdd_1_0_Profiles = this.configuration.getAttribute("jacorb.giop.add_1_0_profiles", "off").equals("on");
        this.hashTableClassName = this.configuration.getAttribute("jacorb.hashtable_class", "");
        this.useIMR = this.configuration.getAttribute("jacorb.use_imr", "off").equals("on");
        this.imrProxyHost = this.configuration.getAttribute("jacorb.imr.ior_proxy_host", null);
        this.imrProxyPort = this.configuration.getAttributeAsInteger("jacorb.imr.ior_proxy_port", -1);
        this.useIMREndpoint = this.configuration.getAttribute("jacorb.use_imr", "on").equals("on");
        this.iorProxyHost = this.configuration.getAttribute("jacorb.ior_proxy_host", null);
        this.iorProxyPort = this.configuration.getAttributeAsInteger("jacorb.ior_proxy_port", -1);
        this.printVersion = this.configuration.getAttribute("jacorb.orb.print_version", "on").equals("on");
        if (this.printVersion && this.logger.isInfoEnabled()) {
            this.logger.info("\n\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\tJacORB V 2.2.1 (JBoss patch 2), www.jacorb.org\n\t(C) Gerald Brose, XTRADYNE Technologies/FU Berlin, 27-Mar-2005\n\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        BufferManager.configure((Configuration)this.configuration);
        try {
            this.bufferManager = BufferManager.getInstance();
        }
        catch (BAD_INV_ORDER b) {
            b.printStackTrace();
        }
        this.configureObjectKeyMap((Configuration)this.configuration);
    }

    public org.jacorb.config.Configuration getConfiguration() {
        return this.configuration;
    }

    public String id() {
        return orb_id;
    }

    public boolean useBiDirGIOP() {
        return this.bidir_giop;
    }

    public void turnOnBiDirGIOP() {
        if (!this.bidir_giop) {
            this.bidir_giop = true;
            this.clientConnectionManager.setRequestListener(this.basicAdapter.getRequestListener());
        }
    }

    public synchronized Object _getObject(ParsedIOR pior) {
        Delegate d;
        ObjectImpl o;
        String key;
        block12: {
            key = pior.getIORString();
            o = (ObjectImpl)this.knownReferences.get(key);
            if (o != null) {
                Delegate del = (Delegate)o._get_delegate();
                if (del != null) {
                    ParsedIOR delpior = del.getParsedIOR();
                    if (delpior == null) {
                        this.knownReferences.remove(key);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Removing an invalid reference from cache.");
                        }
                    } else if (pior.getEffectiveProfile().is_match(delpior.getEffectiveProfile())) {
                        return o._duplicate();
                    }
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Remove stale reference from cache ");
                    }
                    this.knownReferences.remove(key);
                }
            }
            if (pior == null && this.logger.isErrorEnabled()) {
                this.logger.error("Internal error, pior is null");
            }
            d = new Delegate(this, pior);
            try {
                d.configure((Configuration)this.configuration);
            }
            catch (ConfigurationException ce) {
                if (!this.logger.isErrorEnabled()) break block12;
                this.logger.error("ConfigurationException", (Throwable)ce);
            }
        }
        o = d.getReference(null);
        if (this.cacheReferences) {
            this.knownReferences.put(key, o);
        }
        return o;
    }

    org.jacorb.poa.POA findPOA(Delegate d, Object ref) {
        String refImplName = null;
        if (this.rootpoa == null || this.basicAdapter == null) {
            return null;
        }
        try {
            refImplName = POAUtil.extractImplName(d.getObjectKey());
        }
        catch (POAInternalError pie) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: reference generated by foreign POA");
            }
            return null;
        }
        if (refImplName == null) {
            if (this.implName.length() > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("findPOA: impl_name mismatch");
                }
                return null;
            }
        } else if (!this.implName.equals(refImplName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: impl_name mismatch");
            }
            return null;
        }
        try {
            String res;
            org.jacorb.poa.POA tmp_poa = this.rootpoa;
            String poa_name = POAUtil.extractPOAName(d.getObjectKey());
            List scopes = POAUtil.extractScopedPOANames(poa_name);
            for (int i = 0; i < scopes.size() && !(res = (String)scopes.get(i)).equals(""); ++i) {
                try {
                    tmp_poa = tmp_poa._getChildPOA(res);
                    continue;
                }
                catch (ParentIsHolding p) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("findPOA: holding adapter");
                    }
                    return null;
                }
            }
            byte[] objectId = POAUtil.extractOID(ref);
            if (tmp_poa.isSystemId() && !tmp_poa.previouslyGeneratedObjectId(objectId)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("findPOA: not a previously generated object key.");
                }
                return null;
            }
            return tmp_poa;
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getMessage());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: nothing found");
            }
            return null;
        }
    }

    public ClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public GIOPConnectionManager getGIOPConnectionManager() {
        if (this.giop_connection_manager == null) {
            this.giop_connection_manager = new GIOPConnectionManager();
            try {
                this.giop_connection_manager.configure((Configuration)this.configuration);
            }
            catch (ConfigurationException ce) {
                throw new INTERNAL(ce.getMessage());
            }
        }
        return this.giop_connection_manager;
    }

    synchronized void _release(String iorString) {
        this.knownReferences.remove(iorString);
    }

    public Policy create_policy(int type, Any value) throws PolicyError {
        switch (type) {
            case 34: {
                return new MaxHopsPolicy(value);
            }
            case 35: {
                return new QueueOrderPolicy(value);
            }
            case 23: {
                return new RebindPolicy(value);
            }
            case 31: {
                return new RelativeRequestTimeoutPolicy(value);
            }
            case 32: {
                return new RelativeRoundtripTimeoutPolicy(value);
            }
            case 30: {
                return new ReplyEndTimePolicy(value);
            }
            case 26: {
                return new ReplyPriorityPolicy(value);
            }
            case 29: {
                return new ReplyStartTimePolicy(value);
            }
            case 28: {
                return new RequestEndTimePolicy(value);
            }
            case 25: {
                return new RequestPriorityPolicy(value);
            }
            case 27: {
                return new RequestStartTimePolicy(value);
            }
            case 33: {
                return new RoutingPolicy(value);
            }
            case 24: {
                return new SyncScopePolicy(value);
            }
        }
        Integer key = new Integer(type);
        if (this.policy_factories == null || !this.policy_factories.containsKey(key)) {
            throw new PolicyError();
        }
        PolicyFactory factory = (PolicyFactory)this.policy_factories.get(key);
        return factory.create_policy(type, value);
    }

    public boolean hasPolicyFactoryForType(int type) {
        return this.policy_factories != null && this.policy_factories.containsKey(new Integer(type));
    }

    public ContextList create_context_list() {
        throw new NO_IMPLEMENT();
    }

    public Environment create_environment() {
        throw new NO_IMPLEMENT();
    }

    public OutputStream create_output_stream() {
        return new CDROutputStream(this);
    }

    IOR createIOR(String repId, byte[] objectKey, boolean _transient, org.jacorb.poa.POA poa, Map policy_overrides) {
        IIOPProfile iiopProfile;
        TaggedComponentList multipleComponents;
        HashMap<Integer, TaggedComponentList> componentMap;
        ArrayList<Profile> profiles;
        block9: {
            profiles = new ArrayList<Profile>();
            componentMap = new HashMap<Integer, TaggedComponentList>();
            int[] profileTags = new int[this.basicAdapter.getEndpointProfiles().size()];
            int n = 0;
            Iterator i = this.basicAdapter.getEndpointProfiles().iterator();
            while (i.hasNext()) {
                Profile profile = (Profile)i.next();
                profile.set_object_key(objectKey);
                profiles.add(profile);
                profileTags[n++] = profile.tag();
                TaggedComponentList profileComponents = new TaggedComponentList();
                profileComponents.addComponent(this.create_ORB_TYPE_ID());
                componentMap.put(new Integer(profile.tag()), profileComponents);
                if (!(profile instanceof IIOPProfile)) continue;
                this.patchAddress((IIOPProfile)profile, repId, _transient);
                if (!poa.isSSLRequired()) continue;
                ((IIOPProfile)profile).patchPrimaryAddress(null, 0);
            }
            multipleComponents = new TaggedComponentList();
            componentMap.put(new Integer(1), multipleComponents);
            if (this.interceptor_manager != null && this.interceptor_manager.hasIORInterceptors()) {
                IORInfoImpl info = new IORInfoImpl(this, poa, componentMap, policy_overrides, profiles);
                this.interceptor_manager.setProfileTags(profileTags);
                try {
                    this.interceptor_manager.getIORIterator().iterate(info);
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block9;
                    this.logger.error(e.getMessage());
                }
            }
        }
        if ((iiopProfile = this.findIIOPProfile(profiles)) != null && (this.giopMinorVersion == 0 || this.giopAdd_1_0_Profiles)) {
            IIOPProfile profile_1_0 = iiopProfile.to_GIOP_1_0();
            profiles.add(profile_1_0);
            TaggedComponentList iiopComponents = (TaggedComponentList)componentMap.get(new Integer(0));
            multipleComponents.addAll(iiopProfile.getComponents());
            multipleComponents.addAll(iiopComponents);
            if (this.giopMinorVersion == 0) {
                profiles.remove(iiopProfile);
            }
        }
        TaggedProfile[] tps = null;
        if (multipleComponents.isEmpty()) {
            tps = new TaggedProfile[profiles.size()];
        } else {
            tps = new TaggedProfile[profiles.size() + 1];
            tps[tps.length - 1] = this.createMultipleComponentsProfile(multipleComponents);
        }
        TaggedProfileHolder tp = new TaggedProfileHolder();
        TaggedComponentSeqHolder tc = new TaggedComponentSeqHolder();
        for (int i = 0; i < profiles.size(); ++i) {
            Profile p = (Profile)profiles.get(i);
            TaggedComponentList c = (TaggedComponentList)componentMap.get(new Integer(p.tag()));
            tc.value = c.asArray();
            p.marshal(tp, tc);
            tps[i] = tp.value;
        }
        return new IOR(repId, tps);
    }

    private TaggedProfile createMultipleComponentsProfile(TaggedComponentList components) {
        CDROutputStream out = new CDROutputStream(this);
        out.beginEncapsulatedArray();
        MultipleComponentProfileHelper.write(out, components.asArray());
        return new TaggedProfile(1, out.getBufferCopy());
    }

    private IIOPProfile findIIOPProfile(List profiles) {
        Iterator i = profiles.iterator();
        while (i.hasNext()) {
            Profile p = (Profile)i.next();
            if (!(p instanceof IIOPProfile)) continue;
            return (IIOPProfile)p;
        }
        return null;
    }

    public Context get_default_context() {
        throw new NO_IMPLEMENT();
    }

    public BasicAdapter getBasicAdapter() {
        if (this.basicAdapter == null) {
            throw new INITIALIZE("Adapters not initialized; resolve RootPOA.");
        }
        return this.basicAdapter;
    }

    public org.jacorb.poa.Current getPOACurrent() {
        if (this.poaCurrent == null) {
            this.poaCurrent = org.jacorb.poa.Current._Current_init();
        }
        return this.poaCurrent;
    }

    public Object getReference(org.jacorb.poa.POA poa, byte[] object_key, String rep_id, boolean _transient) {
        Delegate d;
        block4: {
            IOR ior;
            if (rep_id == null) {
                rep_id = "IDL:omg.org/CORBA/Object:1.0";
            }
            if ((ior = this.createIOR(rep_id, object_key, _transient, poa, null)) == null && this.logger.isErrorEnabled()) {
                this.logger.error("Interal error: createIOR returns null");
            }
            d = new Delegate(this, ior);
            try {
                d.configure((Configuration)this.configuration);
            }
            catch (ConfigurationException ce) {
                if (!this.logger.isErrorEnabled()) break block4;
                this.logger.error(ce.getMessage(), (Throwable)ce);
            }
        }
        return d.getReference(poa);
    }

    public org.jacorb.poa.POA getRootPOA() throws INITIALIZE {
        if (this.rootpoa == null) {
            this.rootpoa = org.jacorb.poa.POA._POA_init(this);
            this.basicAdapter = new BasicAdapter(this, this.rootpoa, this.getTransportManager(), this.getGIOPConnectionManager());
            try {
                this.basicAdapter.configure((Configuration)this.configuration);
                this.rootpoa.configure((Configuration)this.configuration);
            }
            catch (ConfigurationException ce) {
                throw new INITIALIZE("ConfigurationException: " + ce.getMessage());
            }
            this.rootpoa._addPOAEventListener(this);
        }
        return this.rootpoa;
    }

    public boolean isApplet() {
        return this.applet != null;
    }

    public Applet getApplet() {
        return this.applet;
    }

    public String[] list_initial_services() {
        ArrayList l = new ArrayList();
        Iterator e = this.initial_references.keySet().iterator();
        while (e.hasNext()) {
            l.add(e.next());
        }
        String[] initial_services = new String[services.length + l.size()];
        l.toArray(initial_services);
        System.arraycopy(services, 0, initial_services, l.size(), services.length);
        return initial_services;
    }

    public void poaCreated(org.jacorb.poa.POA poa) {
        poa._addPOAEventListener(this);
        if (poa.isPersistent()) {
            ++this.persistentPOACount;
            this.getImR();
            if (this.imr != null) {
                String server_name = this.implName;
                this.imr.registerPOA(server_name + "/" + poa._getQualifiedName(), server_name, this.getServerAddress(), this.getServerPort());
            }
        }
    }

    private void getImR() {
        if (this.imr == null && this.useIMR) {
            try {
                this.imr = ImRAccessImpl.connect(this);
            }
            catch (Exception e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Error: No connection to ImplementationRepository");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(e.getMessage());
                }
                if (e instanceof INTERNAL) {
                    throw new OBJ_ADAPTER("Unable to resolve ImR");
                }
                if (e instanceof TRANSIENT) {
                    throw (TRANSIENT)e;
                }
                throw new OBJ_ADAPTER(e.toString());
            }
        }
    }

    private void patchAddress(IIOPProfile profile, String repId, boolean _transient) {
        if (repId.equals("IDL:org/jacorb/imr/ImplementationRepository:1.0")) {
            profile.patchPrimaryAddress(this.imrProxyHost, this.imrProxyPort);
        } else if (!_transient && this.useIMR && this.useIMREndpoint) {
            this.getImR();
            profile.patchPrimaryAddress(this.imr.getImRHost(), this.imr.getImRPort());
            profile.patchPrimaryAddress(this.imrProxyHost, this.imrProxyPort);
        } else {
            profile.patchPrimaryAddress(this.iorProxyHost, this.iorProxyPort);
        }
    }

    private TaggedComponent create_ORB_TYPE_ID() {
        CDROutputStream orbIDComponentDataStream = new CDROutputStream(this);
        orbIDComponentDataStream.beginEncapsulatedArray();
        orbIDComponentDataStream.write_long(1245790976);
        return new TaggedComponent(0, orbIDComponentDataStream.getBufferCopy());
    }

    private String getServerAddress() {
        String address = this.iorProxyHost;
        if (address == null) {
            address = this.getBasicAdapter().getAddress();
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Using proxy host " + address + " in IOR");
        }
        return address;
    }

    private int getServerPort() {
        int port = -1;
        if (this.iorProxyPort != -1) {
            port = this.iorProxyPort;
            if (port < 0) {
                throw new BAD_QOS("Negative port numbers are not allowed! (check property \"jacorb.ior_proxy_port\")");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Using proxy port " + port + " in IOR");
            }
        } else {
            port = this.getBasicAdapter().getPort();
        }
        return port;
    }

    private String getIMRAddressForIOR(String imrAddress) {
        return this.imrProxyHost == null ? imrAddress : this.imrProxyHost;
    }

    private int getIMRPortForIOR(int imrPort) {
        return this.imrProxyPort;
    }

    public void poaStateChanged(org.jacorb.poa.POA poa, int new_state) {
        if ((new_state == 4 || new_state == 3) && poa.isPersistent() && this.imr != null && --this.persistentPOACount == 0) {
            this.imr.setServerDown(this.implName);
        }
    }

    public void referenceCreated(Object o) {
    }

    public boolean get_service_information(short service_type, ServiceInformationHolder service_information) {
        throw new NO_IMPLEMENT();
    }

    public Object resolve_initial_references(String identifier) throws InvalidName {
        if (this.initial_references.containsKey(identifier)) {
            return (Object)this.initial_references.get(identifier);
        }
        Object obj = null;
        String url = null;
        try {
            url = this.configuration.getAttribute("ORBInitRef." + identifier);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url != null) {
            try {
                obj = this.string_to_object(url);
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not create initial reference for \"" + identifier + "\"\n" + "Please check property \"ORBInitRef." + identifier + '\"');
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(e.getMessage());
                }
                throw new InvalidName();
            }
        }
        if (identifier.equals("NameService") && this.isApplet()) {
            block27: {
                try {
                    String ior_str = ObjectUtil.readURL("http://" + this.applet.getCodeBase().getHost() + "/" + "NameService.ior");
                    obj = this.string_to_object(ior_str);
                }
                catch (IOException io) {
                    if (!this.logger.isWarnEnabled()) break block27;
                    this.logger.warn(io.getMessage());
                }
            }
            if (obj != null && !obj._is_a(NamingContextHelper.id())) {
                obj = null;
            }
        } else {
            if (identifier.equals("RootPOA")) {
                return this.getRootPOA();
            }
            if (identifier.equals("POACurrent")) {
                return this.getPOACurrent();
            }
            if (identifier.equals("SecurityCurrent")) {
                block28: {
                    if (this.securityCurrent == null) {
                        try {
                            Class currentClass = ObjectUtil.classForName("org.jacorb.security.level2.CurrentImpl");
                            Constructor constr = currentClass.getConstructor(class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = ORB.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB);
                            this.securityCurrent = (Current)constr.newInstance(this);
                            Method configureMethod = currentClass.getDeclaredMethod("configure", class$org$apache$avalon$framework$configuration$Configuration == null ? (class$org$apache$avalon$framework$configuration$Configuration = ORB.class$("org.apache.avalon.framework.configuration.Configuration")) : class$org$apache$avalon$framework$configuration$Configuration);
                            configureMethod.invoke((java.lang.Object)this.securityCurrent, new java.lang.Object[]{this.configuration});
                            Method init = currentClass.getDeclaredMethod("init", new Class[0]);
                            init.invoke((java.lang.Object)this.securityCurrent, new java.lang.Object[0]);
                        }
                        catch (Exception e) {
                            if (!this.logger.isWarnEnabled()) break block28;
                            this.logger.warn("Exception", (Throwable)e);
                        }
                    }
                }
                obj = this.securityCurrent;
            } else if (identifier.equals("DynAnyFactory")) {
                obj = new DynAnyFactoryImpl(this);
            } else {
                if (identifier.equals("PICurrent")) {
                    return this.piCurrent;
                }
                if (identifier.equals("ORBPolicyManager")) {
                    return this.getPolicyManager();
                }
                if (identifier.equals("CodecFactory")) {
                    obj = new CodecFactoryImpl(this);
                } else {
                    throw new InvalidName();
                }
            }
        }
        if (obj != null) {
            this.initial_references.put(identifier, obj);
        }
        return obj;
    }

    PolicyManager getPolicyManager() {
        return this.policyManager;
    }

    public void register_initial_reference(String id, Object obj) throws InvalidName {
        if (id == null || id.length() == 0 || this.initial_references.containsKey(id)) {
            throw new InvalidName();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registering initial ref " + id);
        }
        this.initial_references.put(id, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB run");
        }
        try {
            java.lang.Object object = this.orb_synch;
            synchronized (object) {
                while (this.run) {
                    this.orb_synch.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB run, exit");
        }
    }

    public void send_multiple_requests_oneway(org.omg.CORBA.Request[] req) {
        for (int i = 0; i < req.length; ++i) {
            req[i].send_oneway();
        }
    }

    public void send_multiple_requests_deferred(org.omg.CORBA.Request[] req) {
        for (int i = 0; i < req.length; ++i) {
            req[i].send_deferred();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean poll_next_response() {
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set set = this.requests;
        synchronized (set) {
            Iterator iter = this.requests.iterator();
            while (iter.hasNext()) {
                Request req = (Request)iter.next();
                if (!req.poll_response()) continue;
                this.request = req;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.CORBA.Request get_next_response() {
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set set = this.requests;
        synchronized (set) {
            Request req = null;
            if (this.request != null) {
                this.request.get_response();
                req = this.request;
                this.request = null;
                return req;
            }
            block3: while (true) {
                Iterator iter = this.requests.iterator();
                do {
                    if (!iter.hasNext()) continue block3;
                } while (!(req = (Request)iter.next()).poll_response());
                break;
            }
            req.get_response();
            return req;
        }
    }

    public void addRequest(org.omg.CORBA.Request req) {
        this.requests.add(req);
    }

    public void removeRequest(org.omg.CORBA.Request req) {
        this.requests.remove(req);
    }

    protected void set_parameters(String[] args, Properties props) {
        block18: {
            this._props = props;
            try {
                this.configure((Configuration)org.jacorb.config.Configuration.getConfiguration(props, this));
            }
            catch (ConfigurationException ce) {
                if (this.logger != null && this.logger.isErrorEnabled()) {
                    this.logger.error(ce.getMessage());
                } else {
                    ce.printStackTrace();
                }
                throw new INITIALIZE(ce.getMessage());
            }
            if (args != null) {
                this._args = args;
                for (int i = 0; i < args.length; ++i) {
                    int equals_pos;
                    String prop;
                    String arg = args[i].trim();
                    if (arg.startsWith("-ORBInitRef.")) {
                        prop = arg.substring(1);
                        equals_pos = prop.indexOf(61);
                        if (equals_pos == -1) {
                            throw new BAD_PARAM("InitRef format invalid for " + prop);
                        }
                        this.configuration.setAttribute(prop.substring(0, equals_pos), prop.substring(equals_pos + 1));
                        continue;
                    }
                    if (!arg.equals("-ORBInitRef")) continue;
                    if (args.length - 1 < i + 1) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn("WARNING: -ORBInitRef argument without value");
                        continue;
                    }
                    if ((equals_pos = (prop = args[++i].trim()).indexOf(61)) == -1) {
                        throw new BAD_PARAM("InitRef format invalid for " + prop);
                    }
                    this.configuration.setAttribute("ORBInitRef." + prop.substring(0, equals_pos), prop.substring(equals_pos + 1));
                }
            }
            this.policyManager = new PolicyManager(this);
            try {
                this.clientConnectionManager = new ClientConnectionManager(this, this.getTransportManager(), this.getGIOPConnectionManager());
                this.clientConnectionManager.configure((Configuration)this.configuration);
            }
            catch (ConfigurationException ce) {
                if (!this.logger.isErrorEnabled()) break block18;
                this.logger.error(ce.getMessage());
            }
        }
        if (this.hashTableClassName == null || this.hashTableClassName.length() == 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Property \"jacorb.hashtable_class\" not present. Will use default hashtable implementation");
            }
            this.knownReferences = new HashMap();
        } else {
            try {
                this.knownReferences = (Map)ObjectUtil.classForName(this.hashTableClassName).newInstance();
            }
            catch (Exception e) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(e.getMessage());
                }
                this.knownReferences = new HashMap();
            }
        }
        this.interceptorInit();
    }

    protected void set_parameters(Applet app, Properties props) {
        block11: {
            this.applet = app;
            this._props = props;
            try {
                this.configure((Configuration)org.jacorb.config.Configuration.getConfiguration(props, this));
            }
            catch (ConfigurationException ce) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error(ce.getMessage());
                }
                throw new INITIALIZE(ce.getMessage());
            }
            try {
                this.clientConnectionManager = new ClientConnectionManager(this, this.getTransportManager(), this.getGIOPConnectionManager());
                this.clientConnectionManager.configure((Configuration)this.configuration);
            }
            catch (ConfigurationException ce) {
                if (!this.logger.isErrorEnabled()) break block11;
                this.logger.error(ce.getMessage());
            }
        }
        if (this.hashTableClassName == null || this.hashTableClassName.length() == 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Property \"jacorb.hashtable_class\" not present. Will use default hashtable implementation");
            }
            this.knownReferences = new HashMap();
        } else {
            try {
                this.knownReferences = (Map)ObjectUtil.classForName(this.hashTableClassName).newInstance();
            }
            catch (Exception e) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(e.getMessage());
                }
                this.knownReferences = new HashMap();
            }
        }
        this.interceptorInit();
    }

    private void interceptorInit() {
        Vector orb_initializers = this.getORBInitializers();
        if (orb_initializers.size() > 0) {
            ORBInitializer init;
            int i;
            ORBInitInfoImpl info = new ORBInitInfoImpl(this);
            for (i = 0; i < orb_initializers.size(); ++i) {
                try {
                    init = (ORBInitializer)orb_initializers.elementAt(i);
                    init.pre_init(info);
                    continue;
                }
                catch (Exception e) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn(e.getMessage());
                }
            }
            for (i = 0; i < orb_initializers.size(); ++i) {
                try {
                    init = (ORBInitializer)orb_initializers.elementAt(i);
                    init.post_init(info);
                    continue;
                }
                catch (Exception e) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn(e.getMessage());
                }
            }
            info.setInvalid();
            Vector client_interceptors = info.getClientInterceptors();
            Vector server_interceptors = info.getServerInterceptors();
            Vector ior_intercept = info.getIORInterceptors();
            this.hasClientInterceptors = client_interceptors.size() > 0;
            boolean bl = this.hasServerInterceptors = server_interceptors.size() > 0;
            if (this.hasClientInterceptors || this.hasServerInterceptors || ior_intercept.size() > 0) {
                this.interceptor_manager = new InterceptorManager(client_interceptors, server_interceptors, ior_intercept, info.getSlotCount(), this);
            }
            this.policy_factories = info.getPolicyFactories();
        }
    }

    private Vector getORBInitializers() {
        String[] prop_names = this.configuration.getAttributeNames();
        Vector orb_initializers = new Vector();
        String initializer_prefix = "org.omg.PortableInterceptor.ORBInitializerClass.";
        for (int i = 0; i < prop_names.length; ++i) {
            if (!prop_names[i].startsWith(initializer_prefix)) continue;
            String name = null;
            name = this.configuration.getAttribute(prop_names[i], "");
            if (name.length() == 0 && prop_names[i].length() > initializer_prefix.length()) {
                name = prop_names[i].substring(initializer_prefix.length());
            }
            if (name == null) continue;
            try {
                orb_initializers.addElement(ObjectUtil.classForName(name).newInstance());
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Build: " + name);
                continue;
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Unable to build ORBInitializer from >>" + name + "<<");
            }
        }
        return orb_initializers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait_for_completion) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("prepare ORB for shutdown...");
        }
        if (!this.run) {
            return;
        }
        java.lang.Object object = this.shutdown_synch;
        synchronized (object) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ORB going down...");
            }
            if (this.shutdown_in_progress && wait_for_completion) {
                java.lang.Object object2 = this.shutdown_synch;
                synchronized (object2) {
                    try {
                        this.shutdown_synch.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ORB going shutdown complete (1)");
                    }
                    return;
                }
            }
            if (this.shutdown_in_progress && !wait_for_completion) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ORB going shutdown complete (2)");
                }
                return;
            }
            this.shutdown_in_progress = true;
        }
        if (this.rootpoa != null) {
            this.rootpoa.destroy(true, wait_for_completion);
        }
        if (this.basicAdapter != null) {
            this.basicAdapter.stopListeners();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ORB going shutdown (cleaning up ORB...)");
        }
        this.clientConnectionManager.shutdown();
        this.knownReferences.clear();
        this.bufferManager.release();
        object = this.shutdown_synch;
        synchronized (object) {
            this.shutdown_synch.notifyAll();
        }
        object = this.orb_synch;
        synchronized (object) {
            this.run = false;
            this.orb_synch.notifyAll();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB shutdown complete");
        }
    }

    public void destroy() {
        if (this.destroyed) {
            throw new OBJECT_NOT_EXIST();
        }
        if (this.run) {
            this.shutdown(true);
        }
        if (this.interceptor_manager != null) {
            this.interceptor_manager.destroy();
        }
        this.destroyed = true;
    }

    public Object string_to_object(String str) {
        if (str == null) {
            return null;
        }
        try {
            ParsedIOR pior = new ParsedIOR(str, this, this.logger);
            if (pior.isNull()) {
                return null;
            }
            return this._getObject(pior);
        }
        catch (IllegalArgumentException iae) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(iae.getMessage());
            }
            return null;
        }
    }

    public Object get_value_def(String repid) throws BAD_PARAM {
        throw new NO_IMPLEMENT();
    }

    public void set_delegate(java.lang.Object wrapper) {
        if (!(wrapper instanceof Servant)) {
            throw new BAD_PARAM("Argument must be of type org.omg.PortableServer.Servant");
        }
        try {
            ((Servant)wrapper)._get_delegate();
        }
        catch (BAD_INV_ORDER bio) {
            ServantDelegate delegate = new ServantDelegate(this);
            ((Servant)wrapper)._set_delegate(delegate);
        }
    }

    public void useProxy() {
        this.applet = new Applet();
    }

    public String object_to_string(Object obj) {
        if (obj == null) {
            return nullIORString;
        }
        if (obj instanceof LocalObject) {
            throw new MARSHAL("Attempt to stringify a local object");
        }
        org.omg.CORBA.portable.Delegate delegate = ((ObjectImpl)obj)._get_delegate();
        if (delegate instanceof Delegate) {
            return delegate.toString();
        }
        throw new BAD_PARAM("Argument has a delegate whose class is " + delegate.getClass().getName() + ", a org.jacorb.orb.Delegate was expected");
    }

    public void perform_work() {
        if (!this.run) {
            throw new BAD_INV_ORDER(4, CompletionStatus.COMPLETED_NO);
        }
    }

    public boolean work_pending() {
        if (!this.run) {
            throw new BAD_INV_ORDER(4, CompletionStatus.COMPLETED_NO);
        }
        return false;
    }

    public ValueFactory register_value_factory(String id, ValueFactory factory) {
        return this.valueFactories.put(id, factory);
    }

    public void unregister_value_factory(String id) {
        this.valueFactories.remove(id);
    }

    public ValueFactory lookup_value_factory(String id) {
        ValueFactory result = (ValueFactory)this.valueFactories.get(id);
        if (result == null && id.startsWith("IDL")) {
            String valueName = RepositoryID.className(id, null);
            result = this.findValueFactory(valueName);
            this.valueFactories.put(id, result);
        }
        return result;
    }

    private ValueFactory findValueFactory(String valueName) {
        Class result = null;
        result = this.findClass(valueName + "DefaultFactory", true);
        if (result != null) {
            return (ValueFactory)this.instantiate(result);
        }
        Class c = this.findClass(valueName, false);
        result = this.findClass(valueName + "Impl", false);
        if (result != null && c.isAssignableFrom(result)) {
            if ((class$org$omg$CORBA$portable$ValueFactory == null ? (class$org$omg$CORBA$portable$ValueFactory = ORB.class$("org.omg.CORBA.portable.ValueFactory")) : class$org$omg$CORBA$portable$ValueFactory).isAssignableFrom(result)) {
                return (ValueFactory)this.instantiate(result);
            }
            return new JacORBValueFactory(result);
        }
        return null;
    }

    private Class findClass(String name, boolean orgomg) {
        Class result;
        block4: {
            result = null;
            try {
                result = ObjectUtil.classForName(name);
            }
            catch (ClassNotFoundException e) {
                if (!orgomg || !name.startsWith("org.omg")) break block4;
                try {
                    result = ObjectUtil.classForName("omg.org" + name.substring(7));
                }
                catch (ClassNotFoundException x) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private java.lang.Object instantiate(Class c) {
        try {
            return c.newInstance();
        }
        catch (IllegalAccessException e1) {
            throw new RuntimeException("cannot instantiate class " + c.getName() + " (IllegalAccessException)");
        }
        catch (InstantiationException e2) {
            throw new RuntimeException("cannot instantiate class " + c.getName() + " (InstantiationException)");
        }
    }

    public BoxedValueHelper getBoxedValueHelper(String repId) {
        BoxedValueHelper result = (BoxedValueHelper)this.boxedValueHelpers.get(repId);
        if (result == null) {
            if (this.boxedValueHelpers.containsKey(repId)) {
                return null;
            }
            result = RepositoryID.createBoxedValueHelper(repId, null);
            this.boxedValueHelpers.put(repId, result);
        }
        return result;
    }

    public boolean hasClientRequestInterceptors() {
        return this.hasClientInterceptors;
    }

    public boolean hasServerRequestInterceptors() {
        return this.hasServerInterceptors;
    }

    public boolean hasRequestInterceptors() {
        return this.hasServerInterceptors || this.hasClientInterceptors;
    }

    public InterceptorManager getInterceptorManager() {
        return this.interceptor_manager;
    }

    public TransportManager getTransportManager() {
        if (this.transport_manager == null) {
            this.transport_manager = new TransportManager(this);
            try {
                this.transport_manager.configure((Configuration)this.configuration);
            }
            catch (ConfigurationException ce) {
                throw new INTERNAL(ce.getMessage());
            }
        }
        return this.transport_manager;
    }

    public org.omg.CORBA.ExceptionList create_exception_list() {
        return new ExceptionList();
    }

    public org.omg.CORBA.NVList create_list(int count) {
        return new NVList(this, count);
    }

    public org.omg.CORBA.NamedValue create_named_value(String name, Any value, int flags) {
        return new NamedValue(name, value, flags);
    }

    public org.omg.CORBA.NVList create_operation_list(Object obj) {
        if (!(obj instanceof OperationDef)) {
            throw new BAD_PARAM("Argument must be of type org.omg.CORBA.OperationDef");
        }
        OperationDef oper = (OperationDef)obj;
        return this.create_operation_list(oper);
    }

    public org.omg.CORBA.NVList create_operation_list(OperationDef oper) {
        int no = 0;
        ParameterDescription[] params = null;
        params = oper.params();
        if (params != null) {
            no = params.length;
        }
        NVList list = new NVList(this, no);
        for (int i = 0; i < no; ++i) {
            ParameterDescription param = params[i];
            Any any = this.create_any();
            any.type(param.type);
            ((org.omg.CORBA.NVList)list).add_value(param.name, any, param.mode.value());
        }
        return list;
    }

    private void configureObjectKeyMap(Configuration config) {
        String[] names = config.getAttributeNames();
        String prefix = "jacorb.orb.objectKeyMap.";
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].startsWith(prefix)) continue;
            this.objectKeyMap.put(names[i].substring(prefix.length()), config.getAttribute(names[i], ""));
        }
    }

    public void addObjectKey(String key_name, String full_path) {
        this.objectKeyMap.put(key_name, full_path);
    }

    public byte[] mapObjectKey(byte[] originalKey) {
        java.lang.Object br = null;
        java.lang.Object iorFile = null;
        ParsedIOR pIOR = null;
        String found = null;
        String original = null;
        if (this.objectKeyMap.size() != 0 && (found = (String)this.objectKeyMap.get(original = new String(originalKey))) != null) {
            if (ParsedIOR.isParsableProtocol(found)) {
                try {
                    pIOR = new ParsedIOR(found, this, this.logger);
                    return pIOR.get_object_key();
                }
                catch (IllegalArgumentException e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Error - could not read protocol " + found);
                    }
                    return originalKey;
                }
            }
            return CorbaLoc.parseKey(found);
        }
        return originalKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Object obj) {
        if (!(obj instanceof ObjectImpl)) {
            throw new BAD_PARAM("connect parameter must extend org.omg.CORBA.portable.ObjectImpl");
        }
        if (!(obj instanceof InvokeHandler)) {
            throw new BAD_PARAM("connect parameter must implement org.omg.CORBA.portable.InvokeHandler");
        }
        Map map = this.connectedObjects;
        synchronized (map) {
            block10: {
                if (!this.connectedObjects.containsKey(obj)) {
                    ObjectImpl objectImpl = (ObjectImpl)obj;
                    HandlerWrapper servant = new HandlerWrapper(objectImpl);
                    Object ref = servant._this_object(this);
                    objectImpl._set_delegate(((ObjectImpl)ref)._get_delegate());
                    this.connectedObjects.put(obj, servant);
                    if (this.firstConnection) {
                        this.firstConnection = false;
                        POAManager rootPOAManager = this.getRootPOA().the_POAManager();
                        if (rootPOAManager.get_state() == State.HOLDING) {
                            try {
                                rootPOAManager.activate();
                            }
                            catch (AdapterInactive adapterInactive) {
                                if (!this.logger.isErrorEnabled()) break block10;
                                this.logger.error(adapterInactive.getMessage());
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(Object obj) {
        if (!(obj instanceof ObjectImpl)) {
            throw new BAD_PARAM("disconnect parameter must extend org.omg.CORBA.portable.ObjectImpl");
        }
        if (!(obj instanceof InvokeHandler)) {
            throw new BAD_PARAM("disconnect parameter must implement org.omg.CORBA.portable.InvokeHandler");
        }
        Map map = this.connectedObjects;
        synchronized (map) {
            block8: {
                Servant servant = (Servant)this.connectedObjects.get(obj);
                if (servant != null) {
                    this.connectedObjects.remove(obj);
                    try {
                        this.getRootPOA().deactivate_object(this.getRootPOA().servant_to_id(servant));
                    }
                    catch (Exception e) {
                        if (!this.logger.isErrorEnabled()) break block8;
                        this.logger.error(e.getMessage());
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        services = new String[]{"RootPOA", "POACurrent", "DynAnyFactory", "PICurrent", "CodecFactory"};
    }

    static class HandlerWrapper
    extends Servant
    implements InvokeHandler {
        private InvokeHandler wrappedHandler;

        public HandlerWrapper(ObjectImpl objectImpl) {
            this.wrappedHandler = (InvokeHandler)((java.lang.Object)objectImpl);
        }

        public String[] _all_interfaces(POA poa, byte[] objectID) {
            return ((ObjectImpl)((java.lang.Object)this.wrappedHandler))._ids();
        }

        public OutputStream _invoke(String method, org.omg.CORBA.portable.InputStream input, ResponseHandler handler) throws SystemException {
            return this.wrappedHandler._invoke(method, input, handler);
        }
    }

    private class PICurrent
    extends LocalObject
    implements org.omg.PortableInterceptor.Current {
        private PICurrent() {
        }

        private org.omg.PortableInterceptor.Current getTarget() {
            if (ORB.this.interceptor_manager == null) {
                return InterceptorManager.EMPTY_CURRENT;
            }
            return ORB.this.interceptor_manager.getCurrent();
        }

        public Any get_slot(int id) throws InvalidSlot {
            return this.getTarget().get_slot(id);
        }

        public void set_slot(int id, Any data) throws InvalidSlot {
            this.getTarget().set_slot(id, data);
        }
    }

    private class JacORBValueFactory
    implements ValueFactory {
        private Class implementationClass;

        public JacORBValueFactory(Class c) {
            this.implementationClass = c;
        }

        public Serializable read_value(InputStream is) {
            StreamableValue value = (StreamableValue)ORB.this.instantiate(this.implementationClass);
            return is.read_value(value);
        }
    }
}

