/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UnknownUserException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.InputStream;
import org.omg.Messaging.ExceptionHolder;

public class ExceptionHolderImpl
extends ExceptionHolder
implements Configurable {
    private Logger logger = null;

    public ExceptionHolderImpl(ReplyInputStream is) {
        int status = is.getStatus().value();
        if (status == 1) {
            this.is_system_exception = false;
        } else if (status == 2) {
            this.is_system_exception = true;
        } else {
            throw new RuntimeException("attempt to create ExceptionHolder for non-exception reply");
        }
        this.byte_order = is.littleEndian;
        this.marshaled_exception = is.getBody();
    }

    public ExceptionHolderImpl(SystemException ex) {
        this.is_system_exception = true;
        this.byte_order = false;
        CDROutputStream output = new CDROutputStream();
        SystemExceptionHelper.write(output, ex);
        this.marshaled_exception = output.getBufferCopy();
    }

    public ExceptionHolderImpl() {
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.orb.exc_holder");
    }

    public void raise_exception() throws UserException {
        String id;
        CDRInputStream input;
        block5: {
            input = new CDRInputStream(null, this.marshaled_exception, this.byte_order);
            if (this.is_system_exception) {
                throw SystemExceptionHelper.read(input);
            }
            input.mark(0);
            id = input.read_string();
            try {
                input.reset();
            }
            catch (IOException ioe) {
                if (!this.logger.isWarnEnabled()) break block5;
                this.logger.warn("Unexpected IOException: " + ioe.getMessage());
            }
        }
        UserException result = null;
        try {
            result = this.exceptionFromHelper(id, input);
        }
        catch (Exception e) {
            throw new UnknownUserException();
        }
        throw result;
    }

    public void raise_exception_with_list(ExceptionList exc_list) throws UserException {
        throw new NO_IMPLEMENT("raise_exception_with_list not yet implemented");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.marshaled_exception.length; ++i) {
            result.append(this.marshaled_exception[i] + "(" + (char)this.marshaled_exception[i] + ")  ");
        }
        return result.toString();
    }

    public UserException exceptionFromHelper(String id, InputStream input) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String name = RepositoryID.className(id, "Helper", null);
        Class helper = ObjectUtil.classForName(name);
        Method readMethod = helper.getMethod("read", ObjectUtil.classForName("org.omg.CORBA.portable.InputStream"));
        Object result = readMethod.invoke(null, input);
        return (UserException)result;
    }

    public byte[] marshal() {
        byte[] buffer = BufferManager.getInstance().getBuffer(this.marshaled_exception.length + 128);
        CDROutputStream output = new CDROutputStream(buffer);
        output.write_value((Serializable)this, "IDL:omg.org/Messaging/ExceptionHolder:1.0");
        return buffer;
    }
}

