/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import org.jacorb.util.ObjectUtil;

public abstract class PatternWrapper {
    private static final RuntimeException REGEXP_NOT_AVAILABLE = new RuntimeException("Neither java.util.regex.Pattern nor gnu.regexp available. The package java.util.regex is part of the JDK since v1.4 if you are running an older JDK you'll have to install gnu.regexp or jakarta.regexp to run this NotificationService. Please refer to the documentation for details.");
    private static Class sDefaultInstance = null;

    static PatternWrapper init(String patternString) {
        try {
            PatternWrapper _wrapper = (PatternWrapper)sDefaultInstance.newInstance();
            _wrapper.compile(patternString);
            return _wrapper;
        }
        catch (Exception e) {
            if (sDefaultInstance == null) {
                throw REGEXP_NOT_AVAILABLE;
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    public abstract void compile(String var1);

    public abstract int match(String var1);

    private static boolean isClassAvailable(String name) {
        try {
            ObjectUtil.classForName(name);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static {
        if (PatternWrapper.isClassAvailable("java.util.regex.Pattern")) {
            try {
                sDefaultInstance = ObjectUtil.classForName("org.jacorb.notification.util.JDK14PatternWrapper");
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (sDefaultInstance == null && PatternWrapper.isClassAvailable("org.apache.regexp.RE")) {
            try {
                sDefaultInstance = ObjectUtil.classForName("org.jacorb.notification.util.JakartaRegexpPatternWrapper");
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (sDefaultInstance == null && PatternWrapper.isClassAvailable("gnu.regexp.RE")) {
            try {
                sDefaultInstance = ObjectUtil.classForName("org.jacorb.notification.util.GNUPatternWrapper");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        if (sDefaultInstance == null) {
            throw REGEXP_NOT_AVAILABLE;
        }
    }
}

