/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import java.util.ArrayList;
import org.jacorb.notification.util.PatternWrapper;
import org.jacorb.notification.util.WCEntry;
import org.jacorb.notification.util.WildcardMap;

class EntryList {
    private static int DEFAULT_INITIAL_SIZE = 2;
    private PatternWrapper myPattern_;
    private char[] key_;
    private int start_;
    private int end_;
    private int depth_;
    private int splitted = 0;
    private WCEntry myEntry_;
    private EntryList[] entries_;

    EntryList(int size) {
        this(null, 0, 0, 0, null, size);
    }

    private EntryList(char[] key, int start, int end, int depth, WCEntry value) {
        this(key, start, end, depth, value, DEFAULT_INITIAL_SIZE);
    }

    private EntryList(char[] key, int start, int end, int depth, WCEntry entry, int size) {
        this.myEntry_ = entry;
        this.key_ = key;
        this.end_ = end;
        this.start_ = start;
        this.depth_ = depth;
        this.entries_ = new EntryList[size];
        this.initPattern(this.key_, this.start_, this.end_);
    }

    private boolean hasEntry() {
        return this.myEntry_ != null;
    }

    void clear() {
        this.entries_ = new EntryList[DEFAULT_INITIAL_SIZE];
    }

    Object put(WCEntry entry) {
        char _first = entry.key_[0];
        this.ensureIndexIsAvailable(_first);
        int _idx = this.computeHashIndex(_first);
        if (this.entries_[_idx] == null) {
            this.entries_[_idx] = new EntryList(entry.key_, 0, entry.key_.length, 0, entry);
            return null;
        }
        return this.entries_[_idx].put(entry.key_, 0, entry.key_.length, 0, entry, false);
    }

    Object put(char[] key, int start, int stop, int depth, WCEntry value, boolean addLeadingStar) {
        int _insertKeyLength = stop - start;
        int _myKeyLength = this.end_ - this.start_;
        int _prefixLength = this.findCommonPrefix(key, start, stop);
        if (_prefixLength == _insertKeyLength) {
            if (this.endsWithStar()) {
                EntryList.splitEntryList(this, _prefixLength);
            }
            Object _old = null;
            if (this.myEntry_ != null) {
                _old = this.myEntry_.getValue();
            }
            this.myEntry_ = value;
            return _old;
        }
        if (_prefixLength < _myKeyLength) {
            EntryList.splitEntryList(this, _prefixLength);
            boolean _addStar = false;
            if (this.endsWithStar()) {
                _addStar = true;
            }
            this.put(key, start, stop, depth + _prefixLength, value, _addStar);
        } else {
            char _firstRemainingChar = key[start + _prefixLength];
            this.ensureIndexIsAvailable(_firstRemainingChar);
            int idx = this.computeHashIndex(_firstRemainingChar);
            if (this.entries_[idx] == null) {
                this.entries_[idx] = new EntryList(key, start + _prefixLength, stop, this.depth_ + _prefixLength, value);
                if (addLeadingStar) {
                    this.entries_[idx].addLeadingStar();
                }
            } else {
                this.entries_[idx].put(key, start + _prefixLength, stop, depth + _prefixLength, value, false);
            }
        }
        return null;
    }

    Object getSingle(char[] key, int start, int stop) {
        EntryList _entryList = this.lookup(key[start]);
        int _position = start;
        while (_entryList != null) {
            int _remainingKeyLength = stop - _position;
            int _devoured = _entryList.compare(key, start + _entryList.depth_, start + _entryList.depth_ + _remainingKeyLength, false);
            if (_devoured == _remainingKeyLength) {
                return _entryList.myEntry_.getValue();
            }
            if (_devoured <= 0) continue;
            char _firstRemainingChar = key[start + _entryList.depth_ + _devoured];
            int _oldDepth = _entryList.depth_;
            if ((_entryList = _entryList.lookup(_firstRemainingChar)) == null) continue;
            _position += _entryList.depth_ - _oldDepth;
        }
        return null;
    }

    private boolean endsWithStar() {
        return this.key_[this.end_ - 1] == '*';
    }

    Object[] getMultiple(char[] key, int start, int stop) {
        ArrayList<Cursor> _toBeProcessed = new ArrayList<Cursor>();
        ArrayList<Object> _resultList = new ArrayList<Object>();
        EntryList _list = this.lookup(key[start]);
        if (_list != null) {
            _toBeProcessed.add(new Cursor(start, _list));
        }
        if ((_list = this.lookup('*')) != null) {
            Cursor _startCursor = new Cursor(start, _list);
            _toBeProcessed.add(_startCursor);
        }
        while (!_toBeProcessed.isEmpty()) {
            Cursor _currentCursor = (Cursor)_toBeProcessed.get(0);
            int _remainingKeyLength = stop - _currentCursor.cursor_;
            int _devoured = _currentCursor.list_.compare(key, start + _currentCursor.list_.depth_, start + _currentCursor.list_.depth_ + _remainingKeyLength, true);
            if (_devoured >= _remainingKeyLength) {
                if (_currentCursor.list_.hasEntry()) {
                    _resultList.add(_currentCursor.list_.myEntry_.getValue());
                }
                if (_remainingKeyLength > 0 && _currentCursor.list_.endsWithStar()) {
                    for (int x = 0; x < _currentCursor.list_.entries_.length; ++x) {
                        if (_currentCursor.list_.entries_[x] == null) continue;
                        _toBeProcessed.add(new Cursor(_currentCursor.list_.depth_ + 1, _currentCursor.list_.entries_[x]));
                    }
                }
                if (_currentCursor.list_.lookup('*') != null) {
                    _currentCursor.list_ = _currentCursor.list_.lookup('*');
                    _currentCursor.cursor_ += _devoured;
                    continue;
                }
                _toBeProcessed.remove(0);
                continue;
            }
            if (_devoured > 0) {
                char _firstRemainingChar = key[start + _currentCursor.list_.depth_ + _devoured];
                int _oldDepth = _currentCursor.list_.depth_;
                if (_currentCursor.list_.lookup('*') != null) {
                    EntryList _entryList = _currentCursor.list_.lookup('*');
                    _toBeProcessed.add(new Cursor(_currentCursor.cursor_ + _entryList.depth_ - _oldDepth, _entryList));
                }
                if ((_currentCursor.list_ = _currentCursor.list_.lookup(_firstRemainingChar)) != null) {
                    _currentCursor.cursor_ += _currentCursor.list_.depth_ - _oldDepth;
                    continue;
                }
                _toBeProcessed.remove(0);
                continue;
            }
            _toBeProcessed.remove(0);
        }
        return _resultList.toArray();
    }

    Object remove(char[] key, int start, int stop) {
        return EntryList.remove(this, key, start, stop);
    }

    private static Object remove(EntryList l, char[] key, int start, int stop) {
        int _devoured;
        char _firstNext;
        int _cursor = start;
        EntryList _current = l;
        do {
            if ((_cursor += (_devoured = EntryList.findCommonPrefix(key, _cursor, stop, _current.key_, _current.start_, _current.end_))) != stop) continue;
            Object _old = null;
            if (_current.myEntry_ != null) {
                _old = _current.myEntry_.getValue();
                _current.myEntry_ = null;
            }
            return _old;
        } while ((_current = _current.lookup(_firstNext = key[start + _devoured])) != null);
        return null;
    }

    private void addLeadingStar() {
        int _newLength = this.end_ - this.start_ + 1;
        char[] _newKey = new char[_newLength];
        System.arraycopy(this.key_, this.start_, _newKey, 1, this.end_ - this.start_);
        _newKey[0] = 42;
        this.initPattern(_newKey, 0, _newLength);
    }

    private void initPattern() {
        this.initPattern(this.key_, this.start_, this.end_);
    }

    private void initPattern(char[] key, int start, int stop) {
        this.myPattern_ = null;
        int _starCount = WildcardMap.countStarsInKey(key, start, stop);
        if (_starCount > 0) {
            char[] _pattern = new char[stop - start + _starCount + 1];
            _pattern[0] = 94;
            int _offset = 1;
            for (int x = 0; x < stop - start; ++x) {
                char _x;
                _pattern[x + _offset] = _x = key[start + x];
                if (_pattern[x + _offset] != '*') continue;
                _pattern[x + _offset] = 46;
                _pattern[x + _offset + 1] = 42;
                ++_offset;
            }
            String _patternString = new String(_pattern, 0, stop - start + _starCount + 1);
            this.myPattern_ = PatternWrapper.init(_patternString);
        }
    }

    private char key() {
        return this.key_[this.start_];
    }

    private int keyLength() {
        return this.end_ - this.start_;
    }

    private EntryList lookup(char key) {
        int idx = this.computeHashIndex(key);
        if (this.entries_[idx] != null && this.entries_[idx].key() == key) {
            return this.entries_[idx];
        }
        return null;
    }

    private void ensureIndexIsAvailable(char key) {
        int idx = this.computeHashIndex(key);
        while (this.entries_[idx] != null && this.entries_[idx].key() != key) {
            this.doubleCapacity();
            idx = this.computeHashIndex(key);
        }
        return;
    }

    private void doubleCapacity() {
        int _newSize = this.entries_.length * 2;
        EntryList[] _newList = new EntryList[_newSize];
        for (int x = 0; x < this.entries_.length; ++x) {
            if (this.entries_[x] == null) continue;
            int _arrayPos = EntryList.computeHashIndex(this.entries_[x].key(), _newSize);
            _newList[_arrayPos] = this.entries_[x];
        }
        this.entries_ = _newList;
    }

    private int compare(char[] a, int start, int stop, boolean wildcard) {
        if (wildcard && this.myPattern_ != null) {
            return EntryList.compareKeyToPattern(a, start, stop, this.myPattern_);
        }
        return EntryList.compareKeyToKey(a, start, stop, this.key_, this.start_, this.end_);
    }

    private int findCommonPrefix(char[] key, int start, int stop) {
        return EntryList.findCommonPrefix(key, start, stop, this.key_, this.start_, this.end_);
    }

    private void printToStringBuffer(StringBuffer sb, String offset) {
        if (this.key_ != null) {
            sb.append(" --");
            sb.append(this.key());
            sb.append("-->\n");
            sb.append(offset);
            sb.append("depth: ");
            sb.append(this.depth_);
            sb.append("\n");
            sb.append(offset);
            sb.append("key: ");
            sb.append(new String(this.key_, this.start_, this.end_ - this.start_));
            sb.append("\n");
        }
        if (this.myEntry_ != null) {
            sb.append(offset + this.myEntry_);
            sb.append("\n");
        }
        for (int x = 0; x < this.entries_.length; ++x) {
            sb.append(offset + x);
            sb.append(":");
            if (this.entries_[x] == null) {
                sb.append("empty");
            } else {
                this.entries_[x].printToStringBuffer(sb, offset + "   ");
            }
            sb.append("\n");
        }
    }

    public String toString() {
        StringBuffer _b = new StringBuffer();
        this.printToStringBuffer(_b, "");
        return _b.toString();
    }

    private static void splitEntryList(EntryList list, int offset) {
        EntryList _ret = new EntryList(list.key_, list.start_ + offset, list.end_, list.depth_ + offset, list.myEntry_, list.entries_.length);
        System.arraycopy(list.entries_, 0, _ret.entries_, 0, list.entries_.length);
        list.entries_ = new EntryList[DEFAULT_INITIAL_SIZE];
        char _key = list.key_[list.start_ + offset];
        int _idx = EntryList.computeHashIndex(_key, list.entries_.length);
        list.entries_[_idx] = _ret;
        list.myEntry_ = null;
        ++list.splitted;
        list.end_ = list.start_ + offset;
        if (list.endsWithStar()) {
            _ret.addLeadingStar();
        }
        list.initPattern();
    }

    private static int computeHashIndex(char c, int size) {
        return c % size;
    }

    private int computeHashIndex(char c) {
        return EntryList.computeHashIndex(c, this.entries_.length);
    }

    static int compareKeyToKey(char[] firstKeyArray, int start1, int stop1, char[] secondKeyArray, int start2, int stop2) {
        int _ret;
        int length1 = stop1 - start1;
        int length2 = stop2 - start2;
        int _guard = length1 > length2 ? length2 : length1;
        for (_ret = 0; _ret < _guard; ++_ret) {
            if (firstKeyArray[start1 + _ret] == secondKeyArray[start2 + _ret]) continue;
            return _ret;
        }
        return _ret;
    }

    private static int compareKeyToPattern(char[] string1, int start1, int stop1, PatternWrapper p) {
        String _other = new String(string1, start1, stop1 - start1);
        return p.match(_other);
    }

    private static int findCommonPrefix(char[] key1, int start1, int stop1, char[] key2, int start2, int stop2) {
        int _x;
        int _guard;
        int _length1 = stop1 - start1;
        int _length2 = stop2 - start2;
        int n = _guard = _length1 >= _length2 ? _length2 : _length1;
        for (_x = 0; _x < _guard && key1[start1] == key2[start2]; ++_x) {
            ++start1;
            ++start2;
        }
        return _x;
    }

    private static class Cursor {
        int cursor_;
        EntryList list_;

        Cursor(int cursor, EntryList list) {
            this.cursor_ = cursor;
            this.list_ = list;
        }

        public String toString() {
            String _rest = new String(this.list_.key_, this.cursor_, this.list_.end_ - this.cursor_);
            return "Cursor: " + _rest;
        }
    }
}

