/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.Dependant;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.engine.RetryStrategy;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskProcessorRetryStrategy;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.queue.EventQueue;
import org.jacorb.notification.queue.EventQueueFactory;
import org.jacorb.notification.queue.EventQueueFactoryDependency;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.ProxyPullSupplierImpl;
import org.jacorb.notification.servant.ProxyPushSupplierImpl;
import org.jacorb.notification.servant.SequenceProxyPullSupplierImpl;
import org.jacorb.notification.servant.SequenceProxyPushSupplierImpl;
import org.jacorb.notification.servant.StructuredProxyPullSupplierImpl;
import org.jacorb.notification.servant.StructuredProxyPushSupplierImpl;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.PropertySetListener;
import org.jacorb.orb.ORB;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper;
import org.omg.CosNotifyChannelAdmin.ObtainInfoMode;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.NotifyPublish;
import org.omg.CosNotifyComm.NotifyPublishHelper;
import org.omg.CosNotifyComm.NotifyPublishOperations;
import org.omg.CosNotifyComm.NotifySubscribeOperations;

public abstract class AbstractProxySupplier
extends AbstractProxy
implements MessageConsumer,
NotifySubscribeOperations,
EventQueueFactoryDependency {
    private static final EventType[] EMPTY_EVENT_TYPE_ARRAY = new EventType[0];
    protected Runnable scheduleDeliverPendingMessagesOperation_;
    private TaskExecutor taskExecutor_;
    private Disposable disposeTaskExecutor_;
    private EventQueue pendingMessages_;
    private int errorThreshold_;
    private ConsumerAdmin consumerAdmin_;
    private EventQueueFactory eventQueueFactory_;
    private final java.lang.Object pendingMessagesRefLock_ = new java.lang.Object();
    private NotifyPublishOperations proxyOfferListener_;
    private NotifyPublish offerListener_;
    private boolean enabled_ = true;
    private PropertySetListener eventQueueConfigurationChangedCB = new PropertySetListener(){

        public void validateProperty(Property[] p, List errors) {
        }

        public void actionPropertySetChanged(PropertySet source) throws UnsupportedQoS {
            AbstractProxySupplier.this.configureEventQueue();
        }
    };

    public AbstractProxySupplier() {
    }

    protected AbstractProxySupplier(ChannelContext channelContext) {
        if (this.isPushSupplier()) {
            this.scheduleDeliverPendingMessagesOperation_ = new Runnable(){

                public void run() {
                    try {
                        AbstractProxySupplier.this.getTaskProcessor().scheduleTimedPushTask(AbstractProxySupplier.this);
                    }
                    catch (InterruptedException e) {
                        AbstractProxySupplier.this.logger_.fatalError("scheduleTimedPushTask failed", (Throwable)e);
                    }
                }
            };
        }
    }

    public void configure(Configuration conf) {
        super.configure(conf);
        this.errorThreshold_ = conf.getAttributeAsInteger("jacorb.notification.consumer.error_threshold", 3);
    }

    public final void setEventQueueFactory(EventQueueFactory factory) {
        this.eventQueueFactory_ = factory;
    }

    protected EventQueueFactory getEventQueueFactory() {
        return this.eventQueueFactory_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preActivate() throws UnsupportedQoS, Exception {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            this.pendingMessages_ = this.getEventQueueFactory().newEventQueue(this.qosSettings_);
        }
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set Error Threshold to : " + this.errorThreshold_);
        }
        this.qosSettings_.addPropertySetListener(new String[]{"OrderPolicy", "DiscardPolicy"}, this.eventQueueConfigurationChangedCB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureEventQueue() throws UnsupportedQoS {
        EventQueue _newQueue = this.getEventQueueFactory().newEventQueue(this.qosSettings_);
        try {
            java.lang.Object object = this.pendingMessagesRefLock_;
            synchronized (object) {
                if (!this.pendingMessages_.isEmpty()) {
                    Message[] _allEvents = this.pendingMessages_.getAllEvents(true);
                    for (int x = 0; x < _allEvents.length; ++x) {
                        _newQueue.put(_allEvents[x]);
                    }
                }
                this.pendingMessages_ = _newQueue;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public TaskExecutor getExecutor() {
        return this.taskExecutor_;
    }

    public void setTaskExecutor(TaskExecutor executor) {
        if (this.taskExecutor_ != null) {
            throw new IllegalArgumentException("TaskExecutor should be set only once!");
        }
        this.taskExecutor_ = executor;
    }

    public void setTaskExecutor(TaskExecutor executor, Disposable disposeTaskExecutor) {
        this.setTaskExecutor(executor);
        this.disposeTaskExecutor_ = disposeTaskExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingMessagesCount() {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            return this.pendingMessages_.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingData() {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            return !this.pendingMessages_.isEmpty();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueue(Message message) {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            this.pendingMessages_.put(message);
        }
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("added " + message + " to pending Messages.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message getMessageBlocking() throws InterruptedException {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            return this.pendingMessages_.getEvent(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message getMessageNoBlock() {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            try {
                return this.pendingMessages_.getEvent(false);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message[] getAllMessages() {
        java.lang.Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            try {
                return this.pendingMessages_.getAllEvents(false);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message[] getUpToMessages(int max) {
        try {
            java.lang.Object object = this.pendingMessagesRefLock_;
            synchronized (object) {
                return this.pendingMessages_.getEvents(max, false);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message[] getAtLeastMessages(int min) {
        try {
            java.lang.Object object = this.pendingMessagesRefLock_;
            synchronized (object) {
                if (this.pendingMessages_.getSize() >= min) {
                    return this.pendingMessages_.getAllEvents(true);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public int getErrorThreshold() {
        return this.errorThreshold_;
    }

    public final void dispose() {
        super.dispose();
        if (this.disposeTaskExecutor_ != null) {
            this.disposeTaskExecutor_.dispose();
        }
    }

    public final ConsumerAdmin MyAdmin() {
        return this.consumerAdmin_;
    }

    public final void subscription_change(EventType[] added, EventType[] removed) throws InvalidEventType {
        this.subscriptionManager_.subscription_change(added, removed);
    }

    public final EventType[] obtain_offered_types(ObtainInfoMode obtainInfoMode) {
        EventType[] _offeredTypes = EMPTY_EVENT_TYPE_ARRAY;
        switch (obtainInfoMode.value()) {
            case 1: {
                this.registerListener();
                _offeredTypes = this.offerManager_.obtain_offered_types();
                break;
            }
            case 0: {
                _offeredTypes = this.offerManager_.obtain_offered_types();
                this.removeListener();
                break;
            }
            case 3: {
                this.registerListener();
                break;
            }
            case 2: {
                this.removeListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal ObtainInfoMode");
            }
        }
        return _offeredTypes;
    }

    private void registerListener() {
        NotifyPublishOperations _listener;
        if (this.proxyOfferListener_ == null && (_listener = this.getOfferListener()) != null) {
            this.proxyOfferListener_ = new NotifyPublishOperations(){

                public void offer_change(EventType[] added, EventType[] removed) {
                    try {
                        _listener.offer_change(added, removed);
                    }
                    catch (NO_IMPLEMENT e) {
                        AbstractProxySupplier.this.logger_.info("disable offer_change for connected Consumer.", (Throwable)e);
                        AbstractProxySupplier.this.removeListener();
                    }
                    catch (InvalidEventType e) {
                        AbstractProxySupplier.this.logger_.error("invalid event type", (Throwable)e);
                    }
                    catch (Exception e) {
                        AbstractProxySupplier.this.logger_.error("offer_change failed", (Throwable)e);
                    }
                }
            };
            this.offerManager_.addListener(this.proxyOfferListener_);
        }
    }

    protected void removeListener() {
        if (this.proxyOfferListener_ != null) {
            this.offerManager_.removeListener(this.proxyOfferListener_);
            this.proxyOfferListener_ = null;
        }
    }

    final NotifyPublishOperations getOfferListener() {
        return this.offerListener_;
    }

    protected void connectClient(Object client) {
        super.connectClient(client);
        try {
            this.offerListener_ = NotifyPublishHelper.narrow(client);
            this.logger_.debug("successfully narrowed connecting Client to IF NotifyPublish");
        }
        catch (Throwable t) {
            this.logger_.info("disable offer_change for connecting Consumer");
        }
    }

    public synchronized void enableDelivery() {
        this.enabled_ = true;
    }

    public synchronized void disableDelivery() {
        this.enabled_ = false;
    }

    protected synchronized boolean isEnabled() {
        return this.enabled_;
    }

    /*
     * WARNING - void declaration
     */
    static AbstractProxySupplier newProxyPullSupplier(AbstractAdmin admin, ClientType clientType) {
        void var2_2;
        switch (clientType.value()) {
            case 0: {
                AbstractProxySupplier _servant = new ProxyPullSupplierImpl();
                break;
            }
            case 1: {
                AbstractProxySupplier _servant = new StructuredProxyPullSupplierImpl();
                break;
            }
            case 2: {
                AbstractProxySupplier _servant = new SequenceProxyPullSupplierImpl();
                break;
            }
            default: {
                throw new BAD_PARAM();
            }
        }
        admin.getChannelContext().resolveDependencies((Dependant)var2_2);
        var2_2.consumerAdmin_ = ConsumerAdminHelper.narrow(admin.activate());
        var2_2.configure((Configuration)((ORB)admin.getORB()).getConfiguration());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static AbstractProxySupplier newProxyPushSupplier(AbstractAdmin admin, ClientType clientType) {
        void var2_2;
        switch (clientType.value()) {
            case 0: {
                AbstractProxySupplier _servant = new ProxyPushSupplierImpl();
                break;
            }
            case 1: {
                AbstractProxySupplier _servant = new StructuredProxyPushSupplierImpl();
                break;
            }
            case 2: {
                AbstractProxySupplier _servant = new SequenceProxyPushSupplierImpl();
                break;
            }
            default: {
                throw new BAD_PARAM("The ClientType: " + clientType.value() + " is unknown");
            }
        }
        admin.getChannelContext().resolveDependencies((Dependant)var2_2);
        var2_2.consumerAdmin_ = ConsumerAdminHelper.narrow(admin.activate());
        var2_2.configure((Configuration)((ORB)admin.getORB()).getConfiguration());
        return var2_2;
    }

    public boolean isPushSupplier() {
        switch (this.MyType().value()) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    protected void handleFailedPushOperation(PushOperation operation, Throwable error) {
        if (RetryStrategy.isFatalException(error)) {
            if (this.logger_.isErrorEnabled()) {
                this.logger_.error("push raised " + error + ": will destroy ProxySupplier, " + "disconnect Consumer", error);
            }
            operation.dispose();
            this.dispose();
            return;
        }
        RetryStrategy _retry = this.getRetryStrategy(this, operation);
        try {
            _retry.retry();
        }
        catch (RetryException e) {
            this.logger_.error("retry failed", (Throwable)e);
            _retry.dispose();
            this.dispose();
        }
    }

    private RetryStrategy getRetryStrategy(MessageConsumer mc, PushOperation op) {
        return new TaskProcessorRetryStrategy(mc, op, this.getTaskProcessor());
    }

    public boolean isRetryAllowed() {
        return !this.isDisposed() && this.getErrorCounter() < this.getErrorThreshold();
    }
}

