/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.CollectionsWrapper;
import org.jacorb.notification.Dependant;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.MessageFactoryDependency;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.AbstractProxyConsumerI;
import org.jacorb.notification.servant.ProxyPullConsumerImpl;
import org.jacorb.notification.servant.ProxyPushConsumerImpl;
import org.jacorb.notification.servant.SequenceProxyPullConsumerImpl;
import org.jacorb.notification.servant.SequenceProxyPushConsumerImpl;
import org.jacorb.notification.servant.StructuredProxyPullConsumerImpl;
import org.jacorb.notification.servant.StructuredProxyPushConsumerImpl;
import org.jacorb.notification.util.EventTypeUtil;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.PropertySetListener;
import org.jacorb.orb.ORB;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.Property;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ObtainInfoMode;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.omg.CosNotifyChannelAdmin.SupplierAdminHelper;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.NotifyPublishOperations;
import org.omg.CosNotifyComm.NotifySubscribe;
import org.omg.CosNotifyComm.NotifySubscribeHelper;
import org.omg.CosNotifyComm.NotifySubscribeOperations;

abstract class AbstractProxyConsumer
extends AbstractProxy
implements AbstractProxyConsumerI,
NotifyPublishOperations,
MessageFactoryDependency {
    private static final EventType[] EMPTY_EVENT_TYPE_ARRAY = new EventType[0];
    private MessageFactory messageFactory_;
    private SynchronizedBoolean isStartTimeSupported_ = new SynchronizedBoolean(true);
    private SynchronizedBoolean isStopTimeSupported_ = new SynchronizedBoolean(true);
    private List subsequentDestinations_;
    private NotifySubscribeOperations proxySubscriptionListener_;
    private NotifySubscribe subscriptionListener_;
    private SupplierAdmin supplierAdmin_;
    private PropertySetListener reconfigureQoS_ = new PropertySetListener(){

        public void validateProperty(Property[] props, List errors) {
        }

        public void actionPropertySetChanged(PropertySet source) {
            AbstractProxyConsumer.this.configureStartTimeSupported();
            AbstractProxyConsumer.this.configureStopTimeSupported();
        }
    };

    AbstractProxyConsumer() {
    }

    protected MessageFactory getMessageFactory() {
        return this.messageFactory_;
    }

    public final void setMessageFactory(MessageFactory factory) {
        this.messageFactory_ = factory;
    }

    public final List getSubsequentFilterStages() {
        return this.subsequentDestinations_;
    }

    public void setSubsequentDestinations(List list) {
        this.subsequentDestinations_ = list;
    }

    public void preActivate() throws Exception {
        this.configureStartTimeSupported();
        this.configureStopTimeSupported();
        this.qosSettings_.addPropertySetListener(new String[]{"Priority", "Timeout", "StartTimeSupported", "StopTimeSupported"}, this.reconfigureQoS_);
    }

    private void configureStartTimeSupported() {
        try {
            this.isStartTimeSupported_.set(this.qosSettings_.get("StartTimeSupported").extract_boolean());
        }
        catch (Exception e) {
            this.isStartTimeSupported_.set("on".equals("on"));
        }
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set QoS: StartTimeSupported=" + this.isStartTimeSupported_);
        }
    }

    private void configureStopTimeSupported() {
        try {
            this.isStopTimeSupported_.set(this.qosSettings_.get("StopTimeSupported").extract_boolean());
        }
        catch (Exception e) {
            this.isStopTimeSupported_.set("on".equals("on"));
        }
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set QoS: StopTimeSupported=" + this.isStopTimeSupported_);
        }
    }

    protected void schedulePullTask(MessageSupplier target) {
        try {
            this.getTaskProcessor().scheduleTimedPullTask(target);
        }
        catch (InterruptedException e) {
            this.logger_.fatalError("failed to schedule pull for MessageSupplier", (Throwable)e);
        }
    }

    protected void checkMessageProperties(Message mesg) {
    }

    public FilterStage getFirstStage() {
        return this;
    }

    public boolean isTimeOutSupported() {
        return this.isStopTimeSupported_.get();
    }

    public boolean isStartTimeSupported() {
        return this.isStartTimeSupported_.get();
    }

    public final SupplierAdmin MyAdmin() {
        return this.supplierAdmin_;
    }

    public final MessageConsumer getMessageConsumer() {
        throw new UnsupportedOperationException();
    }

    public final boolean hasMessageConsumer() {
        return false;
    }

    public void offer_change(EventType[] added, EventType[] removed) throws InvalidEventType {
        this.offerManager_.offer_change(added, removed);
    }

    public final EventType[] obtain_subscription_types(ObtainInfoMode obtainInfoMode) {
        EventType[] _subscriptionTypes = EMPTY_EVENT_TYPE_ARRAY;
        switch (obtainInfoMode.value()) {
            case 1: {
                this.registerListener();
                _subscriptionTypes = this.subscriptionManager_.obtain_subscription_types();
                break;
            }
            case 0: {
                _subscriptionTypes = this.subscriptionManager_.obtain_subscription_types();
                this.removeListener();
                break;
            }
            case 3: {
                this.registerListener();
                break;
            }
            case 2: {
                this.removeListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal ObtainInfoMode: ObtainInfoMode." + obtainInfoMode.value());
            }
        }
        return _subscriptionTypes;
    }

    private void registerListener() {
        NotifySubscribeOperations _listener;
        if (this.proxySubscriptionListener_ == null && (_listener = this.getSubscriptionListener()) != null) {
            this.proxySubscriptionListener_ = new NotifySubscribeOperations(){

                public void subscription_change(EventType[] added, EventType[] removed) {
                    try {
                        _listener.subscription_change(added, removed);
                    }
                    catch (NO_IMPLEMENT e) {
                        AbstractProxyConsumer.this.logger_.info("disable subscription_change for Supplier", (Throwable)e);
                        AbstractProxyConsumer.this.removeListener();
                    }
                    catch (InvalidEventType e) {
                        if (AbstractProxyConsumer.this.logger_.isDebugEnabled()) {
                            AbstractProxyConsumer.this.logger_.debug("subscription_change(" + EventTypeUtil.toString(added) + ", " + EventTypeUtil.toString(removed) + ") failed", (Throwable)e);
                        } else {
                            AbstractProxyConsumer.this.logger_.error("invalid event type", (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        AbstractProxyConsumer.this.logger_.error("subscription change failed", (Throwable)e);
                    }
                }
            };
            this.subscriptionManager_.addListener(this.proxySubscriptionListener_);
        }
    }

    protected void removeListener() {
        if (this.proxySubscriptionListener_ != null) {
            this.subscriptionManager_.removeListener(this.proxySubscriptionListener_);
            this.proxySubscriptionListener_ = null;
        }
    }

    protected void connectClient(Object client) {
        super.connectClient(client);
        try {
            this.subscriptionListener_ = NotifySubscribeHelper.narrow(client);
            this.logger_.debug("successfully narrowed connecting Supplier to NotifySubscribe");
        }
        catch (Throwable t) {
            this.logger_.info("connecting Supplier does not support subscription_change");
        }
    }

    final NotifySubscribeOperations getSubscriptionListener() {
        return this.subscriptionListener_;
    }

    /*
     * WARNING - void declaration
     */
    static AbstractProxy newProxyPushConsumer(AbstractAdmin admin, ClientType clientType) {
        void var2_2;
        switch (clientType.value()) {
            case 0: {
                AbstractProxyConsumer _servant = new ProxyPushConsumerImpl();
                break;
            }
            case 1: {
                AbstractProxyConsumer _servant = new StructuredProxyPushConsumerImpl();
                break;
            }
            case 2: {
                AbstractProxyConsumer _servant = new SequenceProxyPushConsumerImpl();
                break;
            }
            default: {
                throw new BAD_PARAM("Invalid ClientType: ClientType." + clientType.value());
            }
        }
        admin.getChannelContext().resolveDependencies((Dependant)var2_2);
        var2_2.supplierAdmin_ = SupplierAdminHelper.narrow(admin.activate());
        var2_2.setSubsequentDestinations(CollectionsWrapper.singletonList(admin));
        var2_2.configure((Configuration)((ORB)admin.getORB()).getConfiguration());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static AbstractProxy newProxyPullConsumer(AbstractAdmin admin, ClientType clientType) {
        void var2_2;
        switch (clientType.value()) {
            case 0: {
                AbstractProxyConsumer _servant = new ProxyPullConsumerImpl();
                break;
            }
            case 1: {
                AbstractProxyConsumer _servant = new StructuredProxyPullConsumerImpl();
                break;
            }
            case 2: {
                AbstractProxyConsumer _servant = new SequenceProxyPullConsumerImpl();
                break;
            }
            default: {
                throw new BAD_PARAM("Invalid ClientType: ClientType." + clientType.value());
            }
        }
        admin.getChannelContext().resolveDependencies((Dependant)var2_2);
        var2_2.supplierAdmin_ = SupplierAdminHelper.narrow(admin.activate());
        var2_2.setSubsequentDestinations(CollectionsWrapper.singletonList(admin));
        var2_2.configure((Configuration)((ORB)admin.getORB()).getConfiguration());
        return var2_2;
    }
}

