/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import EDU.oswego.cs.dl.util.concurrent.Heap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.queue.HeapEntry;
import org.jacorb.notification.queue.QueueUtil;

public class BoundedPriorityEventQueue
extends AbstractBoundedEventQueue {
    private Heap heap_;
    private long counter_ = 0L;

    public BoundedPriorityEventQueue(int maxSize, EventQueueOverflowStrategy overflowStrategy) {
        super(maxSize, overflowStrategy);
        this.heap_ = new Heap(maxSize, QueueUtil.DESCENDING_PRIORITY_COMPARATOR);
    }

    BoundedPriorityEventQueue(int maxSize) {
        super(maxSize);
        this.heap_ = new Heap(maxSize, QueueUtil.DESCENDING_PRIORITY_COMPARATOR);
    }

    protected Message getNextElement() {
        return ((HeapEntry)this.heap_.extract()).event_;
    }

    protected Message getEarliestTimeout() {
        List _all = this.getAllElementsInternal();
        Collections.sort(_all, QueueUtil.ASCENDING_TIMEOUT_COMPARATOR);
        HeapEntry _earliest = (HeapEntry)_all.remove(0);
        Heap _newHeap = new Heap(_all.size(), QueueUtil.DESCENDING_PRIORITY_COMPARATOR);
        Iterator i = _all.iterator();
        while (i.hasNext()) {
            HeapEntry e = (HeapEntry)i.next();
            _newHeap.insert((Object)e);
        }
        this.heap_ = _newHeap;
        return _earliest.event_;
    }

    protected Message getOldestElement() {
        List _all = this.getAllElementsInternal();
        Collections.sort(_all, QueueUtil.ASCENDING_AGE_COMPARATOR);
        HeapEntry _oldest = (HeapEntry)_all.remove(0);
        int _capacity = _all.size();
        if (_capacity <= 0) {
            _capacity = 5;
        }
        Heap _newHeap = new Heap(_capacity, QueueUtil.DESCENDING_PRIORITY_COMPARATOR);
        Iterator i = _all.iterator();
        while (i.hasNext()) {
            HeapEntry e = (HeapEntry)i.next();
            _newHeap.insert((Object)e);
        }
        return _oldest.event_;
    }

    protected Message getYoungestElement() {
        List _all = this.getAllElementsInternal();
        Collections.sort(_all, QueueUtil.DESCENDING_AGE_COMPARATOR);
        HeapEntry _youngest = (HeapEntry)_all.remove(0);
        Heap _newHeap = new Heap(_all.size(), QueueUtil.DESCENDING_PRIORITY_COMPARATOR);
        Iterator i = _all.iterator();
        while (i.hasNext()) {
            HeapEntry e = (HeapEntry)i.next();
            _newHeap.insert((Object)e);
        }
        this.heap_ = _newHeap;
        return _youngest.event_;
    }

    protected Message getLeastPriority() {
        List _all = this.getAllElementsInternal();
        Collections.sort(_all, QueueUtil.ASCENDING_PRIORITY_COMPARATOR);
        HeapEntry _leastPriority = (HeapEntry)_all.remove(0);
        Heap _newHeap = new Heap(_all.size(), QueueUtil.DESCENDING_PRIORITY_COMPARATOR);
        Iterator i = _all.iterator();
        while (i.hasNext()) {
            HeapEntry e = (HeapEntry)i.next();
            _newHeap.insert((Object)e);
        }
        this.heap_ = _newHeap;
        return _leastPriority.event_;
    }

    protected Message[] getElements(int max) {
        Object _element;
        ArrayList<Message> _events = new ArrayList<Message>();
        while ((_element = this.heap_.extract()) != null && _events.size() <= max) {
            _events.add(((HeapEntry)_element).event_);
        }
        return _events.toArray(QueueUtil.NOTIFICATION_EVENT_ARRAY_TEMPLATE);
    }

    protected void addElement(Message event) {
        this.heap_.insert((Object)new HeapEntry(event, this.counter_++));
    }

    private List getAllElementsInternal() {
        Object _element;
        ArrayList<Object> _events = new ArrayList<Object>();
        while ((_element = this.heap_.extract()) != null) {
            _events.add(_element);
        }
        return _events;
    }

    protected Message[] getAllElements() {
        List _all = this.getAllElementsInternal();
        Message[] _ret = new Message[_all.size()];
        Iterator i = _all.iterator();
        int x = 0;
        while (i.hasNext()) {
            HeapEntry e = (HeapEntry)i.next();
            _ret[x++] = e.event_;
        }
        return _ret;
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public int getSize() {
        return this.heap_.size();
    }
}

