/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.EventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;

public abstract class AbstractBoundedEventQueue
implements EventQueue {
    private Object lock_ = new Object();
    private int capacity_;
    private EventQueueOverflowStrategy overflowStrategy_;

    protected AbstractBoundedEventQueue(int capacity, EventQueueOverflowStrategy overflowStrategy) {
        this.capacity_ = capacity;
        this.overflowStrategy_ = overflowStrategy;
    }

    protected AbstractBoundedEventQueue(int capacity) {
        this.capacity_ = capacity;
    }

    void setOverflowStrategy(EventQueueOverflowStrategy overflowStrategy) {
        this.overflowStrategy_ = overflowStrategy;
    }

    protected abstract Message getEarliestTimeout();

    protected abstract Message getLeastPriority();

    protected abstract Message getNextElement();

    protected abstract Message getOldestElement();

    protected abstract Message getYoungestElement();

    protected abstract Message[] getElements(int var1);

    protected abstract void addElement(Message var1);

    protected abstract Message[] getAllElements();

    private void fireEventDiscarded(Message event) {
    }

    public Message[] getAllEvents(boolean wait) throws InterruptedException {
        if (wait) {
            return this.getAllBlocking();
        }
        return this.getAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message[] getAllBlocking() throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.isEmpty()) {
                this.lock_.wait();
            }
            return this.getAllElements();
        }
    }

    public Message getEvent(boolean wait) throws InterruptedException {
        if (wait) {
            return this.getEventBlocking();
        }
        if (this.isEmpty()) {
            return null;
        }
        return this.getNextElement();
    }

    public Message[] getEvents(int max, boolean wait) throws InterruptedException {
        if (wait) {
            return this.getEventsBlocking(max);
        }
        return this.getElements(max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message[] getEventsBlocking(int max) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.isEmpty()) {
                this.lock_.wait();
            }
            return this.getElements(max);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message getEventBlocking() throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.isEmpty()) {
                this.lock_.wait();
            }
            return this.getOldestElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Message event) {
        Object object = this.lock_;
        synchronized (object) {
            while (this.getSize() >= this.capacity_) {
                Message _e = this.overflowStrategy_.removeElementFromQueue(this);
                this.fireEventDiscarded(_e);
            }
            this.addElement(event);
            this.lock_.notifyAll();
        }
    }
}

