/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.Token;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.UnaryOperator;
import org.jacorb.notification.filter.etcl.VisitorException;
import org.omg.CORBA.TCKind;

public class AndOperator
extends UnaryOperator {
    static final String NAME = "AndOperator";

    public AndOperator(Token tok) {
        super(tok);
        this.setKind(TCKind.tk_boolean);
    }

    public String toString() {
        return "and";
    }

    public EvaluationResult evaluate(EvaluationContext context, EvaluationResult left) throws EvaluationException {
        boolean _l = left.getBool();
        if (!_l) {
            return EvaluationResult.BOOL_FALSE;
        }
        boolean _r = this.right().evaluate(context).getBool();
        return _r ? EvaluationResult.BOOL_TRUE : EvaluationResult.BOOL_FALSE;
    }

    public boolean isStatic() {
        return this.left().isStatic() && this.right().isStatic();
    }

    public void acceptInOrder(AbstractTCLVisitor visitor) throws VisitorException {
        this.left().acceptInOrder(visitor);
        visitor.visitAnd(this);
        this.right().acceptInOrder(visitor);
    }

    public void acceptPreOrder(AbstractTCLVisitor visitor) throws VisitorException {
        visitor.visitAnd(this);
        this.left().acceptPreOrder(visitor);
        this.right().acceptPreOrder(visitor);
    }

    public void acceptPostOrder(AbstractTCLVisitor visitor) throws VisitorException {
        this.left().acceptPostOrder(visitor);
        this.right().acceptPostOrder(visitor);
        visitor.visitAnd(this);
    }

    public String getName() {
        return NAME;
    }
}

