/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.engine.RetryStrategy;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.MessageConsumer;

public class TaskProcessorRetryStrategy
extends RetryStrategy {
    private Runnable retryPushOperation_ = new Runnable(){

        public void run() {
            try {
                TaskProcessorRetryStrategy.this.pushOperation_.invokePush();
                TaskProcessorRetryStrategy.this.taskProcessor_.scheduleTimedPushTask(TaskProcessorRetryStrategy.this.messageConsumer_);
            }
            catch (Throwable error) {
                try {
                    TaskProcessorRetryStrategy.this.remoteExceptionOccured(error);
                    TaskProcessorRetryStrategy.this.retry();
                }
                catch (RetryException e) {
                    TaskProcessorRetryStrategy.this.dispose();
                }
            }
        }
    };
    private Runnable enableMessageConsumer_ = new Runnable(){

        public void run() {
            try {
                TaskProcessorRetryStrategy.this.messageConsumer_.enableDelivery();
                TaskExecutor _executor = TaskProcessorRetryStrategy.this.messageConsumer_.getExecutor();
                _executor.execute(TaskProcessorRetryStrategy.this.retryPushOperation_);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };
    private final TaskProcessor taskProcessor_;
    private final long backoutInterval_;

    public TaskProcessorRetryStrategy(MessageConsumer mc, PushOperation op, TaskProcessor tp) {
        super(mc, op);
        this.taskProcessor_ = tp;
        this.backoutInterval_ = tp.getBackoutInterval();
    }

    protected long getTimeToWait() {
        return 0L;
    }

    protected void retryInternal() throws RetryException {
        this.messageConsumer_.disableDelivery();
        this.taskProcessor_.executeTaskAfterDelay(this.backoutInterval_, this.enableMessageConsumer_);
    }
}

