/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.Date;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.engine.AbstractFilterTask;
import org.jacorb.notification.engine.FilterProxyConsumerTask;
import org.jacorb.notification.engine.PullFromSupplierTask;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.engine.TimerDeliverTask;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.omg.CORBA.Any;
import org.omg.CosNotification.StructuredEvent;

public class DefaultTaskProcessor
implements TaskProcessor,
Disposable,
Configurable {
    private Logger logger_ = null;
    private TaskExecutor matchTaskExecutor_;
    private TaskExecutor pushTaskExecutor_;
    private TaskExecutor pullTaskExecutor_;
    private ClockDaemon clockDaemon_ = new ClockDaemon();
    private TaskFactory taskFactory_;
    private long backoutInterval_;

    public DefaultTaskProcessor() {
        this.clockDaemon_.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable command) {
                Thread _t = new Thread(command);
                _t.setName("ClockDaemonThread");
                return _t;
            }
        });
    }

    public void configure(Configuration conf) {
        this.logger_ = ((org.jacorb.config.Configuration)conf).getNamedLogger(this.getClass().getName());
        this.logger_.info("create TaskProcessor");
        int value = conf.getAttributeAsInteger("jacorb.notification.proxyconsumer.thread_pool_size", 2);
        this.pullTaskExecutor_ = new TaskExecutor("PullThread", value, true);
        value = conf.getAttributeAsInteger("jacorb.notification.filter.thread_pool_size", 2);
        this.matchTaskExecutor_ = new TaskExecutor("FilterThread", value);
        this.backoutInterval_ = conf.getAttributeAsInteger("jacorb.notification.consumer.backout_interval", 2000);
        value = conf.getAttributeAsInteger("jacorb.notification.proxysupplier.thread_pool_size", 4);
        String _threadPolicy = conf.getAttribute("jacorb.notification.proxysupplier.threadpolicy", "ThreadPool");
        if ("ThreadPool".equals(_threadPolicy)) {
            this.pushTaskExecutor_ = new TaskExecutor("DeliverThread", value);
        } else if ("ThreadPerProxy".equals(_threadPolicy)) {
            this.pushTaskExecutor_ = null;
        } else {
            throw new IllegalArgumentException("The specified value: \"" + _threadPolicy + "\" specified in property: \"" + "jacorb.notification.proxysupplier.threadpolicy" + "\" is invalid");
        }
        this.taskFactory_ = new TaskFactory(this);
        this.taskFactory_.configure(conf);
    }

    public TaskFactory getTaskFactory() {
        return this.taskFactory_;
    }

    public long getBackoutInterval() {
        return this.backoutInterval_;
    }

    public void configureTaskExecutor(AbstractProxySupplier proxySupplier) {
        if (this.pushTaskExecutor_ != null) {
            proxySupplier.setTaskExecutor(this.pushTaskExecutor_);
        } else {
            final TaskExecutor _executor = new TaskExecutor("PerProxyDeliverThread", 1);
            Disposable _disposableDelegate = new Disposable(){

                public void dispose() {
                    _executor.dispose();
                }
            };
            proxySupplier.setTaskExecutor(_executor, _disposableDelegate);
        }
    }

    public TaskExecutor getFilterTaskExecutor() {
        return this.matchTaskExecutor_;
    }

    public void dispose() {
        this.logger_.info("shutdown TaskProcessor");
        this.clockDaemon_.shutDown();
        this.matchTaskExecutor_.dispose();
        if (this.pushTaskExecutor_ != null) {
            this.pushTaskExecutor_.dispose();
        }
        this.pullTaskExecutor_.dispose();
        this.taskFactory_.dispose();
        this.logger_.debug("shutdown complete");
    }

    public void processMessage(Message mesg) {
        if (mesg.hasStopTime()) {
            this.logger_.debug("Message has StopTime");
            if (mesg.getStopTime().getTime() <= System.currentTimeMillis()) {
                this.fireEventDiscarded(mesg);
                mesg.dispose();
                this.logger_.debug("Message Stoptime is passed already");
                return;
            }
            new DeferedStopTask(mesg);
        }
        if (mesg.hasTimeout()) {
            this.logger_.debug("Message has TimeOut");
            new TimeoutTask(mesg);
        }
        if (mesg.hasStartTime() && mesg.getStartTime().getTime() > System.currentTimeMillis()) {
            new DeferedStartTask(mesg);
        } else {
            this.processMessageInternal(mesg);
        }
    }

    protected void processMessageInternal(Message event) {
        this.logger_.debug("processMessageInternal");
        FilterProxyConsumerTask _task = this.taskFactory_.newFilterProxyConsumerTask(event);
        try {
            ((AbstractFilterTask)_task).schedule();
        }
        catch (InterruptedException ie) {
            this.logger_.error("Interrupt while scheduling FilterTask", (Throwable)ie);
        }
        catch (Throwable e) {
            this.logger_.error("Something else in PMI ", e);
        }
    }

    public void scheduleTimedPullTask(MessageSupplier dest) throws InterruptedException {
        PullFromSupplierTask _task = new PullFromSupplierTask(this.pullTaskExecutor_);
        _task.setTarget(dest);
        _task.schedule();
    }

    public void scheduleTimedPushTask(MessageConsumer consumer) throws InterruptedException {
        if (!consumer.isDisposed()) {
            TimerDeliverTask _task = new TimerDeliverTask(this);
            _task.setMessageConsumer(consumer);
            _task.schedule();
        } else {
            this.logger_.info("MessageConsumer is disposed");
        }
    }

    private ClockDaemon getClockDaemon() {
        return this.clockDaemon_;
    }

    public Object executeTaskPeriodically(long intervall, Runnable task, boolean startImmediately) {
        this.logger_.debug("executeTaskPeriodically");
        return this.getClockDaemon().executePeriodically(intervall, task, startImmediately);
    }

    public void cancelTask(Object id) {
        ClockDaemon.cancel((Object)id);
    }

    public Object executeTaskAfterDelay(long delay, Runnable task) {
        return this.clockDaemon_.executeAfterDelay(delay, task);
    }

    Object executeTaskAt(Date startTime, Runnable task) {
        return this.clockDaemon_.executeAt(startTime, task);
    }

    private void fireEventDiscarded(Message event) {
        switch (event.getType()) {
            case 0: {
                this.fireEventDiscarded(event.toAny());
                break;
            }
            case 1: {
                this.fireEventDiscarded(event.toStructuredEvent());
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void fireEventDiscarded(Any a) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Any: " + a + " has been discarded");
        }
    }

    private void fireEventDiscarded(StructuredEvent e) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("StructuredEvent: " + e + " has been discarded");
        }
    }

    class DeferedStartTask
    implements Runnable {
        Message message_;

        DeferedStartTask(Message m) {
            if (DefaultTaskProcessor.this.logger_.isDebugEnabled()) {
                DefaultTaskProcessor.this.logger_.debug("Message with Option StartTime=" + m.getStartTime() + " will be defered until then");
            }
            this.message_ = m;
            DefaultTaskProcessor.this.executeTaskAt(this.message_.getStartTime(), this);
        }

        public void run() {
            if (DefaultTaskProcessor.this.logger_.isDebugEnabled()) {
                DefaultTaskProcessor.this.logger_.debug("Defered Message " + this.message_ + " will be processed now");
            }
            DefaultTaskProcessor.this.processMessageInternal(this.message_);
        }
    }

    class DeferedStopTask
    implements Runnable {
        Message event_;

        DeferedStopTask(Message event) {
            this.event_ = event;
            DefaultTaskProcessor.this.executeTaskAt(event.getStopTime(), this);
        }

        public void run() {
            this.event_.actionTimeout();
        }
    }

    class TimeoutTask
    implements Runnable,
    Message.MessageStateListener {
        Object timerRegistration_;
        Message message_;

        TimeoutTask(Message message) {
            this.message_ = message;
            this.message_.setMessageStateListener(this);
            this.timerRegistration_ = DefaultTaskProcessor.this.executeTaskAfterDelay(message.getTimeout(), this);
        }

        public void actionLifetimeChanged(long timeout) {
            ClockDaemon.cancel((Object)this.timerRegistration_);
            this.timerRegistration_ = DefaultTaskProcessor.this.executeTaskAfterDelay(this.message_.getTimeout(), this);
        }

        public void run() {
            DefaultTaskProcessor.this.logger_.debug("run Timeout");
            this.message_.removeMessageStateListener();
            this.message_.actionTimeout();
        }
    }
}

