/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Date;
import org.jacorb.notification.AbstractMessage;
import org.jacorb.notification.NoTranslationException;
import org.jacorb.notification.filter.ComponentName;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.FilterUtils;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.TCKind;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.StructuredEventHelper;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.omg.TimeBase.TimeTHelper;
import org.omg.TimeBase.UtcT;
import org.omg.TimeBase.UtcTHelper;

public class StructuredEventMessage
extends AbstractMessage {
    private Any anyValue_;
    private StructuredEvent structuredEventValue_;
    private Property[] typedEventValue_;
    private boolean isTranslationPossible_ = true;
    private String constraintKey_;
    private Date startTime_ = null;
    private Date stopTime_ = null;
    private long timeout_ = 0L;
    private boolean isTimeoutSet_;
    private short priority_;

    public synchronized void setStructuredEvent(StructuredEvent structuredEvent, boolean startTimeSupported, boolean timeOutSupported) {
        this.structuredEventValue_ = structuredEvent;
        this.constraintKey_ = FilterUtils.calcConstraintKey(this.structuredEventValue_.header.fixed_header.event_type.domain_name, this.structuredEventValue_.header.fixed_header.event_type.type_name);
        this.parseQosSettings(startTimeSupported, timeOutSupported);
    }

    public synchronized void reset() {
        super.reset();
        this.anyValue_ = null;
        this.structuredEventValue_ = null;
        this.typedEventValue_ = null;
        this.isTranslationPossible_ = true;
        this.constraintKey_ = null;
        this.startTime_ = null;
        this.stopTime_ = null;
        this.priority_ = 0;
    }

    public int getType() {
        return 1;
    }

    public synchronized Any toAny() {
        if (this.anyValue_ == null) {
            this.anyValue_ = sOrb.create_any();
            StructuredEventHelper.insert(this.anyValue_, this.structuredEventValue_);
        }
        return this.anyValue_;
    }

    public synchronized StructuredEvent toStructuredEvent() {
        return this.structuredEventValue_;
    }

    public synchronized Property[] toTypedEvent() throws NoTranslationException {
        if (!this.isTranslationPossible_) {
            throw new NoTranslationException();
        }
        if (this.typedEventValue_ == null) {
            try {
                if (!this.structuredEventValue_.filterable_data[0].name.equals("operation")) {
                    throw new IllegalArgumentException();
                }
                if (!this.structuredEventValue_.filterable_data[0].value.type().kind().equals(TCKind.tk_string)) {
                    throw new IllegalArgumentException();
                }
                this.typedEventValue_ = this.structuredEventValue_.filterable_data;
            }
            catch (Exception e) {
                this.isTranslationPossible_ = false;
                throw new NoTranslationException();
            }
        }
        return this.typedEventValue_;
    }

    public String getConstraintKey() {
        return this.constraintKey_;
    }

    public EvaluationResult extractFilterableData(EvaluationContext context, ComponentName root, String v) throws EvaluationException {
        Any _any = context.getDynamicEvaluator().evaluatePropertyList(this.toStructuredEvent().filterable_data, v);
        return EvaluationResult.fromAny(_any);
    }

    public EvaluationResult extractVariableHeader(EvaluationContext context, ComponentName root, String v) throws EvaluationException {
        Any _any = context.getDynamicEvaluator().evaluatePropertyList(this.toStructuredEvent().header.variable_header, v);
        return EvaluationResult.fromAny(_any);
    }

    private void parseQosSettings(boolean startTimeSupported, boolean timeoutSupported) {
        Property[] props = this.toStructuredEvent().header.variable_header;
        for (int x = 0; x < props.length; ++x) {
            if (startTimeSupported && "StartTime".equals(props[x].name)) {
                this.startTime_ = new Date(StructuredEventMessage.unixTime(UtcTHelper.extract(props[x].value)));
                continue;
            }
            if ("StopTime".equals(props[x].name)) {
                this.stopTime_ = new Date(StructuredEventMessage.unixTime(UtcTHelper.extract(props[x].value)));
                continue;
            }
            if (timeoutSupported && "Timeout".equals(props[x].name)) {
                this.setTimeout(TimeTHelper.extract(props[x].value));
                continue;
            }
            if (!"Priority".equals(props[x].name)) continue;
            this.priority_ = props[x].value.extract_short();
        }
    }

    public static long unixTime(UtcT corbaTime) {
        long _unixTime = (corbaTime.time - 122192928000000000L) / 10000L;
        if (corbaTime.tdf != 0) {
            _unixTime -= (long)(corbaTime.tdf * 60000);
        }
        return _unixTime;
    }

    public boolean hasStartTime() {
        return this.startTime_ != null;
    }

    public Date getStartTime() {
        return this.startTime_;
    }

    public boolean hasStopTime() {
        return this.stopTime_ != null;
    }

    public Date getStopTime() {
        return this.stopTime_;
    }

    public boolean hasTimeout() {
        return this.isTimeoutSet_;
    }

    public long getTimeout() {
        return this.timeout_;
    }

    private void setTimeout(long timeout) {
        this.isTimeoutSet_ = true;
        this.timeout_ = timeout;
    }

    public boolean match(Filter filter) throws UnsupportedFilterableData {
        return filter.match_structured(this.toStructuredEvent());
    }

    public int getPriority() {
        return this.priority_;
    }

    public boolean match(MappingFilter filter, AnyHolder value) throws UnsupportedFilterableData {
        return filter.match_structured(this.toStructuredEvent(), value);
    }

    public String toString() {
        if (this.toStructuredEvent() == null) {
            return null;
        }
        return this.toStructuredEvent().toString();
    }
}

