/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.FilterCallback;
import org.jacorb.notification.SubscriptionChangeListener;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNotification.EventType;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterAdminOperations;
import org.omg.CosNotifyFilter.FilterNotFound;

public class FilterManager
implements FilterAdminOperations,
SubscriptionChangeListener,
Configurable {
    public static final FilterManager EMPTY_FILTER_MANAGER = new FilterManager(Collections.EMPTY_MAP);
    private static final Integer[] INTEGER_ARRAY_TEMPLATE = new Integer[0];
    private Map filters_;
    private ORB orb_;
    private final Object filtersLock_ = new Object();
    private boolean filtersModified_;
    private List filtersReadOnlyView_;
    private SynchronizedInt filterIdPool_ = new SynchronizedInt(0);
    private Map filterId2callbackId_ = new Hashtable();
    private Logger logger_ = null;
    private org.jacorb.config.Configuration config_ = null;

    protected FilterManager(Map filters) {
        this.filters_ = filters;
        this.filtersModified_ = true;
    }

    public FilterManager(ORB orb) {
        this(new HashMap());
        this.setORB(orb);
    }

    public void configure(Configuration conf) {
        this.config_ = (org.jacorb.config.Configuration)conf;
        this.logger_ = this.config_.getNamedLogger(this.getClass().getName());
    }

    private Integer getFilterId() {
        return new Integer(this.filterIdPool_.increment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add_filter(Filter filter) {
        Integer _key = this.getFilterId();
        if (this.logger_.isWarnEnabled()) {
            try {
                if (!((ObjectImpl)((Object)filter))._is_local()) {
                    this.logger_.warn("filter is not local!");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = this.filtersLock_;
        synchronized (object) {
            this.filters_.put(_key, filter);
            this.filtersModified_ = true;
        }
        return _key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove_filter(int filterId) throws FilterNotFound {
        Integer _key = new Integer(filterId);
        Object object = this.filtersLock_;
        synchronized (object) {
            if (this.filters_.containsKey(_key)) {
                this.filters_.remove(_key);
                this.filtersModified_ = true;
            } else {
                this.throwFilterNotFound(_key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter get_filter(int filterId) throws FilterNotFound {
        Filter _filter;
        Integer _key = new Integer(filterId);
        Object object = this.filtersLock_;
        synchronized (object) {
            _filter = (Filter)this.filters_.get(_key);
        }
        if (_filter == null) {
            this.throwFilterNotFound(_key);
            return null;
        }
        return _filter;
    }

    private void throwFilterNotFound(Integer filterId) throws FilterNotFound {
        throw new FilterNotFound("Filter with ID=" + filterId + " does not exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] get_all_filters() {
        Integer[] _keys;
        Object object = this.filtersLock_;
        synchronized (object) {
            _keys = this.filters_.keySet().toArray(INTEGER_ARRAY_TEMPLATE);
        }
        int[] _intKeys = new int[_keys.length];
        for (int x = 0; x < _keys.length; ++x) {
            _intKeys[x] = _keys[x];
        }
        return _intKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove_all_filters() {
        Object object = this.filtersLock_;
        synchronized (object) {
            this.filters_.clear();
            this.filtersModified_ = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFilters() {
        Object object = this.filtersLock_;
        synchronized (object) {
            if (this.filtersModified_) {
                ArrayList _filterReadOnlyView = new ArrayList();
                _filterReadOnlyView.addAll(this.filters_.values());
                this.filtersReadOnlyView_ = Collections.unmodifiableList(_filterReadOnlyView);
                this.filtersModified_ = false;
            }
        }
        return this.filtersReadOnlyView_;
    }

    public void subscriptionChangedForFilter(int filterId, EventType[] eventType1, EventType[] eventType2) {
    }

    private void attachFilterListener(int filterId, Filter filter) {
        FilterCallback filterCallback = new FilterCallback(this, this.getORB(), filterId, filter);
        filterCallback.configure((Configuration)this.config_);
        this.filterId2callbackId_.put(new Integer(filterId), filterCallback);
    }

    private void detachFilterListener(int filterId) {
        Integer key = new Integer(filterId);
        if (this.filterId2callbackId_.containsKey(key)) {
            FilterCallback filterCallback = (FilterCallback)this.filterId2callbackId_.remove(key);
            filterCallback.dispose();
        }
    }

    public ORB getORB() {
        return this.orb_;
    }

    public void setORB(ORB orb) {
        this.orb_ = orb;
    }
}

